/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset.offsetstorage;

import java.net.BindException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.server.broker.exception.OffsetStoreException;
import org.apache.inlong.tubemq.server.broker.offset.OffsetStorage;
import org.apache.inlong.tubemq.server.broker.offset.OffsetStorageInfo;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.fileconfig.ZKConfig;
import org.apache.inlong.tubemq.server.common.zookeeper.ZKUtil;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkOffsetStorage
implements OffsetStorage {
    private static final Logger logger = LoggerFactory.getLogger(ZkOffsetStorage.class);
    private final String tubeZkRoot;
    private final String consumerZkDir;
    private final boolean isBroker;
    private final int brokerId;
    private final String strBrokerId;
    private final ZKConfig zkConfig;
    private ZooKeeperWatcher zkw;

    public ZkOffsetStorage(ZKConfig zkConfig, boolean isBroker, int brokerId) {
        this.zkConfig = zkConfig;
        this.isBroker = isBroker;
        this.brokerId = brokerId;
        this.strBrokerId = String.valueOf(brokerId);
        this.tubeZkRoot = ZKUtil.normalizePath(this.zkConfig.getZkNodeRoot());
        this.consumerZkDir = this.tubeZkRoot + "/consumers-v3";
        try {
            this.zkw = new ZooKeeperWatcher(zkConfig);
        }
        catch (Throwable e) {
            BrokerSrvStatsHolder.incZKExcCnt();
            logger.error(new StringBuilder(256).append("[ZkOffsetStorage] Failed to connect ZooKeeper server (").append(this.zkConfig.getZkServerAddr()).append(") !").toString(), e);
            System.exit(1);
        }
        logger.info("[ZkOffsetStorage] ZooKeeper Offset Storage initiated!");
    }

    @Override
    public void close() {
        if (this.zkw != null) {
            logger.info("ZooKeeper Offset Storage closing .......");
            this.zkw.close();
            this.zkw = null;
            logger.info("ZooKeeper Offset Storage closed!");
        }
    }

    @Override
    public ConcurrentHashMap<String, OffsetStorageInfo> loadGroupStgInfo(String group) {
        return new ConcurrentHashMap<String, OffsetStorageInfo>();
    }

    @Override
    public boolean commitOffset(String group, Collection<OffsetStorageInfo> offsetInfoList, boolean isFailRetry) {
        if (this.zkw == null || offsetInfoList == null || offsetInfoList.isEmpty()) {
            return false;
        }
        StringBuilder sBuilder = new StringBuilder(512);
        if (isFailRetry) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.cfmOffset(sBuilder, group, offsetInfoList);
                    break;
                }
                catch (Exception e) {
                    logger.error("Error found when commit offsets to ZooKeeper with retry " + i, (Throwable)e);
                    try {
                        Thread.sleep(this.zkConfig.getZkSyncTimeMs());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        logger.error("InterruptedException when commit offset to ZooKeeper with retry " + i, (Throwable)ie);
                        return true;
                    }
                }
            }
        } else {
            try {
                this.cfmOffset(sBuilder, group, offsetInfoList);
            }
            catch (OffsetStoreException e) {
                logger.error("Error when commit offsets to ZooKeeper", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public OffsetStorageInfo loadOffset(String group, String topic, int partitionId) {
        String offsetZkInfo;
        String zkNode = new StringBuilder(512).append(this.consumerZkDir).append("/").append(group).append("/offsets/").append(topic).append("/").append(this.brokerId).append("-").append(partitionId).toString();
        try {
            offsetZkInfo = ZKUtil.readDataMaybeNull(this.zkw, zkNode);
        }
        catch (KeeperException e) {
            BrokerSrvStatsHolder.incZKExcCnt();
            logger.error("KeeperException during load offsets from ZooKeeper", (Throwable)e);
            return null;
        }
        if (offsetZkInfo == null) {
            return null;
        }
        String[] offsetInfoStrs = offsetZkInfo.split("-");
        return new OffsetStorageInfo(topic, this.brokerId, partitionId, 0L, Long.parseLong(offsetInfoStrs[1]), Long.parseLong(offsetInfoStrs[0]), false, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cfmOffset(StringBuilder sb, String group, Collection<OffsetStorageInfo> infoList) throws OffsetStoreException {
        sb.delete(0, sb.length());
        for (OffsetStorageInfo info : infoList) {
            long newOffset = -1L;
            long msgId = -1L;
            OffsetStorageInfo offsetStorageInfo = info;
            synchronized (offsetStorageInfo) {
                if (!info.isModified()) {
                    continue;
                }
                newOffset = info.getOffset();
                msgId = info.getMessageId();
                info.setModified(false);
            }
            String topic = info.getTopic();
            String offsetPath = sb.append(this.consumerZkDir).append("/").append(group).append("/offsets/").append(topic).append("/").append(info.getBrokerId()).append("-").append(info.getPartitionId()).toString();
            sb.delete(0, sb.length());
            String offsetData = sb.append(msgId).append("-").append(newOffset).toString();
            sb.delete(0, sb.length());
            try {
                ZKUtil.updatePersistentPath(this.zkw, offsetPath, offsetData);
            }
            catch (Throwable t) {
                BrokerSrvStatsHolder.incZKExcCnt();
                logger.error("Exception during commit offsets to ZooKeeper", t);
                throw new OffsetStoreException(t);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(sb.append("Committed offset, path=").append(offsetPath).append(", data=").append(offsetData).toString());
            sb.delete(0, sb.length());
        }
    }

    @Override
    public Map<Integer, Long> queryGroupOffsetInfo(String group, String topic, Set<Integer> partitionIds) {
        StringBuilder strBuff = new StringBuilder(512);
        String basePath = strBuff.append(this.consumerZkDir).append("/").append(group).append("/offsets/").append(topic).append("/").append(this.brokerId).append("-").toString();
        strBuff.delete(0, strBuff.length());
        HashMap<Integer, Long> offsetMap = new HashMap<Integer, Long>(partitionIds.size());
        for (Integer partitionId : partitionIds) {
            String offsetNode = strBuff.append(basePath).append(partitionId).toString();
            strBuff.delete(0, strBuff.length());
            try {
                String offsetZkInfo = ZKUtil.readDataMaybeNull(this.zkw, offsetNode);
                if (offsetZkInfo == null) {
                    offsetMap.put(partitionId, null);
                    continue;
                }
                String[] offsetInfoStrs = offsetZkInfo.split("-");
                offsetMap.put(partitionId, Long.parseLong(offsetInfoStrs[1]));
            }
            catch (Throwable e) {
                BrokerSrvStatsHolder.incZKExcCnt();
                offsetMap.put(partitionId, null);
            }
        }
        return offsetMap;
    }

    @Override
    public Map<String, Set<String>> queryGroupTopicInfo(Set<String> groups) {
        StringBuilder strBuff = new StringBuilder(512);
        String groupNode = strBuff.append(this.consumerZkDir).toString();
        strBuff.delete(0, strBuff.length());
        HashSet<String> tmpGroups = new HashSet<String>();
        HashMap<String, Set<String>> groupTopicMap = new HashMap<String, Set<String>>();
        if (groups == null) {
            List<String> bookedGroups = ZKUtil.getChildren(this.zkw, groupNode);
            if (bookedGroups != null) {
                tmpGroups.addAll(bookedGroups);
            }
        } else {
            tmpGroups.addAll(groups);
        }
        if (tmpGroups.isEmpty()) {
            return groupTopicMap;
        }
        for (String group : tmpGroups) {
            String topicNode = strBuff.append(groupNode).append("/").append(group).append("/offsets").toString();
            strBuff.delete(0, strBuff.length());
            List<String> consumeTopics = ZKUtil.getChildren(this.zkw, topicNode);
            HashSet<String> topicSet = new HashSet<String>();
            if (consumeTopics != null) {
                block1: for (String topic : consumeTopics) {
                    if (topic == null) continue;
                    String brokerNode = strBuff.append(topicNode).append("/").append(topic).toString();
                    strBuff.delete(0, strBuff.length());
                    List<String> brokerIds = ZKUtil.getChildren(this.zkw, brokerNode);
                    if (brokerIds == null) continue;
                    for (String idStr : brokerIds) {
                        String[] brokerPartIdStrs;
                        String qryBrokerId;
                        if (idStr == null || (qryBrokerId = (brokerPartIdStrs = idStr.split("-"))[0]) == null || !this.strBrokerId.equals(qryBrokerId.trim())) continue;
                        topicSet.add(topic);
                        continue block1;
                    }
                }
            }
            if (topicSet.isEmpty()) continue;
            groupTopicMap.put(group, topicSet);
        }
        return groupTopicMap;
    }

    @Override
    public void deleteGroupOffsetInfo(Map<String, Map<String, Set<Integer>>> groupTopicPartMap) {
        StringBuilder strBuff = new StringBuilder(512);
        for (Map.Entry<String, Map<String, Set<Integer>>> entry : groupTopicPartMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            String basePath = strBuff.append(this.consumerZkDir).append("/").append(entry.getKey()).append("/offsets").toString();
            strBuff.delete(0, strBuff.length());
            Map<String, Set<Integer>> topicPartMap = entry.getValue();
            for (Map.Entry<String, Set<Integer>> topicEntry : topicPartMap.entrySet()) {
                if (topicEntry.getKey() == null || topicEntry.getValue() == null || topicEntry.getValue().isEmpty()) continue;
                Set<Integer> partIdSet = topicEntry.getValue();
                for (Integer partitionId : partIdSet) {
                    String offsetNode = strBuff.append(basePath).append("/").append(topicEntry.getKey()).append("/").append(this.brokerId).append("-").append(partitionId).toString();
                    strBuff.delete(0, strBuff.length());
                    ZKUtil.delZNode(this.zkw, offsetNode);
                }
                String parentNode = strBuff.append(basePath).append("/").append(topicEntry.getKey()).toString();
                strBuff.delete(0, strBuff.length());
                this.chkAndRmvBlankParentNode(parentNode);
            }
            this.chkAndRmvBlankParentNode(basePath);
            String parentNode = strBuff.append(this.consumerZkDir).append("/").append(entry.getKey()).toString();
            strBuff.delete(0, strBuff.length());
            this.chkAndRmvBlankParentNode(parentNode);
        }
    }

    @Override
    public Set<String> cleanExpiredGroupInfo(long checkTime, long expiredDurMs) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> cleanRmvTopicInfo(Set<String> rmvTopics) {
        return Collections.EMPTY_SET;
    }

    private void chkAndRmvBlankParentNode(String parentNode) {
        List<String> nodeSet = ZKUtil.getChildren(this.zkw, parentNode);
        if (nodeSet != null && nodeSet.isEmpty()) {
            ZKUtil.delZNode(this.zkw, parentNode);
        }
    }

    static {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                if (e instanceof BindException) {
                    logger.error("Bind failed.", e);
                }
                if (e instanceof IllegalStateException && e.getMessage().contains("Shutdown in progress")) {
                    return;
                }
                logger.warn("Thread terminated with exception: " + t.getName(), e);
            });
        }
    }
}

