/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset.topicpub;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.Tuple4;
import org.apache.inlong.tubemq.server.broker.offset.topicpub.OffsetPubItem;

public class TopicPubInfo {
    private final String topicName;
    Map<Integer, OffsetPubItem> storeOffsetMap = new HashMap<Integer, OffsetPubItem>();

    public TopicPubInfo(String topicName) {
        this.topicName = topicName;
    }

    public void addStorePubInfo(int storeId, int numPart, long indexMinOffset, long indexMaxOffset, long dataMinOffset, long dataMaxOffset) {
        this.storeOffsetMap.put(storeId, new OffsetPubItem(storeId, numPart, indexMinOffset, indexMaxOffset, dataMinOffset, dataMaxOffset));
    }

    public String getTopicName() {
        return this.topicName;
    }

    public OffsetPubItem getTopicStorePubInfo(int storeId) {
        return this.storeOffsetMap.get(storeId);
    }

    public Map<Integer, OffsetPubItem> getStoreOffsetMap() {
        return this.storeOffsetMap;
    }

    public void buildRecordInfo(int brokerId, StringBuilder strBuff, long dataTime) {
        int itemCnt = 0;
        strBuff.append("{\"dt\":").append(dataTime).append(",\"bId\":").append(brokerId).append(",\"ver\":").append(1).append(",\"topic\":\"").append(this.topicName).append("\",\"offsets\":[");
        for (Map.Entry<Integer, OffsetPubItem> entry : this.storeOffsetMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            if (itemCnt++ > 0) {
                strBuff.append(",");
            }
            strBuff.append("{\"storeId\":").append(entry.getValue().getStoreId()).append(",\"numPart\":").append(entry.getValue().getNumPart()).append(",\"iMin\":").append(entry.getValue().getIndexMin()).append(",\"iMax\":").append(entry.getValue().getIndexMax()).append(",\"dMin\":").append(entry.getValue().getDataMin()).append(",\"dMax\":").append(entry.getValue().getDataMax()).append("}");
        }
        strBuff.append("]}");
    }

    public static boolean parseRecordInfo(String topicName, int curNumStores, int curNumParts, String jsonData, ProcessResult result) {
        int j;
        int baseValue;
        int i;
        JsonObject jsonObject;
        try {
            jsonObject = JsonParser.parseString((String)jsonData).getAsJsonObject();
        }
        catch (Throwable e1) {
            result.setFailResult(String.format("Parse topic %s offset value failure, reason is %s", topicName, e1.getMessage()));
            return result.isSuccess();
        }
        if (jsonObject == null) {
            result.setFailResult(String.format("Parse error, topic %s offset value must be valid json format!", topicName));
            return result.isSuccess();
        }
        if (!(TopicPubInfo.isFieldExist(jsonObject, topicName, "ver", result) && TopicPubInfo.isFieldExist(jsonObject, topicName, "dt", result) && TopicPubInfo.isFieldExist(jsonObject, topicName, "offsets", result) && TopicPubInfo.isFieldExist(jsonObject, topicName, "topic", result))) {
            return result.isSuccess();
        }
        int verValue = jsonObject.get("ver").getAsInt();
        if (verValue != 1) {
            result.setFailResult(String.format("Un-support %d version in %s's offset value!", verValue, topicName));
            return result.isSuccess();
        }
        long dataTime = jsonObject.get("dt").getAsLong();
        String targetTopic = jsonObject.get("topic").getAsString();
        if (!topicName.equals(targetTopic)) {
            result.setFailResult(String.format("FIELD topic value %s not equals required value %s!", targetTopic, topicName));
            return result.isSuccess();
        }
        JsonArray records = jsonObject.get("offsets").getAsJsonArray();
        ArrayList<Tuple4> resetOffsets = new ArrayList<Tuple4>();
        for (i = 0; i < records.size(); ++i) {
            JsonObject itemInfo = records.get(i).getAsJsonObject();
            if (itemInfo == null) continue;
            int storeId = itemInfo.get("storeId").getAsInt();
            long offsetVal = itemInfo.get("iMax").getAsLong();
            baseValue = storeId * 10000;
            for (j = 0; j < curNumParts; ++j) {
                resetOffsets.add(new Tuple4((Object)dataTime, (Object)topicName, (Object)(baseValue + j), (Object)offsetVal));
            }
        }
        for (i = records.size(); i < curNumStores; ++i) {
            baseValue = i * 10000;
            for (j = 0; j < curNumParts; ++j) {
                resetOffsets.add(new Tuple4((Object)dataTime, (Object)topicName, (Object)(baseValue + j), (Object)0L));
            }
        }
        result.setSuccResult(resetOffsets);
        return result.isSuccess();
    }

    private static boolean isFieldExist(JsonObject jsonObject, String topic, String key, ProcessResult result) {
        if (!jsonObject.has(key)) {
            result.setFailResult(String.format("FIELD %s is required in %s's offset value!", key, topic));
            return result.isSuccess();
        }
        return true;
    }
}

