/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.stats;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.metric.impl.ESTHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;
import org.apache.inlong.tubemq.corebase.metric.impl.SimpleHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.SinceTime;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;

public class MsgStoreStatsHolder {
    private final MsgStoreStatsItemSet[] msgStoreStatsSets = new MsgStoreStatsItemSet[2];
    private final AtomicInteger writableIndex = new AtomicInteger(0);
    private final AtomicLong lstQueryTime = new AtomicLong(0L);
    private final AtomicLong lstSnapshotTime = new AtomicLong(0L);
    private volatile boolean isClosed = true;
    private volatile boolean isManualClosed = false;

    public MsgStoreStatsHolder() {
        this.msgStoreStatsSets[0] = new MsgStoreStatsItemSet();
        this.msgStoreStatsSets[1] = new MsgStoreStatsItemSet();
        this.lstQueryTime.set(System.currentTimeMillis());
        this.lstSnapshotTime.set(System.currentTimeMillis());
    }

    public void addMsgWriteSuccess(int msgSize, long writeDlt) {
        if (this.isClosed) {
            return;
        }
        MsgStoreStatsItemSet tmStatsSet = this.msgStoreStatsSets[this.getIndex()];
        tmStatsSet.msgAppendSizeStats.update((long)msgSize);
        tmStatsSet.msgAppendDurStats.update(writeDlt);
    }

    public void addMsgWriteFailure() {
        if (this.isClosed) {
            return;
        }
        this.msgStoreStatsSets[this.getIndex()].msgAppendFailCnt.incValue();
    }

    public void addCachePending() {
        if (this.isClosed) {
            return;
        }
        this.msgStoreStatsSets[this.getIndex()].cacheFlushPendingCnt.incValue();
    }

    public void addCacheReAlloc() {
        if (this.isClosed) {
            return;
        }
        this.msgStoreStatsSets[this.getIndex()].cacheReAllocCnt.incValue();
    }

    public void addCacheFullType(boolean isDataSizeFull, boolean isIndexSizeFull, boolean isMsgCntFull) {
        if (this.isClosed) {
            return;
        }
        MsgStoreStatsItemSet tmStatsSet = this.msgStoreStatsSets[this.getIndex()];
        if (isDataSizeFull) {
            tmStatsSet.cacheDataSizeFullCnt.incValue();
        }
        if (isIndexSizeFull) {
            tmStatsSet.cacheIndexSizeFullCnt.incValue();
        }
        if (isMsgCntFull) {
            tmStatsSet.cacheMsgCountFullCnt.incValue();
        }
    }

    public void addCacheTimeoutFlush() {
        if (this.isClosed) {
            return;
        }
        this.msgStoreStatsSets[this.getIndex()].cacheTimeFullCnt.incValue();
    }

    public void addFileFlushStatsInfo(int msgCnt, int msgIndexSize, int msgDataSize, long flushedMsgCnt, long flushedDataSize, boolean isDataSegFlush, boolean isIndexSegFlush, boolean isDataSizeFull, boolean isMsgCntFull, boolean isCacheTimeFull, boolean isForceMetadata, long dltAppendTime) {
        if (this.isClosed) {
            return;
        }
        MsgStoreStatsItemSet tmStatsSet = this.msgStoreStatsSets[this.getIndex()];
        tmStatsSet.fileAccumMsgCnt.addValue((long)msgCnt);
        tmStatsSet.fileAccumMsgIndexSize.addValue((long)msgIndexSize);
        tmStatsSet.fileAccumMsgDataSize.addValue((long)msgDataSize);
        tmStatsSet.fileFlusheDurStats.update(dltAppendTime);
        if (flushedDataSize > 0L) {
            tmStatsSet.fileFlushedDataSize.update(flushedDataSize);
        }
        if (flushedMsgCnt > 0L) {
            tmStatsSet.fileFlushedMsgCnt.update(flushedMsgCnt);
        }
        if (isDataSegFlush) {
            tmStatsSet.fileDataSegAddCnt.incValue();
        }
        if (isIndexSegFlush) {
            tmStatsSet.fileIndexSegAddCnt.incValue();
        }
        if (isDataSizeFull) {
            tmStatsSet.fileDataSizeFullCnt.incValue();
        }
        if (isMsgCntFull) {
            tmStatsSet.fileMsgCountFullCnt.incValue();
        }
        if (isCacheTimeFull) {
            tmStatsSet.fileCachedTimeFullCnt.incValue();
        }
        if (isForceMetadata) {
            tmStatsSet.fileMetaFlushCnt.incValue();
        }
    }

    public void addFileTimeoutFlushStats(long flushedMsgCnt, long flushedDataSize, boolean isForceMetadata) {
        if (this.isClosed) {
            return;
        }
        MsgStoreStatsItemSet tmStatsSet = this.msgStoreStatsSets[this.getIndex()];
        tmStatsSet.fileCachedTimeFullCnt.incValue();
        if (flushedDataSize > 0L) {
            tmStatsSet.fileFlushedDataSize.update(flushedDataSize);
        }
        if (flushedMsgCnt > 0L) {
            tmStatsSet.fileFlushedMsgCnt.update(flushedMsgCnt);
        }
        if (isForceMetadata) {
            tmStatsSet.fileMetaFlushCnt.incValue();
        }
    }

    public synchronized void chkStatsExpired(long checkTime) {
        if (!this.isClosed && checkTime - this.lstQueryTime.get() >= 1200000L) {
            this.isClosed = true;
        }
    }

    public synchronized void setStatsStatus(boolean enableStats) {
        if (enableStats) {
            this.isManualClosed = false;
        } else {
            this.isManualClosed = true;
            this.isClosed = true;
        }
    }

    public boolean isStatsClosed() {
        return this.isManualClosed || this.isClosed;
    }

    public void getValue(Map<String, Long> statsMap) {
        this.activeStatsBaseCall();
        this.getStatsValue(true, this.msgStoreStatsSets[this.getIndex()], statsMap);
    }

    public void getValue(StringBuilder strBuff) {
        this.activeStatsBaseCall();
        this.getStatsValue(true, this.msgStoreStatsSets[this.getIndex()], strBuff);
    }

    public void snapShort(Map<String, Long> statsMap) {
        this.activeStatsBaseCall();
        if (this.switchStatsSets()) {
            this.getStatsValue(false, this.msgStoreStatsSets[this.getIndex(this.writableIndex.get() - 1)], statsMap);
        } else {
            this.getStatsValue(true, this.msgStoreStatsSets[this.getIndex()], statsMap);
        }
    }

    public void snapShort(StringBuilder strBuff) {
        this.activeStatsBaseCall();
        if (this.switchStatsSets()) {
            this.getStatsValue(false, this.msgStoreStatsSets[this.getIndex(this.writableIndex.get() - 1)], strBuff);
        } else {
            this.getStatsValue(true, this.msgStoreStatsSets[this.getIndex()], strBuff);
        }
    }

    public synchronized void getMsgStoreStatsInfo(boolean isSwitch, StringBuilder strBuff) {
        this.activeStatsBaseCall();
        strBuff.append("[");
        this.getStatsValue(false, this.msgStoreStatsSets[this.getIndex(this.writableIndex.get() - 1)], strBuff);
        strBuff.append(",");
        this.getStatsValue(true, this.msgStoreStatsSets[this.getIndex()], strBuff);
        strBuff.append("]");
        if (isSwitch) {
            this.switchStatsSets();
        }
    }

    private void activeStatsBaseCall() {
        if (this.isManualClosed) {
            return;
        }
        this.lstQueryTime.set(System.currentTimeMillis());
        if (this.isClosed) {
            this.isClosed = false;
        }
    }

    private boolean switchStatsSets() {
        long curSwitchTime = this.lstSnapshotTime.get();
        if (System.currentTimeMillis() - curSwitchTime >= 2000L && this.lstSnapshotTime.compareAndSet(curSwitchTime, System.currentTimeMillis())) {
            this.msgStoreStatsSets[this.getIndex(this.writableIndex.get() - 1)].clear();
            this.msgStoreStatsSets[this.getIndex(this.writableIndex.getAndIncrement())].setSnapshotTime(this.lstSnapshotTime.get());
            return true;
        }
        return false;
    }

    private int getIndex() {
        return this.getIndex(this.writableIndex.get());
    }

    private int getIndex(int origIndex) {
        return Math.abs(origIndex % 2);
    }

    private void getStatsValue(boolean isWriting, MsgStoreStatsItemSet statsSet, Map<String, Long> statsMap) {
        statsMap.put(statsSet.resetTime.getFullName(), statsSet.resetTime.getSinceTime());
        statsMap.put("isClosed", this.isStatsClosed() ? 1L : 0L);
        statsSet.msgAppendSizeStats.getValue(statsMap, false);
        statsSet.msgAppendDurStats.getValue(statsMap, false);
        statsMap.put(statsSet.msgAppendFailCnt.getFullName(), statsSet.msgAppendFailCnt.getValue());
        statsMap.put(statsSet.cacheDataSizeFullCnt.getFullName(), statsSet.cacheDataSizeFullCnt.getValue());
        statsMap.put(statsSet.cacheIndexSizeFullCnt.getFullName(), statsSet.cacheIndexSizeFullCnt.getValue());
        statsMap.put(statsSet.cacheMsgCountFullCnt.getFullName(), statsSet.cacheMsgCountFullCnt.getValue());
        statsMap.put(statsSet.cacheTimeFullCnt.getFullName(), statsSet.cacheTimeFullCnt.getValue());
        statsMap.put(statsSet.cacheFlushPendingCnt.getFullName(), statsSet.cacheFlushPendingCnt.getValue());
        statsMap.put(statsSet.cacheReAllocCnt.getFullName(), statsSet.cacheReAllocCnt.getValue());
        statsMap.put(statsSet.fileAccumMsgCnt.getFullName(), statsSet.fileAccumMsgCnt.getValue());
        statsMap.put(statsSet.fileAccumMsgDataSize.getFullName(), statsSet.fileAccumMsgDataSize.getValue());
        statsMap.put(statsSet.fileAccumMsgIndexSize.getFullName(), statsSet.fileAccumMsgIndexSize.getValue());
        statsSet.fileFlusheDurStats.getValue(statsMap, false);
        statsSet.fileFlushedDataSize.getValue(statsMap, false);
        statsSet.fileFlushedMsgCnt.getValue(statsMap, false);
        statsMap.put(statsSet.fileDataSegAddCnt.getFullName(), statsSet.fileDataSegAddCnt.getValue());
        statsMap.put(statsSet.fileIndexSegAddCnt.getFullName(), statsSet.fileIndexSegAddCnt.getValue());
        statsMap.put(statsSet.fileMetaFlushCnt.getFullName(), statsSet.fileMetaFlushCnt.getValue());
        statsMap.put(statsSet.fileDataSizeFullCnt.getFullName(), statsSet.fileDataSizeFullCnt.getValue());
        statsMap.put(statsSet.fileMsgCountFullCnt.getFullName(), statsSet.fileMsgCountFullCnt.getValue());
        statsMap.put(statsSet.fileCachedTimeFullCnt.getFullName(), statsSet.fileCachedTimeFullCnt.getValue());
        if (isWriting) {
            statsMap.put(statsSet.snapShotTime.getFullName(), System.currentTimeMillis());
        } else {
            statsMap.put(statsSet.snapShotTime.getFullName(), statsSet.snapShotTime.getSinceTime());
        }
    }

    private void getStatsValue(boolean isWriting, MsgStoreStatsItemSet statsSet, StringBuilder strBuff) {
        strBuff.append("{\"").append(statsSet.resetTime.getFullName()).append("\":\"").append(statsSet.resetTime.getStrSinceTime()).append("\",\"isClosed\":").append(this.isStatsClosed()).append(",");
        statsSet.msgAppendSizeStats.getValue(strBuff, false);
        strBuff.append(",");
        statsSet.msgAppendDurStats.getValue(strBuff, false);
        strBuff.append(",\"").append(statsSet.msgAppendFailCnt.getFullName()).append("\":").append(statsSet.msgAppendFailCnt.getValue()).append(",\"").append(statsSet.cacheDataSizeFullCnt.getFullName()).append("\":").append(statsSet.cacheDataSizeFullCnt.getValue()).append(",\"").append(statsSet.cacheMsgCountFullCnt.getFullName()).append("\":").append(statsSet.cacheMsgCountFullCnt.getValue()).append(",\"").append(statsSet.cacheTimeFullCnt.getFullName()).append("\":").append(statsSet.cacheTimeFullCnt.getValue()).append(",\"").append(statsSet.cacheFlushPendingCnt.getFullName()).append("\":").append(statsSet.cacheFlushPendingCnt.getValue()).append(",\"").append(statsSet.cacheReAllocCnt.getFullName()).append("\":").append(statsSet.cacheReAllocCnt.getValue()).append(",\"").append(statsSet.cacheDataSizeFullCnt.getFullName()).append("\":").append(statsSet.cacheDataSizeFullCnt.getValue()).append(",\"").append(statsSet.fileAccumMsgCnt.getFullName()).append("\":").append(statsSet.fileAccumMsgCnt.getValue()).append(",\"").append(statsSet.fileAccumMsgDataSize.getFullName()).append("\":").append(statsSet.fileAccumMsgDataSize.getValue()).append(",\"").append(statsSet.fileAccumMsgIndexSize.getFullName()).append("\":").append(statsSet.fileAccumMsgIndexSize.getValue()).append(",");
        statsSet.fileFlusheDurStats.getValue(strBuff, false);
        strBuff.append(",");
        statsSet.fileFlushedDataSize.getValue(strBuff, false);
        strBuff.append(",");
        statsSet.fileFlushedMsgCnt.getValue(strBuff, false);
        strBuff.append(",\"").append(statsSet.fileDataSegAddCnt.getFullName()).append("\":").append(statsSet.fileDataSegAddCnt.getValue()).append(",\"").append(statsSet.fileIndexSegAddCnt.getFullName()).append("\":").append(statsSet.fileIndexSegAddCnt.getValue()).append(",\"").append(statsSet.fileMetaFlushCnt.getFullName()).append("\":").append(statsSet.fileMetaFlushCnt.getValue()).append(",\"").append(statsSet.fileDataSizeFullCnt.getFullName()).append("\":").append(statsSet.fileDataSizeFullCnt.getValue()).append(",\"").append(statsSet.fileMsgCountFullCnt.getFullName()).append("\":").append(statsSet.fileMsgCountFullCnt.getValue()).append(",\"").append(statsSet.fileCachedTimeFullCnt.getFullName()).append("\":").append(statsSet.fileCachedTimeFullCnt.getValue()).append(",\"").append(statsSet.snapShotTime.getFullName()).append("\":\"");
        if (isWriting) {
            strBuff.append(DateTimeConvertUtils.ms2yyyyMMddHHmmss((long)System.currentTimeMillis()));
        } else {
            strBuff.append(statsSet.snapShotTime.getStrSinceTime());
        }
        strBuff.append("\"}");
    }

    private static class MsgStoreStatsItemSet {
        protected final SinceTime resetTime = new SinceTime("reset_time", null);
        protected final SimpleHistogram msgAppendSizeStats = new SimpleHistogram("msg_append_size", null);
        protected final ESTHistogram msgAppendDurStats = new ESTHistogram("msg_append_dlt", null);
        protected final LongStatsCounter msgAppendFailCnt = new LongStatsCounter("msg_append_fail", null);
        protected final LongStatsCounter cacheDataSizeFullCnt = new LongStatsCounter("cache_data_full", null);
        protected final LongStatsCounter cacheIndexSizeFullCnt = new LongStatsCounter("cache_index_full", null);
        protected final LongStatsCounter cacheMsgCountFullCnt = new LongStatsCounter("cache_count_full", null);
        protected final LongStatsCounter cacheTimeFullCnt = new LongStatsCounter("cache_time_full", null);
        protected final LongStatsCounter cacheFlushPendingCnt = new LongStatsCounter("cache_flush_pending", null);
        protected final LongStatsCounter cacheReAllocCnt = new LongStatsCounter("cache_realloc", null);
        protected final LongStatsCounter fileAccumMsgCnt = new LongStatsCounter("file_total_msg_cnt", null);
        protected final LongStatsCounter fileAccumMsgDataSize = new LongStatsCounter("file_total_data_size", null);
        protected final LongStatsCounter fileAccumMsgIndexSize = new LongStatsCounter("file_total_index_size", null);
        protected final ESTHistogram fileFlusheDurStats = new ESTHistogram("file_flush_dlt", null);
        protected final SimpleHistogram fileFlushedDataSize = new SimpleHistogram("file_flush_data_size", null);
        protected final SimpleHistogram fileFlushedMsgCnt = new SimpleHistogram("file_flush_msg_cnt", null);
        protected final LongStatsCounter fileDataSegAddCnt = new LongStatsCounter("file_data_seg", null);
        protected final LongStatsCounter fileIndexSegAddCnt = new LongStatsCounter("file_index_seg", null);
        protected final LongStatsCounter fileMetaFlushCnt = new LongStatsCounter("file_meta_flush", null);
        protected final LongStatsCounter fileDataSizeFullCnt = new LongStatsCounter("file_data_full", null);
        protected final LongStatsCounter fileMsgCountFullCnt = new LongStatsCounter("file_count_full", null);
        protected final LongStatsCounter fileCachedTimeFullCnt = new LongStatsCounter("file_time_full", null);
        protected final SinceTime snapShotTime = new SinceTime("end_time", null);

        public MsgStoreStatsItemSet() {
            this.clear();
        }

        public void setSnapshotTime(long snapshotTime) {
            this.snapShotTime.reset(snapshotTime);
        }

        public void clear() {
            this.snapShotTime.reset();
            this.fileAccumMsgCnt.clear();
            this.fileAccumMsgDataSize.clear();
            this.fileFlusheDurStats.clear();
            this.fileFlushedDataSize.clear();
            this.fileAccumMsgIndexSize.clear();
            this.fileFlushedMsgCnt.clear();
            this.fileDataSegAddCnt.clear();
            this.fileIndexSegAddCnt.clear();
            this.fileDataSizeFullCnt.clear();
            this.fileMetaFlushCnt.clear();
            this.fileMsgCountFullCnt.clear();
            this.fileCachedTimeFullCnt.clear();
            this.msgAppendSizeStats.clear();
            this.msgAppendDurStats.clear();
            this.msgAppendFailCnt.clear();
            this.cacheDataSizeFullCnt.clear();
            this.cacheIndexSizeFullCnt.clear();
            this.cacheMsgCountFullCnt.clear();
            this.cacheFlushPendingCnt.clear();
            this.cacheReAllocCnt.clear();
            this.cacheTimeFullCnt.clear();
            this.resetTime.reset();
        }
    }
}

