/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.utils;

import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.broker.utils.TopicPubStoreInfo;

public class GroupOffsetInfo {
    public int partitionId = -2;
    public long offsetMin = -2L;
    public long offsetMax = -2L;
    public long dataMin = -2L;
    public long dataMax = -2L;
    public long curOffset = -2L;
    public long flightOffset = -2L;
    public long offsetLag = -2L;
    public long curDataOffset = -2L;
    public long dataLag = -2L;

    public GroupOffsetInfo(int partitionId) {
        this.partitionId = partitionId;
    }

    public void setPartPubStoreInfo(TopicPubStoreInfo pubStoreInfo) {
        if (pubStoreInfo != null) {
            this.offsetMin = pubStoreInfo.offsetMin;
            this.offsetMax = pubStoreInfo.offsetMax;
            this.dataMin = pubStoreInfo.dataMin;
            this.dataMax = pubStoreInfo.dataMax;
        }
    }

    public void setConsumeOffsetInfo(Tuple2<Long, Long> offsetInfo) {
        if (offsetInfo != null) {
            this.curOffset = (Long)offsetInfo.getF0();
            this.flightOffset = (Long)offsetInfo.getF1();
        }
    }

    public void setConsumeDataOffsetInfo(long curDataOffset) {
        if (curDataOffset >= 0L) {
            this.curDataOffset = curDataOffset;
        }
    }

    public void calculateLag() {
        if (this.offsetMax != -2L && this.curOffset != -2L) {
            this.offsetLag = this.offsetMax - this.curOffset;
        }
        if (this.dataMax != -2L && this.curDataOffset != -2L) {
            this.dataLag = this.dataMax - this.curDataOffset;
        }
    }

    public StringBuilder buildOffsetInfo(StringBuilder sBuilder) {
        sBuilder.append("{\"partitionId\":").append(this.partitionId).append(",\"curOffset\":").append(this.curOffset).append(",\"flightOffset\":").append(this.flightOffset).append(",\"curDataOffset\":").append(this.curDataOffset).append(",\"offsetLag\":").append(this.offsetLag).append(",\"dataLag\":").append(this.dataLag).append(",\"offsetMax\":").append(this.offsetMax).append(",\"dataMax\":").append(this.dataMax).append("}");
        return sBuilder;
    }
}

