/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;

@Entity
public class BdbClusterSettingEntity
implements Serializable {
    private static final long serialVersionUID = 3259439355290322115L;
    @PrimaryKey
    private String recordKey = "";
    private long configId = -2L;
    private int brokerPort = -2;
    private int brokerTLSPort = -2;
    private int brokerWebPort = -2;
    private int numTopicStores = -2;
    private int numPartitions = -2;
    private int unflushThreshold = -2;
    private int unflushInterval = -2;
    private int unflushDataHold = -2;
    private int memCacheMsgCntInK = -2;
    private int memCacheFlushIntvl = -2;
    private int memCacheMsgSizeInMB = -2;
    private boolean acceptPublish = true;
    private boolean acceptSubscribe = true;
    private String deletePolicy = "";
    private int qryPriorityId = -2;
    private int maxMsgSizeInB = -2;
    private String attributes = "";
    private String modifyUser;
    private Date modifyDate;

    public BdbClusterSettingEntity() {
    }

    public BdbClusterSettingEntity(String recordKey, long configId, int brokerPort, int brokerTLSPort, int brokerWebPort, int numTopicStores, int numPartitions, int unflushThreshold, int unflushInterval, int unflushDataHold, int memCacheMsgCntInK, int memCacheFlushIntvl, int memCacheMsgSizeInMB, boolean acceptPublish, boolean acceptSubscribe, String deletePolicy, int qryPriorityId, int maxMsgSizeInB, String attributes, String modifyUser, Date modifyDate) {
        this.recordKey = recordKey;
        this.configId = configId;
        this.brokerPort = brokerPort;
        this.brokerTLSPort = brokerTLSPort;
        this.brokerWebPort = brokerWebPort;
        this.numTopicStores = numTopicStores;
        this.numPartitions = numPartitions;
        this.unflushThreshold = unflushThreshold;
        this.unflushInterval = unflushInterval;
        this.unflushDataHold = unflushDataHold;
        this.memCacheMsgCntInK = memCacheMsgCntInK;
        this.memCacheFlushIntvl = memCacheFlushIntvl;
        this.memCacheMsgSizeInMB = memCacheMsgSizeInMB;
        this.acceptPublish = acceptPublish;
        this.acceptSubscribe = acceptSubscribe;
        this.deletePolicy = deletePolicy;
        this.qryPriorityId = qryPriorityId;
        this.maxMsgSizeInB = maxMsgSizeInB;
        this.attributes = attributes;
        this.modifyUser = modifyUser;
        this.modifyDate = modifyDate;
    }

    public void setRecordKey(String recordKey) {
        this.recordKey = recordKey;
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public long getConfigId() {
        return this.configId;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public int getBrokerTLSPort() {
        return this.brokerTLSPort;
    }

    public void setBrokerTLSPort(int brokerTLSPort) {
        this.brokerTLSPort = brokerTLSPort;
    }

    public int getBrokerWebPort() {
        return this.brokerWebPort;
    }

    public void setBrokerWebPort(int brokerWebPort) {
        this.brokerWebPort = brokerWebPort;
    }

    public int getNumTopicStores() {
        return this.numTopicStores;
    }

    public void setNumTopicStores(int numTopicStores) {
        this.numTopicStores = numTopicStores;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public int getUnflushThreshold() {
        return this.unflushThreshold;
    }

    public void setUnflushThreshold(int unflushThreshold) {
        this.unflushThreshold = unflushThreshold;
    }

    public int getUnflushInterval() {
        return this.unflushInterval;
    }

    public void setUnflushInterval(int unflushInterval) {
        this.unflushInterval = unflushInterval;
    }

    public int getUnflushDataHold() {
        return this.unflushDataHold;
    }

    public void setUnflushDataHold(int unflushDataHold) {
        this.unflushDataHold = unflushDataHold;
    }

    public int getMemCacheMsgCntInK() {
        return this.memCacheMsgCntInK;
    }

    public void setMemCacheMsgCntInK(int memCacheMsgCntInK) {
        this.memCacheMsgCntInK = memCacheMsgCntInK;
    }

    public int getMemCacheFlushIntvl() {
        return this.memCacheFlushIntvl;
    }

    public void setMemCacheFlushIntvl(int memCacheFlushIntvl) {
        this.memCacheFlushIntvl = memCacheFlushIntvl;
    }

    public int getMemCacheMsgSizeInMB() {
        return this.memCacheMsgSizeInMB;
    }

    public void setMemCacheMsgSizeInMB(int memCacheMsgSizeInMB) {
        this.memCacheMsgSizeInMB = memCacheMsgSizeInMB;
    }

    public boolean isAcceptPublish() {
        return this.acceptPublish;
    }

    public void setAcceptPublish(boolean acceptPublish) {
        this.acceptPublish = acceptPublish;
    }

    public boolean isAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setAcceptSubscribe(boolean acceptSubscribe) {
        this.acceptSubscribe = acceptSubscribe;
    }

    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    public void setDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
    }

    public int getQryPriorityId() {
        return this.qryPriorityId;
    }

    public void setQryPriorityId(int qryPriorityId) {
        this.qryPriorityId = qryPriorityId;
    }

    public int getMaxMsgSizeInB() {
        return this.maxMsgSizeInB;
    }

    public void setMaxMsgSizeInB(int maxMsgSizeInB) {
        this.maxMsgSizeInB = maxMsgSizeInB;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public void setModifyInfo(String modifyUser, Date modifyDate) {
        this.configId = System.currentTimeMillis();
        this.modifyUser = modifyUser;
        this.modifyDate = modifyDate;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setDefDataPath(String dataPath) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataPath", (String)dataPath);
    }

    public String getDefDataPath() {
        return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataPath");
    }

    public void setDefDataType(int dataType) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataType", (String)String.valueOf(dataType));
    }

    public int getDefDataType() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataType");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setEnableGloFlowCtrl(Boolean enableGloFlowCtrl) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"enbFlowCtrl", (String)String.valueOf(enableGloFlowCtrl));
    }

    public EnableStatus getEnableGloFlowCtrl() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"enbFlowCtrl");
        if (atrVal != null) {
            return Boolean.parseBoolean(atrVal) ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
        }
        return EnableStatus.STATUS_UNDEFINE;
    }

    public void setGloFlowCtrlCnt(int flowCtrlCnt) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"flowCtrlCnt", (String)String.valueOf(flowCtrlCnt));
    }

    public int getGloFlowCtrlCnt() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"flowCtrlCnt");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setGloFlowCtrlInfo(String flowCtrlInfo) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"flowCtrlInfo", (String)flowCtrlInfo);
    }

    public String getGloFlowCtrlInfo() {
        return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"flowCtrlInfo");
    }

    public void setCreateInfo(String creater, Date createDate) {
        if (TStringUtils.isNotBlank((String)creater)) {
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"creater", (String)creater);
        }
        if (createDate != null) {
            String dataStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)createDate);
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"createDate", (String)dataStr);
        }
    }

    public String getCreateUser() {
        return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"creater");
    }

    public Date getCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        return DateTimeConvertUtils.yyyyMMddHHmmss2date((String)dateStr);
    }

    public String getStrCreateDate() {
        return TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
    }

    public String getStrModifyDate() {
        return DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.modifyDate);
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        sBuilder.append("{\"type\":\"BdbClusterSettingEntity\",").append("\"recordKey\":\"").append(this.recordKey).append("\"").append(",\"configId\":").append(this.configId).append(",\"brokerPort\":").append(this.brokerPort).append(",\"brokerTLSPort\":").append(this.brokerTLSPort).append(",\"brokerWebPort\":").append(this.brokerWebPort).append(",\"numTopicStores\":").append(this.numTopicStores).append(",\"numPartitions\":").append(this.numPartitions).append(",\"unflushThreshold\":").append(this.unflushThreshold).append(",\"unflushInterval\":").append(this.unflushInterval).append(",\"unflushDataHold\":").append(this.unflushDataHold).append(",\"memCacheMsgCntInK\":").append(this.memCacheMsgCntInK).append(",\"memCacheFlushIntvl\":").append(this.memCacheFlushIntvl).append(",\"memCacheMsgSizeInMB\":").append(this.memCacheMsgSizeInMB).append(",\"acceptPublish\":").append(this.acceptPublish).append(",\"acceptSubscribe\":").append(this.acceptSubscribe).append(",\"deletePolicy\":\"").append(this.deletePolicy).append("\"").append(",\"maxMsgSizeInMB\":");
        if (this.maxMsgSizeInB == -2) {
            sBuilder.append(this.maxMsgSizeInB);
        } else {
            sBuilder.append(this.maxMsgSizeInB / 0x100000);
        }
        return sBuilder.append(",\"qryPriorityId\":").append(this.qryPriorityId).append(",\"attributes\":\"").append(this.attributes).append("\"").append(",\"createUser\":\"").append(this.getCreateUser()).append("\"").append(",\"createDate\":\"").append(this.getStrCreateDate()).append("\"").append(",\"modifyUser\":\"").append(this.modifyUser).append("\"").append(",\"modifyDate\":\"").append(this.getStrModifyDate()).append("\"}");
    }

    public String toString() {
        ToStringBuilder sBuilder = new ToStringBuilder((Object)this).append("recordKey", (Object)this.recordKey).append("configId", this.configId).append("brokerPort", this.brokerPort).append("brokerTLSPort", this.brokerTLSPort).append("brokerWebPort", this.brokerWebPort).append("numTopicStores", this.numTopicStores).append("numPartitions", this.numPartitions).append("unflushThreshold", this.unflushThreshold).append("unflushInterval", this.unflushInterval).append("unflushDataHold", this.unflushDataHold).append("memCacheMsgCntInK", this.memCacheMsgCntInK).append("memCacheFlushIntvl", this.memCacheFlushIntvl).append("memCacheMsgSizeInMB", this.memCacheMsgSizeInMB).append("acceptPublish", this.acceptPublish).append("acceptSubscribe", this.acceptSubscribe).append("deletePolicy", (Object)this.deletePolicy);
        if (this.maxMsgSizeInB == -2) {
            sBuilder.append("maxMsgSizeInMB", this.maxMsgSizeInB);
        } else {
            sBuilder.append("maxMsgSizeInMB", this.maxMsgSizeInB / 0x100000);
        }
        return sBuilder.append("qryPriorityId", this.qryPriorityId).append("attributes", (Object)this.attributes).append("createUser", (Object)this.getCreateUser()).append("createDate", (Object)this.getStrCreateDate()).append("modifyUser", (Object)this.modifyUser).append("modifyDate", (Object)this.getStrModifyDate()).toString();
    }
}

