/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.TopicCtrlMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsTopicCtrlMapperImpl
implements TopicCtrlMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsTopicCtrlMapperImpl.class);
    private final ConcurrentHashMap<String, TopicCtrlEntity> topicCtrlCache = new ConcurrentHashMap();

    @Override
    public boolean addTopicCtrlConf(TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity curEntity = this.topicCtrlCache.get(entity.getTopicName());
        if (curEntity != null) {
            result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for topicName(").append(entity.getTopicName()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(entity, strBuff, result)) {
            this.topicCtrlCache.put(entity.getTopicName(), entity);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updTopicCtrlConf(TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity curEntity = this.topicCtrlCache.get(entity.getTopicName());
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found topic control configure for topicName(").append(entity.getTopicName()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        TopicCtrlEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(entity);
        if (!newEntity.updModifyInfo(entity.getDataVerId(), entity.getTopicId(), entity.getMaxMsgSizeInMB(), entity.getAuthCtrlStatus())) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Topic control configure not changed!");
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.topicCtrlCache.put(newEntity.getTopicName(), newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean delTopicCtrlConf(String topicName, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity curEntity = this.topicCtrlCache.get(topicName);
        if (curEntity == null) {
            result.setSuccResult(null);
            return result.isSuccess();
        }
        this.delConfigFromPersistent(topicName, strBuff);
        this.topicCtrlCache.remove(topicName);
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public TopicCtrlEntity getTopicCtrlConf(String topicName) {
        return this.topicCtrlCache.get(topicName);
    }

    @Override
    public List<TopicCtrlEntity> getTopicCtrlConf(TopicCtrlEntity qryEntity) {
        ArrayList<TopicCtrlEntity> retEntities = new ArrayList<TopicCtrlEntity>();
        if (qryEntity == null) {
            retEntities.addAll(this.topicCtrlCache.values());
        } else {
            for (TopicCtrlEntity entity : this.topicCtrlCache.values()) {
                if (entity == null || !entity.isMatched(qryEntity, true)) continue;
                retEntities.add(entity);
            }
        }
        return retEntities;
    }

    @Override
    public Map<String, TopicCtrlEntity> getTopicCtrlConf(Set<String> topicNameSet, TopicCtrlEntity qryEntity) {
        HashSet<String> qryKeySet = new HashSet<String>();
        HashMap<String, TopicCtrlEntity> retEntityMap = new HashMap<String, TopicCtrlEntity>();
        if (topicNameSet == null || topicNameSet.isEmpty()) {
            qryKeySet.addAll(this.topicCtrlCache.keySet());
        } else {
            qryKeySet.addAll(topicNameSet);
        }
        for (String topicName : qryKeySet) {
            TopicCtrlEntity entity = this.topicCtrlCache.get(topicName);
            if (entity == null || qryEntity != null && !entity.isMatched(qryEntity, true)) continue;
            retEntityMap.put(topicName, entity);
        }
        return retEntityMap;
    }

    @Override
    public Map<String, Integer> getMaxMsgSizeInBByTopics(int defMaxMsgSizeInB, Set<String> topicNameSet) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        if (topicNameSet == null || topicNameSet.isEmpty()) {
            return resultMap;
        }
        for (String topic : topicNameSet) {
            TopicCtrlEntity ctrlEntity;
            if (topic == null || (ctrlEntity = this.topicCtrlCache.get(topic)) == null) continue;
            if (ctrlEntity.getMaxMsgSizeInB() == -2 || ctrlEntity.getMaxMsgSizeInB() == defMaxMsgSizeInB) {
                resultMap.put(topic, null);
                continue;
            }
            resultMap.put(topic, ctrlEntity.getMaxMsgSizeInB());
        }
        return resultMap;
    }

    protected void clearCachedData() {
        this.topicCtrlCache.clear();
    }

    protected void putRecord2Caches(TopicCtrlEntity entity) {
        this.topicCtrlCache.put(entity.getTopicName(), entity);
    }

    protected abstract boolean putConfig2Persistent(TopicCtrlEntity var1, StringBuilder var2, ProcessResult var3);

    protected abstract boolean delConfigFromPersistent(String var1, StringBuilder var2);
}

