/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.TimeConsistencyPolicy;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.persist.StoreConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.fileconfig.BdbMetaConfig;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.bdbstore.MasterGroupStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.MasterNodeInfo;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsMetaConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbBrokerConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbClusterConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbConsumeCtrlMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbGroupResCtrlMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbTopicCtrlMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl.BdbTopicDeployMapperImpl;
import org.apache.inlong.tubemq.server.master.utils.MetaConfigSamplePrint;
import org.apache.inlong.tubemq.server.master.web.model.ClusterGroupVO;
import org.apache.inlong.tubemq.server.master.web.model.ClusterNodeVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdbMetaConfigMapperImpl
extends AbsMetaConfigMapperImpl {
    private static final int REP_HANDLE_RETRY_MAX = 1;
    protected static final Logger logger = LoggerFactory.getLogger(BdbMetaConfigMapperImpl.class);
    private final MetaConfigSamplePrint metaSamplePrint = new MetaConfigSamplePrint(logger);
    private final BdbMetaConfig bdbMetaConfig;
    private final EnvironmentConfig envConfig;
    private File envHome;
    private final ReplicationConfig repConfig;
    private ReplicatedEnvironment repEnv;
    private final ReplicationGroupAdmin replicationGroupAdmin;
    private String masterNodeName;
    private int connectNodeFailCount = 0;
    private Set<String> replicas4Transfer = new HashSet<String>();
    private final Listener listener = new Listener();
    private ExecutorService executorService = null;
    private final StoreConfig storeConfig = new StoreConfig();

    public BdbMetaConfigMapperImpl(MasterConfig masterConfig) {
        super(masterConfig);
        this.bdbMetaConfig = masterConfig.getBdbMetaConfig();
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>();
        for (int i = 1; i <= 3; ++i) {
            helpers.add(new InetSocketAddress(this.masterConfig.getHostName(), this.bdbMetaConfig.getRepNodePort() + i));
        }
        this.replicationGroupAdmin = new ReplicationGroupAdmin(this.bdbMetaConfig.getRepGroupName(), helpers);
        this.repConfig = new ReplicationConfig();
        this.repConfig.setConsistencyPolicy((ReplicaConsistencyPolicy)new TimeConsistencyPolicy(3L, TimeUnit.SECONDS, 3L, TimeUnit.SECONDS));
        this.repConfig.setReplicaAckTimeout(3L, TimeUnit.SECONDS);
        this.repConfig.setConfigParam("je.rep.txnRollbackLimit", "1000");
        this.repConfig.setGroupName(this.bdbMetaConfig.getRepGroupName());
        this.repConfig.setNodeName(this.bdbMetaConfig.getRepNodeName());
        this.repConfig.setNodeHostPort(this.masterConfig.getHostName() + ":" + this.bdbMetaConfig.getRepNodePort());
        if (TStringUtils.isNotEmpty((String)this.bdbMetaConfig.getRepHelperHost())) {
            logger.info("[BDB Impl] ADD HELP HOST");
            this.repConfig.setHelperHosts(this.bdbMetaConfig.getRepHelperHost());
        }
        this.envConfig = new EnvironmentConfig();
        this.envConfig.setTransactional(true);
        this.envConfig.setDurability(new Durability(this.bdbMetaConfig.getMetaLocalSyncPolicy(), this.bdbMetaConfig.getMetaReplicaSyncPolicy(), this.bdbMetaConfig.getRepReplicaAckPolicy()));
        this.envConfig.setAllowCreate(true);
        this.storeConfig.setTransactional(true);
        this.storeConfig.setReadOnly(false);
        this.storeConfig.setAllowCreate(true);
    }

    @Override
    public void start() throws Exception {
        logger.info("[BDB Impl] Start MetaConfigService, begin");
        if (!this.srvStatus.compareAndSet(0, 1)) {
            logger.info("[BDB Impl] Start MetaConfigService, started");
            return;
        }
        logger.info("[BDB Impl] Starting MetaConfigService...");
        try {
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                this.executorService = null;
            }
            this.executorService = Executors.newSingleThreadExecutor();
            this.envHome = new File(this.bdbMetaConfig.getMetaDataPath());
            this.repEnv = this.getEnvironment();
            this.initMetaStore(null);
            this.repEnv.setStateChangeListener((StateChangeListener)this.listener);
            this.srvStatus.compareAndSet(1, 2);
        }
        catch (Throwable ee) {
            this.srvStatus.compareAndSet(1, 0);
            logger.error("[BDB Impl] Start MetaConfigService failure, error", ee);
            return;
        }
        logger.info("[BDB Impl] Start MetaConfigService, success");
    }

    @Override
    public void stop() throws Exception {
        logger.info("[BDB Impl] Stop MetaConfigService, begin");
        if (!this.srvStatus.compareAndSet(2, 3)) {
            logger.info("[BDB Impl] Stop MetaConfigService, stopped");
            return;
        }
        logger.info("[BDB Impl] Stopping MetaConfigService...");
        this.closeMetaStore();
        if (this.repEnv != null) {
            try {
                this.repEnv.close();
                this.repEnv = null;
            }
            catch (Throwable ee) {
                logger.error("[BDB Impl] Close repEnv throw error ", ee);
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.srvStatus.set(0);
        logger.info("[BDB Impl] Stop MetaConfigService, success");
    }

    @Override
    public boolean isMasterNow() {
        return this.isMaster;
    }

    @Override
    public long getMasterSinceTime() {
        return this.masterSinceTime.get();
    }

    @Override
    public String getMasterAddress() {
        ReplicationGroup replicationGroup = this.getCurrReplicationGroup();
        if (replicationGroup == null) {
            logger.info("[BDB Impl] ReplicationGroup is null...please check the group status!");
            return null;
        }
        for (ReplicationNode node : replicationGroup.getNodes()) {
            try {
                NodeState nodeState = this.replicationGroupAdmin.getNodeState(node, 2000);
                if (nodeState == null || !nodeState.getNodeState().isMaster()) continue;
                return node.getSocketAddress().getAddress().getHostAddress();
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] Get nodeState Throwable error", e);
            }
        }
        return null;
    }

    @Override
    public boolean isPrimaryNodeActive() {
        if (this.repEnv == null) {
            return false;
        }
        ReplicationMutableConfig tmpConfig = this.repEnv.getRepMutableConfig();
        return tmpConfig != null && tmpConfig.getDesignatedPrimary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transferMaster() throws Exception {
        if (!this.isServiceStarted()) {
            throw new Exception("The BDB store StoreService is reboot now!");
        }
        if (!this.isMasterNow()) throw new Exception("Please send your request to the master Node!");
        if (this.isPrimaryNodeActive()) throw new Exception("DesignatedPrimary happened...please check if the other member is down!");
        if (this.replicas4Transfer == null || this.replicas4Transfer.isEmpty()) {
            throw new Exception("The replicate nodes is empty!");
        }
        logger.info(new StringBuilder(512).append("[BDB Impl] start transferMaster to replicas: ").append(this.replicas4Transfer).toString());
        this.repEnv.transferMaster(this.replicas4Transfer, 5, TimeUnit.MINUTES);
        logger.info("[BDB Impl] transferMaster end...");
    }

    @Override
    public ClusterGroupVO getGroupAddressStrInfo() {
        ClusterGroupVO clusterGroupVO = new ClusterGroupVO();
        clusterGroupVO.setGroupStatus("Abnormal");
        clusterGroupVO.setGroupName(this.replicationGroupAdmin.getGroupName());
        ReplicationGroup replicationGroup = this.getCurrReplicationGroup();
        if (replicationGroup == null) {
            return clusterGroupVO;
        }
        Tuple2<Boolean, List<ClusterNodeVO>> transResult = this.transReplicateNodes(replicationGroup);
        clusterGroupVO.setNodeData((List)transResult.getF1());
        clusterGroupVO.setPrimaryNodeActive(this.isPrimaryNodeActive());
        if (((Boolean)transResult.getF0()).booleanValue()) {
            if (this.isPrimaryNodeActive()) {
                clusterGroupVO.setGroupStatus("Running-ReadOnly");
            } else {
                clusterGroupVO.setGroupStatus("Running-ReadWrite");
            }
        }
        return clusterGroupVO;
    }

    @Override
    public MasterGroupStatus getMasterGroupStatus(boolean isFromHeartbeat) {
        if (this.repEnv == null) {
            return null;
        }
        ReplicationGroup replicationGroup = null;
        try {
            replicationGroup = this.repEnv.getGroup();
        }
        catch (DatabaseException e) {
            if (e instanceof EnvironmentFailureException) {
                if (isFromHeartbeat) {
                    logger.error("[BDB Error] Check found EnvironmentFailureException", (Throwable)e);
                    try {
                        this.stop();
                        this.start();
                        replicationGroup = this.repEnv.getGroup();
                    }
                    catch (Throwable e1) {
                        logger.error("[BDB Error] close and reopen storeManager error", e1);
                    }
                } else {
                    logger.error("[BDB Error] Get EnvironmentFailureException error while non heartBeat request", (Throwable)e);
                }
            } else {
                logger.error("[BDB Error] Get replication group info error", (Throwable)e);
            }
        }
        catch (Throwable ee) {
            logger.error("[BDB Error] Get replication group throw error", ee);
        }
        if (replicationGroup == null) {
            logger.error("[BDB Error] ReplicationGroup is null...please check the status of the group!");
            return null;
        }
        int activeNodes = 0;
        boolean isMasterActive = false;
        HashSet<String> tmp = new HashSet<String>();
        for (ReplicationNode node : replicationGroup.getNodes()) {
            MasterNodeInfo masterNodeInfo = new MasterNodeInfo(replicationGroup.getName(), node.getName(), node.getHostName(), node.getPort());
            try {
                NodeState nodeState = this.replicationGroupAdmin.getNodeState(node, 2000);
                if (nodeState == null) continue;
                if (nodeState.getNodeState().isActive()) {
                    ++activeNodes;
                    if (nodeState.getNodeName().equals(this.masterNodeName)) {
                        isMasterActive = true;
                        masterNodeInfo.setNodeStatus(1);
                    }
                }
                if (!nodeState.getNodeState().isReplica()) continue;
                tmp.add(nodeState.getNodeName());
                this.replicas4Transfer = tmp;
                masterNodeInfo.setNodeStatus(0);
            }
            catch (IOException e) {
                ++this.connectNodeFailCount;
                masterNodeInfo.setNodeStatus(-1);
                this.metaSamplePrint.printExceptionCaught(e, node.getHostName(), node.getName());
            }
            catch (ServiceDispatcher.ServiceConnectFailedException e) {
                masterNodeInfo.setNodeStatus(-2);
                this.metaSamplePrint.printExceptionCaught(e, node.getHostName(), node.getName());
            }
            catch (Throwable ee) {
                masterNodeInfo.setNodeStatus(-3);
                this.metaSamplePrint.printExceptionCaught(ee, node.getHostName(), node.getName());
            }
        }
        MasterGroupStatus masterGroupStatus = new MasterGroupStatus(isMasterActive);
        int groupSize = replicationGroup.getElectableNodes().size();
        int majoritySize = groupSize / 2 + 1;
        if (activeNodes >= majoritySize && isMasterActive) {
            masterGroupStatus.setMasterGroupStatus(true, true, true);
            this.connectNodeFailCount = 0;
            if (this.isPrimaryNodeActive()) {
                this.repEnv.setRepMutableConfig(this.repEnv.getRepMutableConfig().setDesignatedPrimary(false));
            }
        }
        if (groupSize == 2 && this.connectNodeFailCount >= 3) {
            masterGroupStatus.setMasterGroupStatus(true, false, true);
            if (this.connectNodeFailCount > 1000) {
                this.connectNodeFailCount = 3;
            }
            if (!this.isPrimaryNodeActive()) {
                logger.error("[BDB Error] DesignatedPrimary happened...please check if the other member is down");
                this.repEnv.setRepMutableConfig(this.repEnv.getRepMutableConfig().setDesignatedPrimary(true));
            }
        }
        return masterGroupStatus;
    }

    @Override
    protected void initMetaStore(StringBuilder strBuff) {
        this.clusterConfigMapper = new BdbClusterConfigMapperImpl(this.repEnv, this.storeConfig);
        this.brokerConfigMapper = new BdbBrokerConfigMapperImpl(this.repEnv, this.storeConfig);
        this.topicDeployMapper = new BdbTopicDeployMapperImpl(this.repEnv, this.storeConfig);
        this.groupResCtrlMapper = new BdbGroupResCtrlMapperImpl(this.repEnv, this.storeConfig);
        this.topicCtrlMapper = new BdbTopicCtrlMapperImpl(this.repEnv, this.storeConfig);
        this.consumeCtrlMapper = new BdbConsumeCtrlMapperImpl(this.repEnv, this.storeConfig);
    }

    private ReplicatedEnvironment getEnvironment() throws InterruptedException {
        UnknownMasterException exception = null;
        for (int i = 0; i < 1; ++i) {
            try {
                return new ReplicatedEnvironment(this.envHome, this.repConfig, this.envConfig);
            }
            catch (UnknownMasterException unknownMaster) {
                exception = unknownMaster;
                logger.error(new StringBuilder(512).append("[BDB Impl] master could not be established. ").append("Exception message:").append(unknownMaster.getMessage()).append(" Will retry after 5 seconds.").toString());
                Thread.sleep(5000L);
                continue;
            }
            catch (InsufficientLogException insufficientLogEx) {
                logger.error(new StringBuilder(512).append("[BDB Impl] [Restoring data please wait....] ").append("Obtains logger files for a Replica from other members of ").append("the replication group. A Replica may need to do so if it ").append("has been offline for some time, and has fallen behind in ").append("its execution of the replication stream.").toString());
                NetworkRestore restore = new NetworkRestore();
                NetworkRestoreConfig config = new NetworkRestoreConfig();
                config.setRetainLogFiles(false);
                restore.execute(insufficientLogEx, config);
                return new ReplicatedEnvironment(this.envHome, this.repConfig, this.envConfig);
            }
        }
        throw exception;
    }

    private ReplicationGroup getCurrReplicationGroup() {
        ReplicationGroup replicationGroup;
        try {
            replicationGroup = this.repEnv.getGroup();
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] get current master group info error", e);
            return null;
        }
        return replicationGroup;
    }

    private Tuple2<Boolean, List<ClusterNodeVO>> transReplicateNodes(ReplicationGroup replicationGroup) {
        boolean hasMaster = false;
        ArrayList<ClusterNodeVO> clusterNodeVOList = new ArrayList<ClusterNodeVO>();
        for (ReplicationNode node : replicationGroup.getNodes()) {
            ClusterNodeVO clusterNodeVO = new ClusterNodeVO();
            clusterNodeVO.setHostName(node.getHostName());
            clusterNodeVO.setNodeName(node.getName());
            clusterNodeVO.setPort(node.getPort());
            try {
                NodeState nodeState = this.replicationGroupAdmin.getNodeState(node, 2000);
                if (nodeState != null) {
                    if (nodeState.getNodeState() == ReplicatedEnvironment.State.MASTER) {
                        hasMaster = true;
                    }
                    clusterNodeVO.setNodeStatus(nodeState.getNodeState().toString());
                    clusterNodeVO.setJoinTime(nodeState.getJoinTime());
                } else {
                    clusterNodeVO.setNodeStatus("Not-found");
                    clusterNodeVO.setJoinTime(0L);
                }
            }
            catch (IOException e) {
                clusterNodeVO.setNodeStatus("Error");
                clusterNodeVO.setJoinTime(0L);
            }
            catch (ServiceDispatcher.ServiceConnectFailedException e) {
                clusterNodeVO.setNodeStatus("Unconnected");
                clusterNodeVO.setJoinTime(0L);
            }
            clusterNodeVOList.add(clusterNodeVO);
        }
        return new Tuple2((Object)hasMaster, clusterNodeVOList);
    }

    public class Listener
    implements StateChangeListener {
        public void stateChange(StateChangeEvent stateChangeEvent) throws RuntimeException {
            if (BdbMetaConfigMapperImpl.this.repConfig != null) {
                logger.warn(new StringBuilder(512).append("[BDB Impl][").append(BdbMetaConfigMapperImpl.this.repConfig.getGroupName()).append("Receive a group status changed event]... stateChangeEventTime: ").append(stateChangeEvent.getEventTime()).toString());
            }
            this.doWork(stateChangeEvent);
        }

        public void doWork(StateChangeEvent stateChangeEvent) {
            String currentNode = new StringBuilder(512).append("GroupName:").append(BdbMetaConfigMapperImpl.this.repConfig.getGroupName()).append(",nodeName:").append(BdbMetaConfigMapperImpl.this.repConfig.getNodeName()).append(",hostName:").append(BdbMetaConfigMapperImpl.this.repConfig.getNodeHostPort()).toString();
            if (BdbMetaConfigMapperImpl.this.executorService == null) {
                logger.error("[BDB Impl] found  executorService is null while doWork!");
                return;
            }
            BdbMetaConfigMapperImpl.this.executorService.submit(() -> {
                StringBuilder sBuilder = new StringBuilder(512);
                switch (stateChangeEvent.getState()) {
                    case MASTER: {
                        if (BdbMetaConfigMapperImpl.this.isMaster) break;
                        try {
                            BdbMetaConfigMapperImpl.this.reloadMetaStore(sBuilder);
                            BdbMetaConfigMapperImpl.this.isMaster = true;
                            BdbMetaConfigMapperImpl.this.masterSinceTime.set(System.currentTimeMillis());
                            BdbMetaConfigMapperImpl.this.masterNodeName = stateChangeEvent.getMasterNodeName();
                            logger.info(sBuilder.append("[BDB Impl] ").append(currentNode).append(" is a master.").toString());
                        }
                        catch (Throwable e) {
                            BdbMetaConfigMapperImpl.this.isMaster = false;
                            logger.error("[BDB Impl] fatal error when Reloading Info ", e);
                        }
                        break;
                    }
                    case REPLICA: {
                        BdbMetaConfigMapperImpl.this.isMaster = false;
                        BdbMetaConfigMapperImpl.this.masterNodeName = stateChangeEvent.getMasterNodeName();
                        logger.info(sBuilder.append("[BDB Impl] ").append(currentNode).append(" is a slave.").toString());
                        break;
                    }
                    default: {
                        BdbMetaConfigMapperImpl.this.isMaster = false;
                        logger.info(sBuilder.append("[BDB Impl] ").append(currentNode).append(" is Unknown state ").append(stateChangeEvent.getState().name()).toString());
                    }
                }
                sBuilder.delete(0, sBuilder.length());
            });
        }
    }
}

