/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl;

import java.net.BindException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.zookeeper.ZKUtil;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperWatcher;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.bdbstore.MasterGroupStatus;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsMetaConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKBrokerConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKClusterConfigMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKConsumeCtrlMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKGroupResCtrlMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKTopicCtrlMapperImpl;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl.ZKTopicDeployMapperImpl;
import org.apache.inlong.tubemq.server.master.utils.MetaConfigSamplePrint;
import org.apache.inlong.tubemq.server.master.web.model.ClusterGroupVO;
import org.apache.inlong.tubemq.server.master.web.model.ClusterNodeVO;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetaConfigMapperImpl
extends AbsMetaConfigMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(ZKMetaConfigMapperImpl.class);
    private final MetaConfigSamplePrint metaSamplePrint = new MetaConfigSamplePrint(logger);
    private final String metaZkRoot;
    private final String haParentPath;
    private final String haNodesPath;
    private volatile boolean isFirstChk = true;
    private ZooKeeperWatcher zkWatcher;
    private final NodeAddrInfo localNodeAdd;
    private final ScheduledExecutorService executorService;

    public ZKMetaConfigMapperImpl(MasterConfig masterConfig) {
        super(masterConfig);
        this.localNodeAdd = new NodeAddrInfo(masterConfig.getHostName(), masterConfig.getPort());
        String tubeZkRoot = ZKUtil.normalizePath(masterConfig.getZkMetaConfig().getZkNodeRoot());
        StringBuilder strBuff = new StringBuilder(512);
        this.metaZkRoot = strBuff.append(tubeZkRoot).append("/").append("metaData").toString();
        strBuff.delete(0, strBuff.length());
        this.haParentPath = strBuff.append(tubeZkRoot).append("/").append("masterHA").toString();
        strBuff.delete(0, strBuff.length());
        this.haNodesPath = strBuff.append(this.haParentPath).append("/").append("nodeId").append(":").toString();
        strBuff.delete(0, strBuff.length());
        try {
            this.zkWatcher = new ZooKeeperWatcher(masterConfig.getZkMetaConfig());
        }
        catch (Throwable e) {
            BrokerSrvStatsHolder.incZKExcCnt();
            logger.error(strBuff.append("[ZK Impl] Failed to connect ZooKeeper server (").append(masterConfig.getZkMetaConfig().getZkServerAddr()).append(") !").toString(), e);
            System.exit(1);
        }
        this.initMetaStore(strBuff);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Master selector thread");
            }
        });
    }

    @Override
    public void start() throws Exception {
        logger.info("[ZK Impl] Start MetaConfigService, begin");
        if (!this.srvStatus.compareAndSet(0, 1)) {
            logger.info("[ZK Impl] Start MetaConfigService, started");
            return;
        }
        try {
            logger.info("[ZK Impl] Starting MetaConfigService...");
            this.executorService.scheduleWithFixedDelay(new MasterSelectorTask(), 5L, this.masterConfig.getZkMetaConfig().getZkMasterCheckPeriodMs(), TimeUnit.MILLISECONDS);
            Thread.sleep(1000L);
            this.srvStatus.compareAndSet(1, 2);
        }
        catch (Throwable ee) {
            this.srvStatus.compareAndSet(1, 0);
            logger.error("[ZK Impl] Start MetaConfigService failure, error", ee);
            return;
        }
        logger.info("[ZK Impl] Start MetaConfigService, success");
    }

    @Override
    public void stop() throws Exception {
        logger.info("[ZK Impl] Stop MetaConfigService, begin");
        if (!this.srvStatus.compareAndSet(2, 3)) {
            logger.info("[ZK Impl] Stop MetaConfigService, stopped");
            return;
        }
        logger.info("[ZK Impl] Stopping MetaConfigService...");
        this.executorService.shutdownNow();
        this.zkWatcher.close();
        this.closeMetaStore();
        this.srvStatus.set(0);
        logger.info("[ZK Impl] Stop MetaConfigService, success");
    }

    @Override
    public boolean isMasterNow() {
        return this.isMaster;
    }

    @Override
    public long getMasterSinceTime() {
        return this.masterSinceTime.get();
    }

    @Override
    public String getMasterAddress() {
        Tuple2<Boolean, Long> queryResult;
        HashMap<Long, String> clusterNodeMap = new HashMap<Long, String>();
        try {
            queryResult = this.getCusterNodes(clusterNodeMap);
        }
        catch (Throwable e) {
            logger.error("[ZK Impl] Get Master Address Throwable error", e);
            return null;
        }
        if (!clusterNodeMap.isEmpty()) {
            return ((String)clusterNodeMap.get(queryResult.getF1())).split(":")[0];
        }
        return null;
    }

    @Override
    public boolean isPrimaryNodeActive() {
        return false;
    }

    @Override
    public void transferMaster() {
    }

    @Override
    public ClusterGroupVO getGroupAddressStrInfo() {
        Tuple2<Boolean, Long> queryResult;
        ClusterGroupVO clusterGroupVO = new ClusterGroupVO();
        clusterGroupVO.setGroupStatus("Abnormal");
        clusterGroupVO.setGroupName("ZooKeeper HA Cluster");
        HashMap<Long, String> clusterNodeMap = new HashMap<Long, String>();
        try {
            queryResult = this.getCusterNodes(clusterNodeMap);
        }
        catch (Throwable e) {
            logger.error("[ZK Impl] Get Master Address Throwable error", e);
            return clusterGroupVO;
        }
        if (clusterNodeMap.isEmpty()) {
            return clusterGroupVO;
        }
        ArrayList<ClusterNodeVO> clusterNodeVOs = new ArrayList<ClusterNodeVO>();
        for (Map.Entry entry : clusterNodeMap.entrySet()) {
            String nodeAdd = (String)entry.getValue();
            clusterNodeVOs.add(new ClusterNodeVO(nodeAdd, nodeAdd.split(":")[0], Integer.parseInt(nodeAdd.split(":")[1]), ((Long)entry.getKey()).equals(queryResult.getF1()) ? "Master" : "Slave", 0L));
        }
        if (clusterNodeMap.isEmpty()) {
            return clusterGroupVO;
        }
        clusterGroupVO.setNodeData(clusterNodeVOs);
        clusterGroupVO.setGroupStatus("Running-ReadWrite");
        return clusterGroupVO;
    }

    @Override
    public MasterGroupStatus getMasterGroupStatus(boolean isFromHeartbeat) {
        return null;
    }

    @Override
    protected void initMetaStore(StringBuilder strBuff) {
        this.clusterConfigMapper = new ZKClusterConfigMapperImpl(this.metaZkRoot, this.zkWatcher, strBuff);
        this.brokerConfigMapper = new ZKBrokerConfigMapperImpl(this.metaZkRoot, this.zkWatcher, strBuff);
        this.topicDeployMapper = new ZKTopicDeployMapperImpl(this.metaZkRoot, this.zkWatcher, strBuff);
        this.groupResCtrlMapper = new ZKGroupResCtrlMapperImpl(this.metaZkRoot, this.zkWatcher, strBuff);
        this.topicCtrlMapper = new ZKTopicCtrlMapperImpl(this.metaZkRoot, this.zkWatcher, strBuff);
        this.consumeCtrlMapper = new ZKConsumeCtrlMapperImpl(this.metaZkRoot, this.zkWatcher, strBuff);
    }

    private Tuple2<Boolean, Long> getCusterNodes(Map<Long, String> clusterNodeMap) throws KeeperException {
        boolean foundSelf = false;
        long minNodeId = Long.MAX_VALUE;
        List<ZKUtil.NodeAndData> childNodes = ZKUtil.getChildDataAndWatchForNewChildren(this.zkWatcher, this.haParentPath);
        for (ZKUtil.NodeAndData child : childNodes) {
            if (child == null) continue;
            String nodeAdd = new String(child.getData());
            long materNodeId = Long.parseLong(child.getNode().split(":")[1]);
            if (minNodeId > materNodeId) {
                minNodeId = materNodeId;
            }
            if (this.localNodeAdd.getHostPortStr().equals(nodeAdd)) {
                foundSelf = true;
            }
            clusterNodeMap.put(materNodeId, nodeAdd);
        }
        return new Tuple2((Object)foundSelf, (Object)minNodeId);
    }

    static {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                if (e instanceof BindException) {
                    logger.error("[ZK Impl] Bind failed.", e);
                }
                if (e instanceof IllegalStateException && e.getMessage().contains("Shutdown in progress")) {
                    return;
                }
                logger.warn("[ZK Impl] Thread terminated with exception: " + t.getName(), e);
            });
        }
    }

    private class MasterSelectorTask
    implements Runnable {
        private MasterSelectorTask() {
        }

        @Override
        public void run() {
            StringBuilder strBuff;
            long startTime;
            block12: {
                startTime = System.currentTimeMillis();
                strBuff = new StringBuilder(512);
                try {
                    Tuple2 queryResult;
                    if (ZKMetaConfigMapperImpl.this.isFirstChk) {
                        if (ZKUtil.checkExists(ZKMetaConfigMapperImpl.this.zkWatcher, ZKMetaConfigMapperImpl.this.haParentPath) == -1) {
                            ZKUtil.createWithParents(ZKMetaConfigMapperImpl.this.zkWatcher, ZKMetaConfigMapperImpl.this.haParentPath);
                        } else {
                            ZKMetaConfigMapperImpl.this.isFirstChk = false;
                        }
                    }
                    int totalCnt = 0;
                    HashMap clusterNodeMap = new HashMap();
                    do {
                        if (((Boolean)(queryResult = ZKMetaConfigMapperImpl.this.getCusterNodes(clusterNodeMap)).getF0()).booleanValue()) continue;
                        ZKUtil.createEphemeralNodeAndWatch(ZKMetaConfigMapperImpl.this.zkWatcher, ZKMetaConfigMapperImpl.this.haNodesPath, ZKMetaConfigMapperImpl.this.localNodeAdd.getHostPortStr().getBytes(), CreateMode.EPHEMERAL_SEQUENTIAL);
                    } while (totalCnt++ <= 1 && clusterNodeMap.isEmpty());
                    if (!clusterNodeMap.isEmpty()) {
                        String masterAdd = (String)clusterNodeMap.get(queryResult.getF1());
                        if (ZKMetaConfigMapperImpl.this.localNodeAdd.getHostPortStr().equals(masterAdd)) {
                            if (!ZKMetaConfigMapperImpl.this.isMaster) {
                                ZKMetaConfigMapperImpl.this.isMaster = true;
                                ZKMetaConfigMapperImpl.this.reloadMetaStore(strBuff);
                                ZKMetaConfigMapperImpl.this.masterSinceTime.set(System.currentTimeMillis());
                                logger.warn(strBuff.append("[ZK Impl] HA switched, ").append(ZKMetaConfigMapperImpl.this.localNodeAdd.getHostPortStr()).append(" has changed to Master role.").toString());
                                strBuff.delete(0, strBuff.length());
                            }
                        } else if (ZKMetaConfigMapperImpl.this.isMaster) {
                            ZKMetaConfigMapperImpl.this.isMaster = false;
                            ZKMetaConfigMapperImpl.this.closeMetaStore();
                            logger.warn(strBuff.append("[ZK Impl] HA switched, ").append(ZKMetaConfigMapperImpl.this.localNodeAdd.getHostPortStr()).append(" has changed to Slave role.").toString());
                            strBuff.delete(0, strBuff.length());
                        }
                    }
                }
                catch (KeeperException e) {
                    ZKMetaConfigMapperImpl.this.metaSamplePrint.printExceptionCaught(e, ZKMetaConfigMapperImpl.this.masterConfig.getHostName(), ZKMetaConfigMapperImpl.this.masterConfig.getHostName());
                    if (!ZKMetaConfigMapperImpl.this.isMaster) break block12;
                    ZKMetaConfigMapperImpl.this.isMaster = false;
                    ZKMetaConfigMapperImpl.this.closeMetaStore();
                    logger.warn(strBuff.append("[ZK Impl] HA select exception, ").append(ZKMetaConfigMapperImpl.this.localNodeAdd.getHostPortStr()).append(" has changed to Slave role.").toString());
                    strBuff.delete(0, strBuff.length());
                }
            }
            if (System.currentTimeMillis() - startTime > 30000L) {
                logger.warn(strBuff.append("[ZK Impl] HA Select cost:").append(System.currentTimeMillis() - startTime).append("ms, please make sure the time cost is below 30seconds(zk session timeout).").toString());
                strBuff.delete(0, strBuff.length());
            }
        }
    }
}

