/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer;

public enum ConsumeType {
    CONSUME_NORMAL(0, "unbound", "Normal consume without reset offset"),
    CONSUME_BAND(1, "bound", "Consume data with reset offset"),
    CONSUME_CLIENT_REB(2, "client-rebalance", "Consume data with client assigned partitions");

    private final int code;
    private final String name;
    private final String description;

    private ConsumeType(int code, String name, String description) {
        this.code = code;
        this.name = name;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static ConsumeType valueOf(int code) {
        for (ConsumeType csmType : ConsumeType.values()) {
            if (csmType.getCode() != code) continue;
            return csmType;
        }
        throw new IllegalArgumentException(String.format("unknown ConsumeType code %s", code));
    }
}

