/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp.codec;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.io.netty.buffer.ByteBuf;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.inlong.dataproxy.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.DecodeObject;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolDecoder.class);
    private static final LogCounter decExptCounter = new LogCounter(10L, 200000L, 60000L);

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer.markReaderIndex();
        int totalLen = buffer.readInt();
        if (totalLen != buffer.readableBytes()) {
            if (decExptCounter.shouldPrint()) {
                logger.error("Length not equal, totalLen={},readableBytes={},from={}", new Object[]{totalLen, buffer.readableBytes(), ctx.channel()});
            }
            buffer.resetReaderIndex();
            throw new Exception("totalLen is not equal readableBytes.total");
        }
        int msgType = buffer.readByte() & 0x1F;
        if (msgType == 4) {
            if (logger.isDebugEnabled()) {
                logger.debug("debug decode");
            }
        } else if (msgType == 3 | msgType == 5) {
            int bodyLength = buffer.readInt();
            if (bodyLength >= totalLen) {
                if (decExptCounter.shouldPrint()) {
                    logger.error("bodyLen greater than totalLen, totalLen={},bodyLen={},from={}", new Object[]{totalLen, bodyLength, ctx.channel()});
                }
                buffer.resetReaderIndex();
                throw new Exception("bodyLen is greater than totalLen.totalLen");
            }
            if (bodyLength > 0) {
                byte[] bodyBytes = new byte[bodyLength];
                buffer.readBytes(bodyBytes);
            }
            String attrInfo = "";
            int attrLength = buffer.readInt();
            if (attrLength > 0) {
                byte[] attrBytes = new byte[attrLength];
                buffer.readBytes(attrBytes);
                attrInfo = new String(attrBytes, StandardCharsets.UTF_8);
            }
            out.add(new DecodeObject(MsgType.valueOf(msgType), attrInfo));
        } else if (msgType == 7) {
            int seqId = buffer.readInt();
            short attrLen = buffer.readShort();
            String attrInfo = "";
            if (attrLen > 0) {
                byte[] attrBytes = new byte[attrLen];
                buffer.readBytes(attrBytes);
                attrInfo = new String(attrBytes, StandardCharsets.UTF_8);
            }
            buffer.readShort();
            out.add(new DecodeObject(MsgType.valueOf(msgType), seqId, attrInfo));
        } else if (msgType == 8) {
            buffer.skipBytes(9);
            short load = buffer.readShort();
            short attrLen = buffer.readShort();
            String attrInfo = "";
            if (attrLen > 0) {
                byte[] attrBytes = new byte[attrLen];
                buffer.readBytes(attrBytes);
                attrInfo = new String(attrBytes, StandardCharsets.UTF_8);
            }
            buffer.skipBytes(2);
            out.add(new DecodeObject(MsgType.MSG_BIN_HEARTBEAT, attrInfo));
        }
    }
}

