/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender.tcp;

import java.util.Objects;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.sdk.dataproxy.common.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.ReportProtocol;
import org.apache.inlong.sdk.dataproxy.common.SdkConsts;
import org.apache.inlong.sdk.dataproxy.exception.ProxySdkException;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;

public class TcpMsgSenderConfig
extends ProxyClientConfig
implements Cloneable {
    private MsgType sdkMsgType = MsgType.MSG_BIN_MULTI_BODY;
    private boolean separateEventByLF = false;
    private boolean enableDataCompress = true;
    private int minCompEnableLength = 120;
    private boolean enableEpollBusyWait = false;
    private int nettyWorkerThreadNum = SdkConsts.VAL_DEF_TCP_NETTY_WORKER_THREAD_NUM;
    private int rcvBufferSize = 0x1000000;
    private int sendBufferSize = 0x1000000;
    private int connectTimeoutMs = 8000;
    private long requestTimeoutMs = 10000L;
    private long conCloseWaitPeriodMs = 10500L;
    private int maxMsgInFlightPerConn = 4000;
    private long frozenReconnectWaitMs = 30000L;
    private long busyReconnectWaitMs = 20000L;
    private long reconFailWaitMs = 120000L;
    private int maxAllowedSyncMsgTimeoutCnt = 10;
    private long syncMsgTimeoutChkDurMs = 180000L;

    public TcpMsgSenderConfig(boolean visitMgrByHttps, String managerIP, int managerPort, String groupId) throws ProxySdkException {
        super(visitMgrByHttps, managerIP, managerPort, groupId, ReportProtocol.TCP, null);
    }

    public TcpMsgSenderConfig(String managerAddress, String groupId) throws ProxySdkException {
        super(managerAddress, groupId, ReportProtocol.TCP, null);
    }

    public TcpMsgSenderConfig(boolean visitMgrByHttps, String managerIP, int managerPort, String groupId, String mgrAuthSecretId, String mgrAuthSecretKey) throws ProxySdkException {
        super(visitMgrByHttps, managerIP, managerPort, groupId, ReportProtocol.TCP, null);
        this.setMgrAuthzInfo(true, mgrAuthSecretId, mgrAuthSecretKey);
    }

    public TcpMsgSenderConfig(String managerAddress, String groupId, String mgrAuthSecretId, String mgrAuthSecretKey) throws ProxySdkException {
        super(managerAddress, groupId, ReportProtocol.TCP, null);
        this.setMgrAuthzInfo(true, mgrAuthSecretId, mgrAuthSecretKey);
    }

    public MsgType getSdkMsgType() {
        return this.sdkMsgType;
    }

    public void setSdkMsgType(MsgType sdkMsgType) {
        if (!ProxyUtils.SdkAllowedMsgType.contains((Object)sdkMsgType)) {
            throw new IllegalArgumentException("Only allowed msgType:" + ProxyUtils.SdkAllowedMsgType);
        }
        this.sdkMsgType = sdkMsgType;
    }

    public boolean isSeparateEventByLF() {
        return this.separateEventByLF;
    }

    public void setSeparateEventByLF(boolean separateEventByLF) {
        this.separateEventByLF = separateEventByLF;
    }

    public boolean isEnableDataCompress() {
        return this.enableDataCompress;
    }

    public void setEnableDataCompress(boolean enableDataCompress) {
        this.enableDataCompress = enableDataCompress;
    }

    public int getMinCompEnableLength() {
        return this.minCompEnableLength;
    }

    public void setMinCompEnableLength(int minCompEnableLength) {
        this.minCompEnableLength = Math.max(1, minCompEnableLength);
    }

    public boolean isEnableEpollBusyWait() {
        return this.enableEpollBusyWait;
    }

    public void setEnableEpollBusyWait(boolean enableEpollBusyWait) {
        this.enableEpollBusyWait = enableEpollBusyWait;
    }

    public int getNettyWorkerThreadNum() {
        return this.nettyWorkerThreadNum;
    }

    public void setNettyWorkerThreadNum(int nettyWorkerThreadNum) {
        this.nettyWorkerThreadNum = Math.max(1, nettyWorkerThreadNum);
    }

    public int getRcvBufferSize() {
        return this.rcvBufferSize;
    }

    public void setRcvBufferSize(int rcvBufferSize) {
        this.rcvBufferSize = Math.min(rcvBufferSize, 0x7FFFFFFE);
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = Math.min(sendBufferSize, 0x7FFFFFFE);
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        if (connectTimeoutMs >= 2000) {
            this.connectTimeoutMs = connectTimeoutMs;
        }
    }

    public long getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(long requestTimeoutMs) {
        if (requestTimeoutMs >= 500L) {
            this.requestTimeoutMs = requestTimeoutMs;
            this.conCloseWaitPeriodMs = this.requestTimeoutMs + 500L;
        }
    }

    public long getConCloseWaitPeriodMs() {
        return this.conCloseWaitPeriodMs;
    }

    public void setConCloseWaitPeriodMs(long conCloseWaitPeriodMs) {
        if (conCloseWaitPeriodMs >= 0L) {
            this.conCloseWaitPeriodMs = conCloseWaitPeriodMs;
        }
    }

    public int getMaxMsgInFlightPerConn() {
        return this.maxMsgInFlightPerConn;
    }

    public void setMaxMsgInFlightPerConn(int maxMsgInFlightPerConn) {
        this.maxMsgInFlightPerConn = maxMsgInFlightPerConn;
    }

    public long getFrozenReconnectWaitMs() {
        return this.frozenReconnectWaitMs;
    }

    public void setFrozenReconnectWaitMs(long frozenReconnectWaitMs) {
        if (frozenReconnectWaitMs > 600000L) {
            this.frozenReconnectWaitMs = 600000L;
        }
    }

    public long getBusyReconnectWaitMs() {
        return this.busyReconnectWaitMs;
    }

    public void setBusyReconnectWaitMs(long busyReconnectWaitMs) {
        if (busyReconnectWaitMs > 600000L) {
            this.busyReconnectWaitMs = 600000L;
        }
    }

    public long getReconFailWaitMs() {
        return this.reconFailWaitMs;
    }

    public void setReconFailWaitMs(long reconFailWaitMs) {
        if (reconFailWaitMs > 600000L) {
            this.reconFailWaitMs = 600000L;
        }
    }

    public int getMaxAllowedSyncMsgTimeoutCnt() {
        return this.maxAllowedSyncMsgTimeoutCnt;
    }

    public void setMaxAllowedSyncMsgTimeoutCnt(int maxAllowedSyncMsgTimeoutCnt) {
        this.maxAllowedSyncMsgTimeoutCnt = maxAllowedSyncMsgTimeoutCnt;
    }

    public long getSyncMsgTimeoutChkDurMs() {
        return this.syncMsgTimeoutChkDurMs;
    }

    public void setSyncMsgTimeoutChkDurMs(long syncMsgTimeoutChkDurMs) {
        this.syncMsgTimeoutChkDurMs = Math.max(10000L, syncMsgTimeoutChkDurMs);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TcpMsgSenderConfig config = (TcpMsgSenderConfig)o;
        return this.separateEventByLF == config.separateEventByLF && this.enableDataCompress == config.enableDataCompress && this.minCompEnableLength == config.minCompEnableLength && this.enableEpollBusyWait == config.enableEpollBusyWait && this.nettyWorkerThreadNum == config.nettyWorkerThreadNum && this.rcvBufferSize == config.rcvBufferSize && this.sendBufferSize == config.sendBufferSize && this.connectTimeoutMs == config.connectTimeoutMs && this.requestTimeoutMs == config.requestTimeoutMs && this.conCloseWaitPeriodMs == config.conCloseWaitPeriodMs && this.maxMsgInFlightPerConn == config.maxMsgInFlightPerConn && this.frozenReconnectWaitMs == config.frozenReconnectWaitMs && this.busyReconnectWaitMs == config.busyReconnectWaitMs && this.reconFailWaitMs == config.reconFailWaitMs && this.maxAllowedSyncMsgTimeoutCnt == config.maxAllowedSyncMsgTimeoutCnt && this.syncMsgTimeoutChkDurMs == config.syncMsgTimeoutChkDurMs && this.sdkMsgType == config.sdkMsgType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sdkMsgType, this.separateEventByLF, this.enableDataCompress, this.minCompEnableLength, this.enableEpollBusyWait, this.nettyWorkerThreadNum, this.rcvBufferSize, this.sendBufferSize, this.connectTimeoutMs, this.requestTimeoutMs, this.conCloseWaitPeriodMs, this.maxMsgInFlightPerConn, this.frozenReconnectWaitMs, this.busyReconnectWaitMs, this.reconFailWaitMs, this.maxAllowedSyncMsgTimeoutCnt, this.syncMsgTimeoutChkDurMs});
    }

    @Override
    public TcpMsgSenderConfig clone() {
        try {
            TcpMsgSenderConfig copy = (TcpMsgSenderConfig)super.clone();
            if (copy != null) {
                copy.sdkMsgType = this.sdkMsgType;
            }
            return copy;
        }
        catch (Throwable ex) {
            logger.warn("Failed to clone TcpMsgSenderConfig", ex);
            return null;
        }
    }

    public String toString() {
        StringBuilder strBuff = new StringBuilder("TcpMsgSenderConfig{sdkMsgType=").append((Object)this.sdkMsgType).append(", separateEventByLF=").append(this.separateEventByLF).append(", enableDataCompress=").append(this.enableDataCompress).append(", minCompEnableLength=").append(this.minCompEnableLength).append(", enableEpollBusyWait=").append(this.enableEpollBusyWait).append(", nettyWorkerThreadNum=").append(this.nettyWorkerThreadNum).append(", rcvBufferSize=").append(this.rcvBufferSize).append(", sendBufferSize=").append(this.sendBufferSize).append(", connectTimeoutMs=").append(this.connectTimeoutMs).append(", requestTimeoutMs=").append(this.requestTimeoutMs).append(", conCloseWaitPeriodMs=").append(this.conCloseWaitPeriodMs).append(", maxMsgInFlightPerConn=").append(this.maxMsgInFlightPerConn).append(", frozenReconnectWaitMs=").append(this.frozenReconnectWaitMs).append(", busyReconnectWaitMs=").append(this.busyReconnectWaitMs).append(", reconFailWaitMs=").append(this.reconFailWaitMs).append(", maxAllowedSyncMsgTimeoutCnt=").append(this.maxAllowedSyncMsgTimeoutCnt).append(", syncMsgTimeoutChkDurMs=").append(this.syncMsgTimeoutChkDurMs);
        return super.getSetting(strBuff);
    }
}

