/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.service.cache.RealTimeQuery;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.AuditCycle;
import org.apache.inlong.audit.service.entities.CacheKeyEntity;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.metric.MetricsManager;
import org.apache.inlong.audit.service.utils.CacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCache.class);
    protected final Cache<String, StatData> cache;
    protected final ScheduledExecutorService monitorTimer = Executors.newSingleThreadScheduledExecutor();
    protected AuditCycle auditCycle;
    private static final int DEFAULT_MONITOR_INTERVAL = 1;
    private static final int MAX_CACHE_KEY_SIZE = 1440;
    private final DateTimeFormatter FORMATTER_YYMMDDHHMMSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    protected AbstractCache(AuditCycle auditCycle) {
        this.cache = Caffeine.newBuilder().maximumSize((long)Configuration.getInstance().get("api.cache.max.size", 50000000)).expireAfterWrite((long)Configuration.getInstance().get("api.cache.expired.hours", 12), TimeUnit.HOURS).build();
        this.auditCycle = auditCycle;
        this.monitorTimer.scheduleWithFixedDelay((Runnable)new /* Unavailable Anonymous Inner Class!! */, 0L, 1L, TimeUnit.MINUTES);
    }

    public Cache<String, StatData> getCache() {
        return this.cache;
    }

    public List<StatData> getData(String startTime, String endTime, String inlongGroupId, String inlongStreamId, String auditId, String auditTag) {
        return this.getData(startTime, endTime, inlongGroupId, inlongStreamId, auditId, auditTag, true);
    }

    public List<StatData> getData(String startTime, String endTime, String inlongGroupId, String inlongStreamId, String auditId, String auditTag, boolean needRetry) {
        ArrayList<StatData> result = new ArrayList<StatData>();
        List keyList = this.buildCacheKeyList(startTime, endTime, inlongGroupId, inlongStreamId, auditId, auditTag);
        for (CacheKeyEntity cacheKey : keyList) {
            StatData statData = this.fetchStatDataFromCache(cacheKey);
            if (statData == null && needRetry) {
                long statTimeMillis = System.currentTimeMillis();
                statData = this.fetchDataFromAuditStorage(cacheKey.getStartTime(), cacheKey.getEndTime(), inlongGroupId, inlongStreamId, auditId, auditTag);
                MetricsManager.getInstance().addApiMetricNoCache(this.auditCycle, System.currentTimeMillis() - statTimeMillis);
            }
            if (statData == null) continue;
            result.add(statData);
        }
        return result;
    }

    private List<CacheKeyEntity> buildCacheKeyList(String startTime, String endTime, String inlongGroupId, String inlongStreamId, String auditId, String auditTag) {
        LinkedList<CacheKeyEntity> keyList = new LinkedList<CacheKeyEntity>();
        try {
            LocalDateTime currentDateTime;
            LocalDateTime startDateTime = LocalDateTime.parse(startTime, this.FORMATTER_YYMMDDHHMMSS);
            LocalDateTime endDateTime = LocalDateTime.parse(endTime, this.FORMATTER_YYMMDDHHMMSS);
            LocalDateTime nowDateTime = LocalDateTime.now();
            LocalDateTime maxDateTime = endDateTime.isBefore(nowDateTime) ? endDateTime : nowDateTime;
            for (long index = 0L; index < 1440L && (currentDateTime = startDateTime.plusMinutes(index * (long)this.auditCycle.getValue())).isBefore(maxDateTime); ++index) {
                String currentTime = currentDateTime.format(this.FORMATTER_YYMMDDHHMMSS);
                String cacheKey = CacheUtils.buildCacheKey((String)currentTime, (String)inlongGroupId, (String)inlongStreamId, (String)auditId, (String)auditTag);
                keyList.add(new CacheKeyEntity(cacheKey, currentTime, currentDateTime.plusMinutes(this.auditCycle.getValue()).format(this.FORMATTER_YYMMDDHHMMSS)));
            }
        }
        catch (Exception exception) {
            LOGGER.error("It has exception when build cache key list!", (Throwable)exception);
        }
        return keyList;
    }

    public void destroy() {
        this.cache.cleanUp();
        this.monitorTimer.shutdown();
    }

    private void monitor() {
        LOGGER.info("{} api local cache size={}", (Object)this.auditCycle, (Object)this.cache.estimatedSize());
    }

    private StatData fetchDataFromAuditStorage(String startTime, String endTime, String inlongGroupId, String inlongStreamId, String auditId, String auditTag) {
        List allStatData = RealTimeQuery.getInstance().queryLogTs(startTime, endTime, inlongGroupId, inlongStreamId, auditId);
        long totalCount = 0L;
        long totalSize = 0L;
        long totalDelay = 0L;
        for (StatData data : allStatData) {
            if (!auditTag.equals(data.getAuditTag()) && !auditTag.equals("-1") && !auditTag.isEmpty()) continue;
            totalCount += data.getCount().longValue();
            totalSize += data.getSize().longValue();
            totalDelay += data.getDelay().longValue();
        }
        StatData statData = new StatData();
        statData.setLogTs(startTime);
        statData.setInlongGroupId(inlongGroupId);
        statData.setInlongStreamId(inlongStreamId);
        statData.setAuditId(auditId);
        statData.setAuditTag(auditTag);
        statData.setCount(Long.valueOf(totalCount));
        statData.setSize(Long.valueOf(totalSize));
        statData.setDelay(Long.valueOf(totalDelay));
        return statData;
    }

    private StatData fetchStatDataFromCache(CacheKeyEntity cacheKey) {
        StatData statData = (StatData)this.cache.getIfPresent((Object)cacheKey.getCacheKey());
        if (statData == null) {
            statData = (StatData)this.cache.getIfPresent((Object)(cacheKey.getCacheKey() + "-1"));
        }
        return statData;
    }

    static /* synthetic */ void access$000(AbstractCache x0) {
        x0.monitor();
    }
}

