/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.source;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.inlong.audit.service.channel.DataQueue;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.AuditCycle;
import org.apache.inlong.audit.service.entities.SourceConfig;
import org.apache.inlong.audit.service.entities.StartEndTime;
import org.apache.inlong.audit.service.source.JdbcSource;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSource.class);
    private final ConcurrentHashMap<Integer, ScheduledExecutorService> statTimers = new ConcurrentHashMap();
    private DataQueue dataQueue;
    private int querySqlTimeout;
    private DataSource dataSource;
    private String querySql;
    private SourceConfig sourceConfig;
    private static final int MAX_MINUTE = 60;

    public JdbcSource(DataQueue dataQueue, SourceConfig sourceConfig) {
        this.dataQueue = dataQueue;
        this.sourceConfig = sourceConfig;
    }

    public void init() {
        this.createDataSource();
    }

    public void start() {
        this.init();
        int statInterval = Configuration.getInstance().get("source.db.stat.interval.minute", 1);
        if (this.sourceConfig.getAuditCycle() == AuditCycle.DAY) {
            statInterval = AuditCycle.HOUR.getValue();
        }
        int offset = Configuration.getInstance().get("stat.back.initial.offset", 0);
        for (int statBackTime = 0; statBackTime < this.sourceConfig.getStatBackTimes(); ++statBackTime) {
            ScheduledExecutorService timer = this.statTimers.computeIfAbsent(statBackTime, k -> Executors.newSingleThreadScheduledExecutor());
            timer.scheduleWithFixedDelay((Runnable)new StatServer(this, offset++), 0L, statInterval + statBackTime, TimeUnit.MINUTES);
        }
    }

    public List<StartEndTime> getStatCycleOfMinute(int hoursAgo, int dataCycle) {
        LinkedList<StartEndTime> statCycleList = new LinkedList<StartEndTime>();
        for (int minute = 0; minute < 60; minute += dataCycle) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(11, -hoursAgo);
            calendar.set(12, minute);
            calendar.set(13, 0);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StartEndTime statCycle = new StartEndTime();
            statCycle.setStartTime(dateFormat.format(calendar.getTime()));
            calendar.set(12, minute + dataCycle);
            calendar.set(13, 0);
            statCycle.setEndTime(dateFormat.format(calendar.getTime()));
            statCycleList.add(statCycle);
        }
        return statCycleList;
    }

    public List<StartEndTime> getStatCycleOfDay(int daysAgo) {
        StartEndTime statCycle = new StartEndTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -daysAgo);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        statCycle.setStartTime(dateFormat.format(calendar.getTime()));
        calendar.set(11, 23);
        calendar.set(12, 59);
        statCycle.setEndTime(dateFormat.format(calendar.getTime()));
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void createDataSource() {
        HikariConfig hikariConfig = JdbcUtils.buildHikariConfig((String)this.sourceConfig.getDriverClassName(), (String)this.sourceConfig.getJdbcUrl(), (String)this.sourceConfig.getUserName(), (String)this.sourceConfig.getPassword());
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    public void destroy() {
        for (Map.Entry timer : this.statTimers.entrySet()) {
            ((ScheduledExecutorService)timer.getValue()).shutdown();
        }
    }

    public ConcurrentHashMap<Integer, ScheduledExecutorService> getStatTimers() {
        return this.statTimers;
    }

    public DataQueue getDataQueue() {
        return this.dataQueue;
    }

    public int getQuerySqlTimeout() {
        return this.querySqlTimeout;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public SourceConfig getSourceConfig() {
        return this.sourceConfig;
    }

    public void setDataQueue(DataQueue dataQueue) {
        this.dataQueue = dataQueue;
    }

    public void setQuerySqlTimeout(int querySqlTimeout) {
        this.querySqlTimeout = querySqlTimeout;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public void setSourceConfig(SourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSource)) {
            return false;
        }
        JdbcSource other = (JdbcSource)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getQuerySqlTimeout() != other.getQuerySqlTimeout()) {
            return false;
        }
        ConcurrentHashMap this$statTimers = this.getStatTimers();
        ConcurrentHashMap other$statTimers = other.getStatTimers();
        if (this$statTimers == null ? other$statTimers != null : !((Object)this$statTimers).equals(other$statTimers)) {
            return false;
        }
        DataQueue this$dataQueue = this.getDataQueue();
        DataQueue other$dataQueue = other.getDataQueue();
        if (this$dataQueue == null ? other$dataQueue != null : !this$dataQueue.equals(other$dataQueue)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$querySql = this.getQuerySql();
        String other$querySql = other.getQuerySql();
        if (this$querySql == null ? other$querySql != null : !this$querySql.equals(other$querySql)) {
            return false;
        }
        SourceConfig this$sourceConfig = this.getSourceConfig();
        SourceConfig other$sourceConfig = other.getSourceConfig();
        return !(this$sourceConfig == null ? other$sourceConfig != null : !this$sourceConfig.equals(other$sourceConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQuerySqlTimeout();
        ConcurrentHashMap $statTimers = this.getStatTimers();
        result = result * 59 + ($statTimers == null ? 43 : ((Object)$statTimers).hashCode());
        DataQueue $dataQueue = this.getDataQueue();
        result = result * 59 + ($dataQueue == null ? 43 : $dataQueue.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $querySql = this.getQuerySql();
        result = result * 59 + ($querySql == null ? 43 : $querySql.hashCode());
        SourceConfig $sourceConfig = this.getSourceConfig();
        result = result * 59 + ($sourceConfig == null ? 43 : $sourceConfig.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSource(statTimers=" + this.getStatTimers() + ", dataQueue=" + this.getDataQueue() + ", querySqlTimeout=" + this.getQuerySqlTimeout() + ", dataSource=" + this.getDataSource() + ", querySql=" + this.getQuerySql() + ", sourceConfig=" + this.getSourceConfig() + ")";
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ SourceConfig access$100(JdbcSource x0) {
        return x0.sourceConfig;
    }

    static /* synthetic */ DataSource access$200(JdbcSource x0) {
        return x0.dataSource;
    }

    static /* synthetic */ DataQueue access$300(JdbcSource x0) {
        return x0.dataQueue;
    }
}

