/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Queue;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00119\u0003!\u0011!Q\u0001\n=C\u0011\"\u0016\u0001\u0003\u0002\u0003\u0006IAV2\t\u000b!\u0004A\u0011A5\t\u000fM\u0004\u0001\u0019!C\u0005i\"9Q\u0010\u0001a\u0001\n\u0013q\bbBA\u0005\u0001\u0001\u0006K!\u001e\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\t)\u0002\u0001C!\u0003/A\u0001\"!\r\u0001\t\u0003\u0019\u00121\u0007\u0005\t\u0003\u000b\u0002A\u0011A\n\u0002H!9\u0011\u0011\n\u0001\u0005B\u0005\u001d#a\b\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u0014V-];fgR$\u0006N]3bI*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\u0011A$F\u0001\u0007G>lWn\u001c8\n\u0005yY\"!F%oi\u0016\u0014(I]8lKJ\u001cVM\u001c3UQJ,\u0017\rZ\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\u0005\u0005JS\"\u0001\u0012\u000b\u0005\r\"\u0013aB2mS\u0016tGo\u001d\u0006\u0003-\u0015R!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO&\u0011!F\t\u0002\f\u0017\u000647.Y\"mS\u0016tG/A\bnKR\fG-\u0019;b+B$\u0017\r^3s!\t\tS&\u0003\u0002/E\t)R*\u00198vC2lU\r^1eCR\fW\u000b\u001d3bi\u0016\u0014\u0018\u0001\u0004:fcV,7\u000f^)vKV,\u0007cA\u00199u5\t!G\u0003\u00024i\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U2\u0014\u0001B;uS2T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<G)Z9vKB\u00111\bP\u0007\u0002'%\u0011Qh\u0005\u0002\u001c\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'/U;fk\u0016LE/Z7\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\tY\u0004)\u0003\u0002B'\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faaY8oM&<\u0007CA\u001eE\u0013\t)5CA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u0001%M\u001b\u0005I%B\u0001&L\u0003\u001dqW\r^<pe.T!\u0001\b\u0013\n\u00055K%\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001\u0002;j[\u0016\u0004\"\u0001U*\u000e\u0003ES!AU&\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\u000b&\u0001\u0002+j[\u0016\f!\u0002\u001e5sK\u0006$g*Y7f!\t9\u0006M\u0004\u0002Y=B\u0011\u0011\fX\u0007\u00025*\u00111lF\u0001\u0007yI|w\u000e\u001e \u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?rK!\u0001Z3\u0002\t9\fW.Z\u0005\u0003M\u001e\u0014!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI*\u0011!+F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013)\\G.\u001c8paF\u0014\bCA\u001e\u0001\u0011\u0015y\u0012\u00021\u0001!\u0011\u0015Y\u0013\u00021\u0001-\u0011\u0015y\u0013\u00021\u00011\u0011\u0015q\u0014\u00021\u0001@\u0011\u0015\u0011\u0015\u00021\u0001D\u0011\u00151\u0015\u00021\u0001H\u0011\u0015q\u0015\u00021\u0001P\u0011\u0015)\u0016\u00021\u0001W\u0003A\t7\r^5wK\u000e{g\u000e\u001e:pY2,'/F\u0001v!\r1x/_\u0007\u00029&\u0011\u0001\u0010\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005i\\X\"A&\n\u0005q\\%\u0001\u0002(pI\u0016\fA#Y2uSZ,7i\u001c8ue>dG.\u001a:`I\u0015\fHcA@\u0002\u0006A\u0019a/!\u0001\n\u0007\u0005\rAL\u0001\u0003V]&$\b\u0002CA\u0004\u0017\u0005\u0005\t\u0019A;\u0002\u0007a$\u0013'A\tbGRLg/Z\"p]R\u0014x\u000e\u001c7fe\u0002\n\u0001C]3rk\u0016\u001cH\u000fV5nK>,H/T:\u0016\u0005\u0005=\u0001c\u0001<\u0002\u0012%\u0019\u00111\u0003/\u0003\u0007%sG/\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011\u0011\u0004\t\u0007\u00037\t)#a\u000b\u000f\t\u0005u\u0011\u0011\u0005\b\u00043\u0006}\u0011\"A/\n\u0007\u0005\rB,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0012\u0011\u0006\u0002\t\u0013R,'/\u00192mK*\u0019\u00111\u0005/\u0011\u0007i\ti#C\u0002\u00020m\u00111DU3rk\u0016\u001cH/\u00118e\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018A\u00045b]\u0012dWMU3ta>t7/\u001a\u000b\u0005\u0003k\t\t\u0005F\u0002\u0000\u0003oAq!!\u000f\u0010\u0001\u0004\tY$\u0001\u0005sKN\u0004xN\\:f!\r\t\u0013QH\u0005\u0004\u0003\u007f\u0011#AD\"mS\u0016tGOU3ta>t7/\u001a\u0005\u0007\u0003\u0007z\u0001\u0019\u0001\u001e\u0002\u000fI,\u0017/^3ti\u00069!-Y2l_\u001a4G#A@\u0002\r\u0011|wk\u001c:l\u0001")
public class BrokerToControllerRequestThread
extends InterBrokerSendThread {
    private final KafkaClient networkClient;
    private final ManualMetadataUpdater metadataUpdater;
    private final LinkedBlockingDeque<BrokerToControllerQueueItem> requestQueue;
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ListenerName listenerName;
    private Option<Node> activeController;

    private Option<Node> activeController() {
        return this.activeController;
    }

    private void activeController_$eq(Option<Node> x$1) {
        this.activeController = x$1;
    }

    @Override
    public int requestTimeoutMs() {
        return this.config.controllerSocketTimeoutMs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        void var1_1;
        Queue requestsToSend = new Queue();
        BrokerToControllerQueueItem topRequest = this.requestQueue.poll();
        if (topRequest != null) {
            RequestAndCompletionHandler request = new RequestAndCompletionHandler((Node)this.activeController().get(), topRequest.request(), response -> this.handleResponse(topRequest, response));
            requestsToSend.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RequestAndCompletionHandler[]{request}));
        }
        return var1_1;
    }

    public void handleResponse(BrokerToControllerQueueItem request, ClientResponse response) {
        if (response.wasDisconnected()) {
            this.activeController_$eq((Option<Node>)None$.MODULE$);
            this.requestQueue.putFirst(request);
            return;
        }
        if (response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.networkClient.close(((Node)this.activeController().get()).idString());
            this.activeController_$eq((Option<Node>)None$.MODULE$);
            this.requestQueue.putFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void backoff() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void doWork() {
        block8: {
            None$ none$;
            block10: {
                block9: {
                    Node node;
                    if (this.activeController().isDefined()) {
                        super.doWork();
                        return;
                    }
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller isn't cached, looking for local metadata changes");
                    Option<Object> option = this.metadataCache.getControllerId();
                    if (option == null) {
                        throw null;
                    }
                    Option<Object> flatMap_this = option;
                    if (flatMap_this.isEmpty()) {
                        none$ = None$.MODULE$;
                    } else {
                        Object object = flatMap_this.get();
                        none$ = this.metadataCache.getAliveBroker(BoxesRunTime.unboxToInt((Object)object));
                    }
                    if (!none$.isDefined()) break block8;
                    if (this.activeController().isEmpty()) break block9;
                    Option<Node> option2 = this.activeController();
                    if (option2 == null) {
                        throw null;
                    }
                    Option<Node> exists_this = option2;
                    boolean bl = !exists_this.isEmpty() && BrokerToControllerRequestThread.$anonfun$doWork$3((Option)none$, node = (Node)exists_this.get());
                    if (!bl) break block10;
                }
                this.info((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> BrokerToControllerRequestThread.$anonfun$doWork$4((Option)none$)));
            }
            this.activeController_$eq((Option<Node>)Option$.MODULE$.apply((Object)((Broker)none$.get()).node(this.listenerName)));
            this.metadataUpdater.setNodes((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.metadataCache.getAliveBrokers().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.node($this.listenerName), Seq$.MODULE$.canBuildFrom())).asJava());
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No controller defined in metadata cache, retrying after backoff");
        this.backoff();
    }

    public static final /* synthetic */ boolean $anonfun$doWork$3(Option controllerOpt$1, Node x$1) {
        return x$1.id() != ((Broker)controllerOpt$1.get()).id();
    }

    public static final /* synthetic */ String $anonfun$doWork$4(Option controllerOpt$1) {
        return new StringBuilder(53).append("Recorded new controller, from now on will use broker ").append(((Broker)controllerOpt$1.get()).id()).toString();
    }

    public BrokerToControllerRequestThread(KafkaClient networkClient, ManualMetadataUpdater metadataUpdater, LinkedBlockingDeque<BrokerToControllerQueueItem> requestQueue, MetadataCache metadataCache, KafkaConfig config, ListenerName listenerName, Time time, String threadName) {
        this.networkClient = networkClient;
        this.metadataUpdater = metadataUpdater;
        this.requestQueue = requestQueue;
        this.metadataCache = metadataCache;
        this.config = config;
        this.listenerName = listenerName;
        super(threadName, networkClient, time, false);
        this.activeController = None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$doWork$2$adapted(BrokerToControllerRequestThread $this, Object brokerId) {
        return $this.metadataCache.getAliveBroker(BoxesRunTime.unboxToInt((Object)brokerId));
    }

    public static final /* synthetic */ Object $anonfun$doWork$3$adapted(Option controllerOpt$1, Node x$1) {
        return BoxesRunTime.boxToBoolean((boolean)BrokerToControllerRequestThread.$anonfun$doWork$3(controllerOpt$1, x$1));
    }
}

