/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.ApiRequestHandler;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u000b\u0017\u0001mA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00038\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011\t\u0011)A\u00057\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0004w\u0001\t\u0007I\u0011B<\t\rq\u0004\u0001\u0015!\u0003y\u0011\u001di\b\u00011A\u0005\nyD\u0011\"!\u0002\u0001\u0001\u0004%I!a\u0002\t\u000f\u0005M\u0001\u0001)Q\u0005\u007f\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u0011\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003G\u0001A\u0011AA\u0010\u0011\u001d\t)\u0003\u0001C\u0001\u0003?\u00111cS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJT!a\u0006\r\u0002\rM,'O^3s\u0015\u0005I\u0012!B6bM.\f7\u0001A\n\u0005\u0001q!s\u0005\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\r=\u0013'.Z2u!\tiR%\u0003\u0002'=\tA!+\u001e8oC\ndW\r\u0005\u0002)W5\t\u0011F\u0003\u0002+1\u0005)Q\u000f^5mg&\u0011A&\u000b\u0002\b\u0019><w-\u001b8h\u0003\tIG\r\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0002J]R\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0013C\u001e<'/Z4bi\u0016LE\r\\3NKR,'/F\u00018!\tA\u0014)D\u0001:\u0015\tQ4(\u0001\u0003d_J,'B\u0001\u001f>\u0003\u001diW\r\u001e:jGNT!AP \u0002\re\fW.\\3s\u0015\u0005\u0001\u0015aA2p[&\u0011!)\u000f\u0002\u0006\u001b\u0016$XM]\u0001\u0014C\u001e<'/Z4bi\u0016LE\r\\3NKR,'\u000fI\u0001\u0014i>$\u0018\r\u001c%b]\u0012dWM\u001d+ie\u0016\fGm]\u000b\u0002\rB\u0011qIT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0007CR|W.[2\u000b\u0005-c\u0015AC2p]\u000e,(O]3oi*\u0011Q\nI\u0001\u0005kRLG.\u0003\u0002P\u0011\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fA\u0003^8uC2D\u0015M\u001c3mKJ$\u0006N]3bIN\u0004\u0013A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bG\u0001\b]\u0016$xo\u001c:l\u0013\tAVK\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002\nA!\u00199jgB\u0011A,X\u0007\u0002-%\u0011aL\u0006\u0002\u0012\u0003BL'+Z9vKN$\b*\u00198eY\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"!\u00196\u000e\u0003\tT!AK2\u000b\u0005\u0011,\u0017AB2p[6|gN\u0003\u0002\u001aM*\u0011q\r[\u0001\u0007CB\f7\r[3\u000b\u0003%\f1a\u001c:h\u0013\tY'M\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\b\u0006\u0005o_B\f(o\u001d;v!\ta\u0006\u0001C\u0003.\u0017\u0001\u0007a\u0006C\u00035\u0017\u0001\u0007a\u0006C\u00036\u0017\u0001\u0007q\u0007C\u0003E\u0017\u0001\u0007a\tC\u0003R\u0017\u0001\u00071\u000bC\u0003[\u0017\u0001\u00071\fC\u0003`\u0017\u0001\u0007\u0001-\u0001\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uKV\t\u0001\u0010\u0005\u0002zu6\t!*\u0003\u0002|\u0015\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017!E:ikR$wn\u001e8D_6\u0004H.\u001a;fA\u000591\u000f^8qa\u0016$W#A@\u0011\u0007=\n\t!C\u0002\u0002\u0004A\u0012qAQ8pY\u0016\fg.A\u0006ti>\u0004\b/\u001a3`I\u0015\fH\u0003BA\u0005\u0003\u001f\u00012aLA\u0006\u0013\r\ti\u0001\r\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0012=\t\t\u00111\u0001\u0000\u0003\rAH%M\u0001\tgR|\u0007\u000f]3eA!\u001a\u0001#a\u0006\u0011\u0007=\nI\"C\u0002\u0002\u001cA\u0012\u0001B^8mCRLG.Z\u0001\u0004eVtGCAA\u0005\u0003\u0011\u0019Ho\u001c9\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0017!D1xC&$8\u000b[;uI><h\u000e")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
                this.shutdownComplete().countDown();
                return;
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                        this.apis.handle(request);
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.shutdownComplete().countDown();
                        throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    request.releaseBuffer();
                    continue;
                }
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.stopped = false;
    }
}

