/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.producer.qltystats;

import java.util.concurrent.atomic.AtomicLong;

public class BrokerStatsItemSet {
    private AtomicLong sendNum = new AtomicLong();
    private AtomicLong receiveNum = new AtomicLong();
    private AtomicLong recSucNum = new AtomicLong();
    private AtomicLong sendNumSnapshot = new AtomicLong();
    private AtomicLong recSucNumSnapshot = new AtomicLong();
    private long dltSendNum = 0L;
    private long dltRecSucNum = 0L;

    public BrokerStatsItemSet() {
        this.sendNum.set(0L);
        this.receiveNum.set(0L);
        this.recSucNum.set(0L);
        this.sendNumSnapshot.set(0L);
        this.recSucNumSnapshot.set(0L);
        this.dltSendNum = 0L;
        this.dltRecSucNum = 0L;
    }

    public long getSendNum() {
        return this.sendNum.get();
    }

    public long getReceiveNum() {
        return this.receiveNum.get();
    }

    public long getRecSucNum() {
        return this.recSucNum.get();
    }

    public long incrementAndGetSendNum() {
        return this.sendNum.incrementAndGet();
    }

    public long incrementAndGetRecNum() {
        return this.receiveNum.incrementAndGet();
    }

    public long incrementAndGetRecSucNum() {
        return this.recSucNum.incrementAndGet();
    }

    public long getDltAndSnapshotSendNum() {
        long tmpSendNum = this.sendNum.get();
        long dltNum = tmpSendNum - this.sendNumSnapshot.get();
        this.sendNumSnapshot.set(tmpSendNum);
        if (dltNum < 0L) {
            dltNum += Long.MAX_VALUE;
        }
        this.dltSendNum = dltNum;
        return dltNum;
    }

    public long getDltSendNum() {
        return this.dltSendNum;
    }

    public long getDltRecSucNum() {
        return this.dltRecSucNum;
    }

    public long getDltAndSnapshotRecSucNum() {
        long tmpRecSucNum = this.recSucNum.get();
        long dltNum = tmpRecSucNum - this.recSucNumSnapshot.get();
        this.recSucNumSnapshot.set(tmpRecSucNum);
        if (dltNum < 0L) {
            dltNum += Long.MAX_VALUE;
        }
        this.dltRecSucNum = dltNum;
        return dltNum;
    }

    public String toString() {
        return "sendNum:" + this.sendNum.longValue() + ":" + ",receiveNum:" + this.receiveNum.longValue() + ":" + ",recSucNum:" + this.recSucNum.longValue() + ":" + ",sendNumSnapshot:" + this.sendNumSnapshot.longValue() + ":" + ",recSucNumSnapshot:" + this.recSucNumSnapshot.longValue() + ":" + ",dltSendNum:" + this.dltSendNum + ":" + ",dltRecSucNum:" + this.dltSendNum;
    }
}

