/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.producer.qltystats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.producer.qltystats.BrokerRcvQltyStats;
import org.apache.inlong.tubemq.client.producer.qltystats.BrokerStatsDltTuple;
import org.apache.inlong.tubemq.client.producer.qltystats.BrokerStatsItemSet;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBrokerRcvQltyStats
implements BrokerRcvQltyStats {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBrokerRcvQltyStats.class);
    private final TubeClientConfig clientConfig;
    private final RpcServiceFactory rpcServiceFactory;
    private final Thread statisticThread;
    private final ConcurrentHashMap<Integer, BrokerStatsItemSet> brokerStats = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, AtomicLong> brokerCurSentReqNum = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Long> brokerForbiddenMap = new ConcurrentHashMap();
    private final AtomicInteger statusId = new AtomicInteger(-1);
    private long lastPrintTime = System.currentTimeMillis();
    private final AtomicLong curTotalSentRequestNum = new AtomicLong(0L);
    private long lastLinkStatisticTime = System.currentTimeMillis();
    private List<Map.Entry<Integer, BrokerStatsDltTuple>> cachedLinkQualities = new ArrayList<Map.Entry<Integer, BrokerStatsDltTuple>>();
    private long lastQualityStatisticTime = System.currentTimeMillis();
    private long printCount = 0L;

    public DefaultBrokerRcvQltyStats(RpcServiceFactory rpcServiceFactory, TubeClientConfig producerConfig) {
        this.clientConfig = producerConfig;
        this.rpcServiceFactory = rpcServiceFactory;
        this.statisticThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!DefaultBrokerRcvQltyStats.this.isStopped()) {
                    try {
                        DefaultBrokerRcvQltyStats.this.statisticDltBrokerStatus();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ThreadUtils.sleep((long)1000L);
                }
            }
        }, "Sent Statistic Thread");
        this.statisticThread.setPriority(10);
    }

    public void startBrokerStatistic() {
        if (this.statusId.compareAndSet(-1, 0)) {
            this.statisticThread.start();
        }
    }

    public boolean isStopped() {
        return this.statusId.get() > 0;
    }

    @Override
    public List<Partition> getAllowedBrokerPartitions(Map<Integer, List<Partition>> brokerPartList) throws TubeClientException {
        ArrayList<Partition> partList;
        block11: {
            int allowedCount;
            HashSet<Integer> allowedBrokerIds;
            block12: {
                int selectCount;
                partList = new ArrayList<Partition>();
                if (brokerPartList == null || brokerPartList.isEmpty()) {
                    throw new TubeClientException("Null brokers to select sent, please try later!");
                }
                long currentWaitCount = this.curTotalSentRequestNum.get();
                if (currentWaitCount >= this.clientConfig.getSessionMaxAllowedDelayedMsgCount()) {
                    throw new TubeClientException(new StringBuilder(512).append("Current delayed messages over max allowed count, allowed is ").append(this.clientConfig.getSessionMaxAllowedDelayedMsgCount()).append(", current count is ").append(currentWaitCount).toString());
                }
                long curTime = System.currentTimeMillis();
                allowedBrokerIds = new HashSet<Integer>();
                ConcurrentHashMap unAvailableBrokerMap = this.rpcServiceFactory.getUnavailableBrokerMap();
                for (Map.Entry<Integer, List<Partition>> oldBrokerPartEntry : brokerPartList.entrySet()) {
                    BrokerInfo brokerInfo;
                    AtomicLong curMaxSentNum;
                    Partition partition;
                    List<Partition> partitionList;
                    Long lastAddTime = (Long)unAvailableBrokerMap.get(oldBrokerPartEntry.getKey());
                    if (lastAddTime != null && curTime - lastAddTime <= this.clientConfig.getUnAvailableFbdDurationMs() || this.brokerForbiddenMap.containsKey(oldBrokerPartEntry.getKey()) || (partitionList = oldBrokerPartEntry.getValue()) == null || partitionList.isEmpty() || (partition = partitionList.get(0)) == null || (curMaxSentNum = this.brokerCurSentReqNum.get((brokerInfo = partition.getBroker()).getBrokerId())) != null && curMaxSentNum.get() > this.clientConfig.getLinkMaxAllowedDelayedMsgCount() || this.rpcServiceFactory.isRemoteAddrForbidden(brokerInfo.getBrokerAddr())) continue;
                    allowedBrokerIds.add(brokerInfo.getBrokerId());
                }
                if (allowedBrokerIds.isEmpty()) {
                    throw new TubeClientException("The brokers of topic are all forbidden!");
                }
                allowedCount = selectCount = allowedBrokerIds.size();
                if (currentWaitCount > this.clientConfig.getSessionWarnDelayedMsgCount()) {
                    allowedCount = (int)Math.rint((double)selectCount * (1.0 - this.clientConfig.getSessionWarnForbiddenRate()));
                }
                if (!this.cachedLinkQualities.isEmpty() && selectCount != allowedCount) break block12;
                for (Integer selBrokerId : allowedBrokerIds) {
                    partList.addAll((Collection<Partition>)brokerPartList.get(selBrokerId));
                }
                break block11;
            }
            ArrayList<Integer> cachedBrokerIds = new ArrayList<Integer>();
            for (Map.Entry<Integer, BrokerStatsDltTuple> brokerEntry : this.cachedLinkQualities) {
                cachedBrokerIds.add(brokerEntry.getKey());
            }
            for (Integer selBrokerId : allowedBrokerIds) {
                if (!cachedBrokerIds.contains(selBrokerId)) {
                    partList.addAll((Collection<Partition>)brokerPartList.get(selBrokerId));
                    --allowedCount;
                }
                if (allowedCount > 0) continue;
                break;
            }
            if (allowedCount <= 0) break block11;
            for (Map.Entry<Integer, BrokerStatsDltTuple> brokerEntry : this.cachedLinkQualities) {
                if (allowedBrokerIds.contains(brokerEntry.getKey())) {
                    partList.addAll((Collection<Partition>)brokerPartList.get(brokerEntry.getKey()));
                    --allowedCount;
                }
                if (allowedCount > 0) continue;
                break;
            }
        }
        return partList;
    }

    @Override
    public void removeUnRegisteredBroker(List<Integer> registeredBrokerIdList) {
        for (Integer curBrokerId : this.brokerStats.keySet()) {
            if (registeredBrokerIdList.contains(curBrokerId)) continue;
            this.brokerStats.remove(curBrokerId);
        }
    }

    @Override
    public void statisticDltBrokerStatus() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLinkStatisticTime < this.clientConfig.getSessionStatisticCheckDuration() && currentTime - this.lastQualityStatisticTime < this.clientConfig.getMaxForbiddenCheckDuration()) {
            return;
        }
        if (currentTime - this.lastLinkStatisticTime > this.clientConfig.getSessionStatisticCheckDuration()) {
            this.lastLinkStatisticTime = System.currentTimeMillis();
            this.cachedLinkQualities = this.getCurBrokerSentWaitStats();
        }
        if (System.currentTimeMillis() - this.lastQualityStatisticTime < this.clientConfig.getMaxForbiddenCheckDuration()) {
            return;
        }
        StringBuilder sBuilder = new StringBuilder(512);
        this.lastQualityStatisticTime = System.currentTimeMillis();
        if (this.printCount++ % 10L == 0L && !this.brokerStats.isEmpty()) {
            if (!this.brokerForbiddenMap.isEmpty()) {
                logger.info(sBuilder.append("[status check]: current response quality respForbiddenMap is ").append(this.brokerForbiddenMap.toString()).toString());
                sBuilder.delete(0, sBuilder.length());
            }
            if (!this.rpcServiceFactory.getForbiddenAddrMap().isEmpty()) {
                logger.info(sBuilder.append("[status check]: current request quality reqForbiddenMap is ").append(this.rpcServiceFactory.getForbiddenAddrMap().toString()).toString());
                sBuilder.delete(0, sBuilder.length());
            }
            if (!this.rpcServiceFactory.getUnavailableBrokerMap().isEmpty()) {
                logger.info(sBuilder.append("[status check]: current service unavailable brokerMap is ").append(this.rpcServiceFactory.getUnavailableBrokerMap().toString()).toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
        boolean changed = false;
        long totalSuccRecNum = 0L;
        HashMap<Integer, BrokerStatsDltTuple> needSelNumTMap = new HashMap<Integer, BrokerStatsDltTuple>();
        for (Map.Entry<Integer, BrokerStatsItemSet> entry : this.brokerStats.entrySet()) {
            BrokerStatsItemSet curStatsItemSet = this.brokerStats.get(entry.getKey());
            if (curStatsItemSet == null) continue;
            long sendNum = curStatsItemSet.getDltAndSnapshotSendNum();
            long succRecvNum = curStatsItemSet.getDltAndSnapshotRecSucNum();
            if (this.brokerForbiddenMap.containsKey(entry.getKey())) continue;
            totalSuccRecNum += succRecvNum;
            needSelNumTMap.put(entry.getKey(), new BrokerStatsDltTuple(succRecvNum, sendNum));
        }
        for (Map.Entry<Integer, Object> entry : this.brokerForbiddenMap.entrySet()) {
            if (System.currentTimeMillis() - (Long)entry.getValue() <= this.clientConfig.getMaxForbiddenCheckDuration()) continue;
            changed = true;
            this.brokerForbiddenMap.remove(entry.getKey());
        }
        if (needSelNumTMap.isEmpty()) {
            if (changed && !this.brokerForbiddenMap.isEmpty()) {
                logger.info(sBuilder.append("End statistic 1: forbidden Broker Set is ").append(this.brokerForbiddenMap.toString()).toString());
                sBuilder.delete(0, sBuilder.length());
            }
            return;
        }
        ArrayList lstData = new ArrayList(needSelNumTMap.entrySet());
        Collections.sort(lstData, new BrokerStatsDltTupleComparator(false));
        int n = lstData.size();
        int needHoldCount = (int)Math.rint((double)(n + this.brokerForbiddenMap.size()) * this.clientConfig.getMaxSentForbiddenRate());
        if ((needHoldCount -= this.brokerForbiddenMap.size()) <= 0) {
            if (changed && !this.brokerForbiddenMap.isEmpty()) {
                logger.info(sBuilder.append("End statistic 2: forbidden Broker Set is ").append(this.brokerForbiddenMap.toString()).toString());
                sBuilder.delete(0, sBuilder.length());
            }
            return;
        }
        long avgSuccRecNumThreshold = 0L;
        if (n <= 3) {
            avgSuccRecNumThreshold = (long)((double)((totalSuccRecNum -= ((BrokerStatsDltTuple)((Map.Entry)lstData.get(0)).getValue()).getSuccRecvNum()) / (long)(n - 1)) * 0.2);
        } else {
            totalSuccRecNum -= ((BrokerStatsDltTuple)((Map.Entry)lstData.get(0)).getValue()).getSuccRecvNum();
            totalSuccRecNum -= ((BrokerStatsDltTuple)((Map.Entry)lstData.get(1)).getValue()).getSuccRecvNum();
            avgSuccRecNumThreshold = (long)((double)((totalSuccRecNum -= ((BrokerStatsDltTuple)((Map.Entry)lstData.get(lstData.size() - 1)).getValue()).getSuccRecvNum()) / (long)(n - 3)) * 0.2);
        }
        ConcurrentHashMap tmpBrokerForbiddenMap = new ConcurrentHashMap();
        for (Map.Entry entry : lstData) {
            long succRecvNum = ((BrokerStatsDltTuple)entry.getValue()).getSuccRecvNum();
            long succSendNumThreshold = (long)((double)((BrokerStatsDltTuple)entry.getValue()).getSendNum() * 0.1);
            if (succRecvNum < avgSuccRecNumThreshold && succSendNumThreshold > 2L && succRecvNum < succSendNumThreshold) {
                tmpBrokerForbiddenMap.put(entry.getKey(), true);
                if (logger.isDebugEnabled()) {
                    logger.debug(sBuilder.append("[forbidden statistic] brokerId=").append(entry.getKey()).append(",succRecvNum=").append(succRecvNum).append(",avgSuccRecNumThreshold=").append(avgSuccRecNumThreshold).append(",succSendNumThreshold=").append(succSendNumThreshold).toString());
                    sBuilder.delete(0, sBuilder.length());
                }
            }
            if (tmpBrokerForbiddenMap.size() < needHoldCount && succRecvNum < avgSuccRecNumThreshold) continue;
            break;
        }
        for (Integer n2 : tmpBrokerForbiddenMap.keySet()) {
            changed = true;
            this.brokerForbiddenMap.put(n2, System.currentTimeMillis());
        }
        if (changed && !this.brokerForbiddenMap.isEmpty()) {
            logger.info(sBuilder.append("End statistic 3: forbidden Broker Set is ").append(this.brokerForbiddenMap.toString()).toString());
            sBuilder.delete(0, sBuilder.length());
        }
    }

    private List<Map.Entry<Integer, BrokerStatsDltTuple>> getCurBrokerSentWaitStats() {
        HashMap<Integer, BrokerStatsDltTuple> needSelNumTMap = new HashMap<Integer, BrokerStatsDltTuple>();
        for (Map.Entry<Integer, BrokerStatsItemSet> brokerForbiddenEntry : this.brokerStats.entrySet()) {
            BrokerStatsItemSet curStatsItemSet = brokerForbiddenEntry.getValue();
            long num = curStatsItemSet.getSendNum() - curStatsItemSet.getReceiveNum();
            if (num >= this.clientConfig.getLinkMaxAllowedDelayedMsgCount()) continue;
            needSelNumTMap.put(brokerForbiddenEntry.getKey(), new BrokerStatsDltTuple(num, curStatsItemSet.getSendNum()));
        }
        ArrayList<Map.Entry<Integer, BrokerStatsDltTuple>> lstData = new ArrayList<Map.Entry<Integer, BrokerStatsDltTuple>>(needSelNumTMap.entrySet());
        Collections.sort(lstData, new BrokerStatsDltTupleComparator(true));
        return lstData;
    }

    @Override
    public void addSendStatistic(int brokerId) {
        BrokerStatsItemSet curStatsItemSet = this.brokerStats.get(brokerId);
        if (curStatsItemSet == null) {
            BrokerStatsItemSet newStatsItemSet = new BrokerStatsItemSet();
            curStatsItemSet = this.brokerStats.putIfAbsent(brokerId, newStatsItemSet);
            if (curStatsItemSet == null) {
                curStatsItemSet = newStatsItemSet;
            }
        }
        curStatsItemSet.incrementAndGetSendNum();
        AtomicLong curBrokerNum = this.brokerCurSentReqNum.get(brokerId);
        if (curBrokerNum == null) {
            AtomicLong tmpCurBrokerNum = new AtomicLong(0L);
            curBrokerNum = this.brokerCurSentReqNum.putIfAbsent(brokerId, tmpCurBrokerNum);
            if (curBrokerNum == null) {
                curBrokerNum = tmpCurBrokerNum;
            }
        }
        curBrokerNum.incrementAndGet();
        this.curTotalSentRequestNum.incrementAndGet();
    }

    @Override
    public void addReceiveStatistic(int brokerId, boolean isSuccess) {
        BrokerStatsItemSet curStatsItemSet = this.brokerStats.get(brokerId);
        if (curStatsItemSet != null) {
            AtomicLong curBrokerNum;
            curStatsItemSet.incrementAndGetRecNum();
            if (isSuccess) {
                curStatsItemSet.incrementAndGetRecSucNum();
            }
            if ((curBrokerNum = this.brokerCurSentReqNum.get(brokerId)) != null) {
                curBrokerNum.decrementAndGet();
            }
            this.curTotalSentRequestNum.decrementAndGet();
        }
    }

    @Override
    public void stopBrokerStatistic() {
        if (this.statusId.get() != 0) {
            return;
        }
        if (this.statusId.compareAndSet(0, 1)) {
            try {
                this.statisticThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "lastStatisticTime:" + this.lastLinkStatisticTime + ":" + ",lastPrintTime:" + this.lastPrintTime + ":" + ",producerMaxSentStatsScanDuration:" + this.clientConfig.getMaxForbiddenCheckDuration() + ":" + ",linkMaxAllowedDelayedMsgCount:" + this.clientConfig.getLinkMaxAllowedDelayedMsgCount() + ":" + ",brokerStats:" + this.brokerStats.toString() + ":" + ",brokerForbiddenMap:" + this.brokerForbiddenMap.toString();
    }

    private static class BrokerStatsDltTupleComparator
    implements Comparator<Map.Entry<Integer, BrokerStatsDltTuple>> {
        private boolean isDescSort = true;

        public BrokerStatsDltTupleComparator(boolean isDescSort) {
            this.isDescSort = isDescSort;
        }

        @Override
        public int compare(Map.Entry<Integer, BrokerStatsDltTuple> o1, Map.Entry<Integer, BrokerStatsDltTuple> o2) {
            if (o1.getValue().getSuccRecvNum() == o2.getValue().getSuccRecvNum()) {
                return 0;
            }
            if (o1.getValue().getSuccRecvNum() > o2.getValue().getSuccRecvNum()) {
                return this.isDescSort ? -1 : 1;
            }
            return this.isDescSort ? 1 : -1;
        }
    }
}

