/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import io.debezium.engine.spi.OffsetCommitPolicy;
import io.debezium.relational.history.FileDatabaseHistory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerSource.class);
    private static final Integer DEBEZIUM_QUEUE_SIZE = 100;
    private ExecutorService executor;
    public InstanceProfile profile;
    private BlockingQueue<AbstractSource.SourceData> debeziumQueue;
    private final Properties props = new Properties();
    private String dbName;
    private String schemaName;
    private String tableName;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("SQLServerSource init: {}", (Object)profile.toJsonStr());
            this.debeziumQueue = new LinkedBlockingQueue<AbstractSource.SourceData>(DEBEZIUM_QUEUE_SIZE);
            this.dbName = profile.get("task.sqlserverTask.dbname");
            this.schemaName = profile.get("task.sqlserverTask.schemaName");
            this.tableName = profile.get("task.sqlserverTask.tableName");
            this.props.setProperty("name", "SQLServer-" + this.instanceId);
            this.props.setProperty("connector.class", SqlServerConnector.class.getName());
            this.props.setProperty("offset.storage", FileOffsetBackingStore.class.getName());
            String agentPath = AgentConfiguration.getAgentConf().get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
            String offsetPath = agentPath + "/" + this.getThreadName() + "/offset.dat";
            this.props.setProperty("offset.storage.file.filename", offsetPath);
            this.props.setProperty("offset.flush.interval.ms", "10000");
            this.props.setProperty("database.history", FileDatabaseHistory.class.getCanonicalName());
            this.props.setProperty("database.history.file.filename", agentPath + "/" + this.getThreadName() + "/history.dat");
            this.props.setProperty("key.converter.schemas.enable", "false");
            this.props.setProperty("value.converter.schemas.enable", "false");
            this.props.setProperty("include.schema.changes", "false");
            if (Boolean.parseBoolean(profile.get("task.sqlserverTask.unixTimestampFormatEnable", "true"))) {
                this.props.setProperty("converters", "datetime");
                this.props.setProperty("datetime.type", "org.apache.inlong.agent.plugin.utils.SQLServerTimeConverter");
                this.props.setProperty("datetime.format.date", "yyyy-MM-dd");
                this.props.setProperty("datetime.format.time", "HH:mm:ss");
                this.props.setProperty("datetime.format.datetime", "yyyy-MM-dd HH:mm:ss");
                this.props.setProperty("datetime.format.timestamp", "yyyy-MM-dd HH:mm:ss");
            }
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.HOSTNAME), profile.get("task.sqlserverTask.hostname"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.PORT), profile.get("task.sqlserverTask.port"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.USER), profile.get("task.sqlserverTask.user"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.PASSWORD), profile.get("task.sqlserverTask.password"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.DATABASE_NAME), profile.get("task.sqlserverTask.dbname"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.SNAPSHOT_MODE), profile.get("task.sqlserverTask.snapshot.mode", "initial"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.SERVER_NAME), profile.get("task.sqlserverTask.serverName"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.SCHEMA_INCLUDE_LIST), profile.get("task.sqlserverTask.schemaName"));
            this.props.setProperty(String.valueOf(SqlServerConnectorConfig.TABLE_INCLUDE_LIST), profile.get("task.sqlserverTask.tableName"));
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.execute(this.startDebeziumEngine());
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.instanceId, (Throwable)ex);
        }
    }

    private Runnable startDebeziumEngine() {
        return () -> {
            AgentThreadFactory.nameThread((String)(this.getThreadName() + "debezium"));
            try (DebeziumEngine debeziumEngine = DebeziumEngine.create(Json.class).using(this.props).using(OffsetCommitPolicy.always()).notifying(this::handleConsumerEvent).build();){
                debeziumEngine.run();
            }
            catch (Throwable e) {
                LOGGER.error("do run error in SQLServer debezium: ", e);
            }
        };
    }

    private void handleConsumerEvent(List<ChangeEvent<String, String>> records, DebeziumEngine.RecordCommitter<ChangeEvent<String, String>> committer) throws InterruptedException {
        for (ChangeEvent<String, String> record : records) {
            boolean offerSuc = false;
            AbstractSource.SourceData sourceData = new AbstractSource.SourceData(this, ((String)record.value()).getBytes(StandardCharsets.UTF_8), "0");
            while (this.isRunnable() && !offerSuc) {
                offerSuc = this.debeziumQueue.offer(sourceData, 1L, TimeUnit.SECONDS);
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    @Override
    protected String getThreadName() {
        return "SQLServer-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("sqlserver databases is {} and schema is {} and table is {}", new Object[]{this.dbName, this.schemaName, this.tableName});
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        try {
            AbstractSource.SourceData sourceData;
            for (int size = 0; size < this.BATCH_READ_LINE_TOTAL_LEN && (sourceData = this.debeziumQueue.poll(1L, TimeUnit.SECONDS)) != null; size += sourceData.getData().length) {
                LOGGER.info("readFromSource: {}", (Object)sourceData.getData());
                dataList.add(sourceData);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("poll {} data from debezium queue interrupted.", (Object)this.instanceId);
        }
        return dataList;
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    @Override
    protected void releaseSource() {
        LOGGER.info("release sqlserver source");
        this.executor.shutdownNow();
    }

    public boolean sourceExist() {
        return true;
    }
}

