/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

import java.util.Objects;

public enum MessageWrapType {
    RAW(0, "RAW", "The message body wrapped with nothing"),
    INLONG_MSG_V1(1, "INLONG_MSG_V1", "The message body wrapped with inlong msg v1, which is the PB protocol"),
    INLONG_MSG_V0(2, "INLONG_MSG_V0", "The message body wrapped with inlong msg v0, which is a six segment protocol"),
    UNKNOWN(99, "UNKNOWN", "Unknown message wrap type");

    private final int id;
    private final String name;
    private final String desc;

    private MessageWrapType(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public int getId() {
        return this.id;
    }

    public String getStrId() {
        return String.valueOf(this.id);
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static MessageWrapType valueOf(int value) {
        for (MessageWrapType msgEncType : MessageWrapType.values()) {
            if (msgEncType.getId() != value) continue;
            return msgEncType;
        }
        return UNKNOWN;
    }

    public static MessageWrapType forType(String type) {
        for (MessageWrapType msgEncType : MessageWrapType.values()) {
            if (!Objects.equals(msgEncType.getName(), type)) continue;
            return msgEncType;
        }
        return UNKNOWN;
    }
}

