/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.common.monitor.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorIndexExt {
    private static final Logger logger = LoggerFactory.getLogger(MonitorIndexExt.class);
    private static final LogCounter logPrinter = new LogCounter(10, 100000, 60000);
    private IndexCollectThread indexCol;
    private String name;
    private ConcurrentHashMap<String, AtomicLong> counterMap = new ConcurrentHashMap();
    private int intervalSec;
    private int maxCnt;

    public MonitorIndexExt(String name, int intervalSec, int maxCnt) {
        this.intervalSec = intervalSec;
        this.name = name;
        this.maxCnt = maxCnt;
        this.indexCol = new IndexCollectThread();
        this.indexCol.setDaemon(true);
        this.indexCol.setName("IndexCollectThread_MonitorIndexExt");
        this.indexCol.start();
    }

    public void incrementAndGet(String key) {
        block5: {
            try {
                if (this.counterMap.size() < this.maxCnt) {
                    this.counterMap.compute(key, (s2, atomicLong) -> {
                        if (atomicLong != null) {
                            atomicLong.incrementAndGet();
                        } else {
                            atomicLong = new AtomicLong(1L);
                        }
                        return atomicLong;
                    });
                } else if (logPrinter.shouldPrint()) {
                    logger.error(this.name + "exceed monitorExt's max size");
                }
            }
            catch (Exception e) {
                if (!logPrinter.shouldPrint()) break block5;
                logger.error("monitorExt exception", e);
            }
        }
    }

    public void shutDown() {
        this.indexCol.shutDown();
    }

    public int getMaxCnt() {
        return this.maxCnt;
    }

    public void setMaxCnt(int maxCnt) {
        this.maxCnt = maxCnt;
    }

    private class IndexCollectThread
    extends Thread {
        private boolean bShutDown = false;

        public void shutDown() {
            this.bShutDown = true;
        }

        @Override
        public void run() {
            HashMap counterExt = new HashMap();
            while (!this.bShutDown) {
                try {
                    Thread.sleep((long)MonitorIndexExt.this.intervalSec * 1000L);
                    for (String string : MonitorIndexExt.this.counterMap.keySet()) {
                        MonitorIndexExt.this.counterMap.computeIfPresent(string, (s2, atomicLong) -> {
                            long cnt = atomicLong.get();
                            counterExt.put(str, cnt);
                            atomicLong.set(0L);
                            return atomicLong;
                        });
                    }
                    for (Map.Entry entry : counterExt.entrySet()) {
                        logger.info("{}#{}#{}", MonitorIndexExt.this.name, entry.getKey(), entry.getValue());
                    }
                    counterExt.clear();
                }
                catch (Exception e) {
                    logger.warn("moniorExt interrupted");
                }
            }
        }
    }
}

