/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.RuntimeContextInitializationContextAdapters;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.inlong.sort.formats.metrics.FormatMetricGroup;

public class FormatUtils {
    public static void checkDuplicates(String[] fieldNames) {
        HashSet items = new HashSet(fieldNames.length);
        Set duplicatedFieldNames = Arrays.stream(fieldNames).filter(fieldName -> !items.add(fieldName)).collect(Collectors.toSet());
        if (!duplicatedFieldNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("There exist duplicated field names: %s", duplicatedFieldNames));
        }
    }

    public static <T> void initializeDeserializationSchema(DeserializationSchema<T> deserializationSchema, RuntimeContext runtimeContext, Map<String, String> tags) throws Exception {
        FormatMetricGroup formatMetricGroup = new FormatMetricGroup(runtimeContext.getMetricGroup(), "format", true, tags);
        deserializationSchema.open(RuntimeContextInitializationContextAdapters.deserializationAdapter((RuntimeContext)runtimeContext, metricGroup -> formatMetricGroup));
    }

    public static <T> void initializeDeserializationSchema(Collection<DeserializationSchema<T>> deserializationSchemas, RuntimeContext runtimeContext, Map<String, String> tags) throws Exception {
        FormatMetricGroup formatMetricGroup = new FormatMetricGroup(runtimeContext.getMetricGroup(), "format", true, tags);
        for (DeserializationSchema<T> deserializationSchema : deserializationSchemas) {
            deserializationSchema.open(RuntimeContextInitializationContextAdapters.deserializationAdapter((RuntimeContext)runtimeContext, metricGroup -> formatMetricGroup));
        }
    }

    public static <T> void initializeSerializationSchema(SerializationSchema<T> serializationSchema, RuntimeContext runtimeContext, Map<String, String> tags) throws Exception {
        FormatMetricGroup formatMetricGroup = new FormatMetricGroup(runtimeContext.getMetricGroup(), "format", false, tags);
        serializationSchema.open(RuntimeContextInitializationContextAdapters.serializationAdapter((RuntimeContext)runtimeContext, metricGroup -> formatMetricGroup));
    }

    public static ObjectMapper getObjectMapper() {
        return new ObjectMapper().enable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

