/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.common.enums.RowKindEnum;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.enums.ExtractMode;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="oceanbaseExtract")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OceanBaseExtractNode
extends ExtractNode
implements Metadata,
InlongMetric,
Serializable {
    private static final long serialVersionUID = -5521981462461235277L;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="tableNames")
    @Nonnull
    private List<String> tableNames;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="serverId")
    private Integer serverId;
    @JsonProperty(value="incrementalSnapshotEnabled")
    private Boolean incrementalSnapshotEnabled;
    @JsonProperty(value="serverTimeZone")
    private String serverTimeZone;
    @Nonnull
    @JsonProperty(value="extractMode")
    private ExtractMode extractMode;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="rowKindsFiltered")
    private List<RowKindEnum> rowKindsFiltered;

    public OceanBaseExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @Nonnull @JsonProperty(value="tableNames") List<String> tableNames, @Nonnull @JsonProperty(value="hostname") String hostname, @Nonnull @JsonProperty(value="username") String username, @Nonnull @JsonProperty(value="password") String password, @Nonnull @JsonProperty(value="database") String database, @Nullable @JsonProperty(value="port") Integer port, @Nullable @JsonProperty(value="serverId") Integer serverId, @Nullable @JsonProperty(value="incrementalSnapshotEnabled") Boolean incrementalSnapshotEnabled, @Nullable @JsonProperty(value="serverTimeZone") String serverTimeZone) {
        this(id, name, fields, watermarkField, properties, primaryKey, tableNames, hostname, username, password, database, port, serverId, incrementalSnapshotEnabled, serverTimeZone, ExtractMode.CDC, null, null);
    }

    public OceanBaseExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="tableNames") @Nonnull List<String> tableNames, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="url") String url) {
        this(id, name, fields, null, properties, primaryKey, tableNames, null, username, password, null, null, null, null, null, ExtractMode.SCAN, url, null);
    }

    @JsonCreator
    public OceanBaseExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="tableNames") @Nonnull List<String> tableNames, @Nullable @JsonProperty(value="hostname") String hostname, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="database") String database, @Nullable @JsonProperty(value="port") Integer port, @Nullable @JsonProperty(value="serverId") Integer serverId, @Nullable @JsonProperty(value="incrementalSnapshotEnabled") Boolean incrementalSnapshotEnabled, @Nullable @JsonProperty(value="serverTimeZone") String serverTimeZone, @Nonnull @JsonProperty(value="extractMode") ExtractMode extractMode, @Nullable @JsonProperty(value="url") String url, @Nullable @JsonProperty(value="rowKindsFiltered") List<RowKindEnum> rowKindsFiltered) {
        super(id, name, fields, watermarkField, properties);
        this.tableNames = Preconditions.checkNotNull(tableNames, "tableNames is null");
        Preconditions.checkState(!tableNames.isEmpty(), "tableNames is empty");
        if (extractMode == ExtractMode.SCAN) {
            this.hostname = hostname;
            this.database = database;
            this.url = Preconditions.checkNotNull(url, "url is null");
        } else {
            extractMode = ExtractMode.CDC;
            this.hostname = Preconditions.checkNotNull(hostname, "hostname is null");
            this.database = Preconditions.checkNotNull(database, "database is null");
        }
        this.username = Preconditions.checkNotNull(username, "username is null");
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.primaryKey = primaryKey;
        this.port = port;
        this.serverId = serverId;
        this.incrementalSnapshotEnabled = incrementalSnapshotEnabled;
        this.serverTimeZone = serverTimeZone;
        this.extractMode = extractMode;
        this.rowKindsFiltered = rowKindsFiltered;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        if (this.extractMode == ExtractMode.CDC) {
            options.put("connector", "mysql-cdc-inlong");
            options.put("hostname", this.hostname);
            options.put("database-name", this.database);
            if (this.rowKindsFiltered != null) {
                List rowKinds = this.rowKindsFiltered.stream().map(RowKindEnum::shortString).collect(Collectors.toList());
                options.put("row-kinds-filtered", StringUtils.join(rowKinds, "&"));
            }
            if (this.port != null) {
                options.put("port", this.port.toString());
            }
            if (this.serverId != null) {
                options.put("server-id", this.serverId.toString());
            }
            if (this.incrementalSnapshotEnabled != null) {
                options.put("scan.incremental.snapshot.enabled", this.incrementalSnapshotEnabled.toString());
            }
            if (this.serverTimeZone != null) {
                options.put("server-time-zone", this.serverTimeZone);
            }
        } else {
            options.put("connector", "jdbc-inlong");
            options.put("url", this.url);
            Preconditions.checkState(this.tableNames.size() == 1, "Only support one table for scan extract mode");
        }
        options.put("username", this.username);
        options.put("password", this.password);
        String formatTable = this.tableNames.size() == 1 ? this.tableNames.get(0) : String.format("(%s)", StringUtils.join(this.tableNames, "|"));
        options.put("table-name", String.format("%s", formatTable));
        return options;
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "meta.table_name";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "meta.database_name";
                break;
            }
            case OP_TS: {
                metadataKey = "meta.op_ts";
                break;
            }
            case OP_TYPE: {
                metadataKey = "meta.op_type";
                break;
            }
            case DATA: 
            case DATA_BYTES: 
            case DATA_CANAL: 
            case DATA_BYTES_CANAL: {
                metadataKey = "meta.data_canal";
                break;
            }
            case DATA_DEBEZIUM: 
            case DATA_BYTES_DEBEZIUM: {
                metadataKey = "meta.data_debezium";
                break;
            }
            case IS_DDL: {
                metadataKey = "meta.is_ddl";
                break;
            }
            case TS: 
            case AUDIT_DATA_TIME: {
                metadataKey = "meta.ts";
                break;
            }
            case SQL_TYPE: {
                metadataKey = "meta.sql_type";
                break;
            }
            case MYSQL_TYPE: {
                metadataKey = "meta.mysql_type";
                break;
            }
            case PK_NAMES: {
                metadataKey = "meta.pk_names";
                break;
            }
            case BATCH_ID: {
                metadataKey = "meta.batch_id";
                break;
            }
            case UPDATE_BEFORE: {
                metadataKey = "meta.update_before";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", new Object[]{this.getClass().getSimpleName(), metaField}));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, new MetaField[]{MetaField.TABLE_NAME, MetaField.DATA_CANAL, MetaField.DATABASE_NAME, MetaField.OP_TYPE, MetaField.OP_TS, MetaField.IS_DDL, MetaField.TS, MetaField.SQL_TYPE, MetaField.MYSQL_TYPE, MetaField.PK_NAMES, MetaField.BATCH_ID, MetaField.UPDATE_BEFORE, MetaField.DATA_BYTES_DEBEZIUM, MetaField.DATA_DEBEZIUM, MetaField.DATA_BYTES_CANAL, MetaField.DATA, MetaField.DATA_BYTES, MetaField.AUDIT_DATA_TIME});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OceanBaseExtractNode)) {
            return false;
        }
        OceanBaseExtractNode other = (OceanBaseExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$serverId = this.getServerId();
        Integer other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !((Object)this$serverId).equals(other$serverId)) {
            return false;
        }
        Boolean this$incrementalSnapshotEnabled = this.getIncrementalSnapshotEnabled();
        Boolean other$incrementalSnapshotEnabled = other.getIncrementalSnapshotEnabled();
        if (this$incrementalSnapshotEnabled == null ? other$incrementalSnapshotEnabled != null : !((Object)this$incrementalSnapshotEnabled).equals(other$incrementalSnapshotEnabled)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        List<String> this$tableNames = this.getTableNames();
        List<String> other$tableNames = other.getTableNames();
        if (this$tableNames == null ? other$tableNames != null : !((Object)this$tableNames).equals(other$tableNames)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        ExtractMode this$extractMode = this.getExtractMode();
        ExtractMode other$extractMode = other.getExtractMode();
        if (this$extractMode == null ? other$extractMode != null : !((Object)((Object)this$extractMode)).equals((Object)other$extractMode)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<RowKindEnum> this$rowKindsFiltered = this.getRowKindsFiltered();
        List<RowKindEnum> other$rowKindsFiltered = other.getRowKindsFiltered();
        return !(this$rowKindsFiltered == null ? other$rowKindsFiltered != null : !((Object)this$rowKindsFiltered).equals(other$rowKindsFiltered));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OceanBaseExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : ((Object)$serverId).hashCode());
        Boolean $incrementalSnapshotEnabled = this.getIncrementalSnapshotEnabled();
        result = result * 59 + ($incrementalSnapshotEnabled == null ? 43 : ((Object)$incrementalSnapshotEnabled).hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        List<String> $tableNames = this.getTableNames();
        result = result * 59 + ($tableNames == null ? 43 : ((Object)$tableNames).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        ExtractMode $extractMode = this.getExtractMode();
        result = result * 59 + ($extractMode == null ? 43 : ((Object)((Object)$extractMode)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<RowKindEnum> $rowKindsFiltered = this.getRowKindsFiltered();
        result = result * 59 + ($rowKindsFiltered == null ? 43 : ((Object)$rowKindsFiltered).hashCode());
        return result;
    }

    @Nonnull
    public List<String> getTableNames() {
        return this.tableNames;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getServerId() {
        return this.serverId;
    }

    public Boolean getIncrementalSnapshotEnabled() {
        return this.incrementalSnapshotEnabled;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Nonnull
    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    public String getUrl() {
        return this.url;
    }

    public List<RowKindEnum> getRowKindsFiltered() {
        return this.rowKindsFiltered;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setTableNames(@Nonnull List<String> tableNames) {
        if (tableNames == null) {
            throw new NullPointerException("tableNames is marked non-null but is null");
        }
        this.tableNames = tableNames;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setServerId(Integer serverId) {
        this.serverId = serverId;
    }

    public void setIncrementalSnapshotEnabled(Boolean incrementalSnapshotEnabled) {
        this.incrementalSnapshotEnabled = incrementalSnapshotEnabled;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setExtractMode(@Nonnull ExtractMode extractMode) {
        if (extractMode == null) {
            throw new NullPointerException("extractMode is marked non-null but is null");
        }
        this.extractMode = extractMode;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRowKindsFiltered(List<RowKindEnum> rowKindsFiltered) {
        this.rowKindsFiltered = rowKindsFiltered;
    }

    @Override
    public String toString() {
        return "OceanBaseExtractNode(primaryKey=" + this.getPrimaryKey() + ", tableNames=" + this.getTableNames() + ", hostname=" + this.getHostname() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", port=" + this.getPort() + ", serverId=" + this.getServerId() + ", incrementalSnapshotEnabled=" + this.getIncrementalSnapshotEnabled() + ", serverTimeZone=" + this.getServerTimeZone() + ", extractMode=" + (Object)((Object)this.getExtractMode()) + ", url=" + this.getUrl() + ", rowKindsFiltered=" + this.getRowKindsFiltered() + ")";
    }
}

