/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.EnumMap;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.util.TimestampUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.TreeReaderFactory;

public class ConvertTreeReaderFactory
extends TreeReaderFactory {
    private static TreeReaderFactory.TreeReader createAnyIntegerConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                if (fileType.getCategory() == readerType.getCategory()) {
                    throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
                }
                return new AnyIntegerFromAnyIntegerTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return new FloatFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case DOUBLE: {
                return new DoubleFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromAnyIntegerTreeReader(columnId, fileType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromAnyIntegerTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromAnyIntegerTreeReader(columnId, fileType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createFloatConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromFloatTreeReader(columnId, readerType);
            }
            case FLOAT: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case DOUBLE: {
                return new DoubleFromFloatTreeReader(columnId);
            }
            case DECIMAL: {
                return new DecimalFromFloatTreeReader(columnId, readerType);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromFloatTreeReader(columnId, readerType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromFloatTreeReader(columnId, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createDoubleConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromDoubleTreeReader(columnId, readerType);
            }
            case FLOAT: {
                return new FloatFromDoubleTreeReader(columnId);
            }
            case DOUBLE: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case DECIMAL: {
                return new DecimalFromDoubleTreeReader(columnId, readerType);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDoubleTreeReader(columnId, readerType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromDoubleTreeReader(columnId, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createDecimalConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return new FloatFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
            case DOUBLE: {
                return new DoubleFromDecimalTreeReader(columnId, fileType, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromDecimalTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromDecimalTreeReader(columnId, fileType, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createStringConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return new FloatFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case CHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case BINARY: {
                return new BinaryFromStringGroupTreeReader(columnId, fileType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createCharConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return new FloatFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case CHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case BINARY: {
                return new BinaryFromStringGroupTreeReader(columnId, fileType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createVarcharConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return new FloatFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DOUBLE: {
                return new DoubleFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DECIMAL: {
                return new DecimalFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case CHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case VARCHAR: {
                return new StringGroupFromStringGroupTreeReader(columnId, fileType, readerType, context);
            }
            case BINARY: {
                return new BinaryFromStringGroupTreeReader(columnId, fileType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromStringGroupTreeReader(columnId, fileType, context);
            }
            case DATE: {
                return new DateFromStringGroupTreeReader(columnId, fileType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createTimestampConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new AnyIntegerFromTimestampTreeReader(columnId, readerType, context);
            }
            case FLOAT: {
                return new FloatFromTimestampTreeReader(columnId, context);
            }
            case DOUBLE: {
                return new DoubleFromTimestampTreeReader(columnId, context);
            }
            case DECIMAL: {
                return new DecimalFromTimestampTreeReader(columnId, context);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromTimestampTreeReader(columnId, readerType, context);
            }
            case TIMESTAMP: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
            case DATE: {
                return new DateFromTimestampTreeReader(columnId, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createDateConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromDateTreeReader(columnId, readerType, context);
            }
            case TIMESTAMP: {
                return new TimestampFromDateTreeReader(columnId, readerType, context);
            }
            case DATE: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    private static TreeReaderFactory.TreeReader createBinaryConvertTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        switch (readerType.getCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringGroupFromBinaryTreeReader(columnId, readerType, context);
            }
            case BINARY: {
                throw new IllegalArgumentException("No conversion of type " + (Object)((Object)readerType.getCategory()) + " to self needed");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)readerType.getCategory()));
    }

    public static TreeReaderFactory.TreeReader createConvertTreeReader(TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
        SchemaEvolution evolution = context.getSchemaEvolution();
        TypeDescription fileType = evolution.getFileType(readerType.getId());
        int columnId = fileType.getId();
        switch (fileType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return ConvertTreeReaderFactory.createAnyIntegerConvertTreeReader(columnId, fileType, readerType, context);
            }
            case FLOAT: {
                return ConvertTreeReaderFactory.createFloatConvertTreeReader(columnId, fileType, readerType, context);
            }
            case DOUBLE: {
                return ConvertTreeReaderFactory.createDoubleConvertTreeReader(columnId, fileType, readerType, context);
            }
            case DECIMAL: {
                return ConvertTreeReaderFactory.createDecimalConvertTreeReader(columnId, fileType, readerType, context);
            }
            case STRING: {
                return ConvertTreeReaderFactory.createStringConvertTreeReader(columnId, fileType, readerType, context);
            }
            case CHAR: {
                return ConvertTreeReaderFactory.createCharConvertTreeReader(columnId, fileType, readerType, context);
            }
            case VARCHAR: {
                return ConvertTreeReaderFactory.createVarcharConvertTreeReader(columnId, fileType, readerType, context);
            }
            case TIMESTAMP: {
                return ConvertTreeReaderFactory.createTimestampConvertTreeReader(columnId, fileType, readerType, context);
            }
            case DATE: {
                return ConvertTreeReaderFactory.createDateConvertTreeReader(columnId, fileType, readerType, context);
            }
            case BINARY: {
                return ConvertTreeReaderFactory.createBinaryConvertTreeReader(columnId, fileType, readerType, context);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fileType.getCategory()));
    }

    public static boolean canConvert(TypeDescription fileType, TypeDescription readerType) {
        TypeDescription.Category readerTypeCategory = readerType.getCategory();
        switch (readerTypeCategory) {
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return false;
            }
        }
        switch (fileType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                switch (readerType.getCategory()) {
                    case BINARY: 
                    case DATE: {
                        return false;
                    }
                }
                return true;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                switch (readerType.getCategory()) {
                    default: 
                }
                return true;
            }
            case TIMESTAMP: {
                switch (readerType.getCategory()) {
                    case BINARY: {
                        return false;
                    }
                }
                return true;
            }
            case DATE: {
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: 
                    case BINARY: {
                        return false;
                    }
                }
                return true;
            }
            case BINARY: {
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: 
                    case TIMESTAMP: {
                        return false;
                    }
                }
                return true;
            }
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)fileType.getCategory()));
    }

    public static class BinaryFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;

        BinaryFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            super.nextVector(previousVector, isNull, batchSize);
        }
    }

    public static class DateFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private TimestampColumnVector timestampColVector;
        private LongColumnVector longColVector;

        DateFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, context);
            this.setConvertTreeReader(this.timestampTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            Date dateValue = DateWritable.timeToDate(TimestampUtils.millisToSeconds(this.timestampColVector.asScratchTimestamp(elementNum).getTime()));
            this.longColVector.vector[elementNum] = DateWritable.dateToDays(dateValue);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, isNull, batchSize);
            this.convertVector(this.timestampColVector, this.longColVector, batchSize);
        }
    }

    public static class DateFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private BytesColumnVector bytesColVector;
        private LongColumnVector longColVector;

        DateFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String stringValue = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            Date dateValue = this.parseDateFromString(stringValue);
            if (dateValue != null) {
                this.longColVector.vector[elementNum] = DateWritable.dateToDays(dateValue);
            } else {
                this.longColVector.noNulls = false;
                this.longColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, isNull, batchSize);
            this.convertVector(this.bytesColVector, this.longColVector, batchSize);
        }
    }

    public static class TimestampFromDateTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DateTreeReader dateTreeReader;
        private LongColumnVector longColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromDateTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.dateTreeReader = new TreeReaderFactory.DateTreeReader(columnId, context);
            this.setConvertTreeReader(this.dateTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long millis = DateWritable.daysToMillis((int)this.longColVector.vector[elementNum]);
            this.timestampColVector.set(elementNum, new Timestamp(millis));
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.dateTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.timestampColVector, batchSize);
        }
    }

    public static class TimestampFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private BytesColumnVector bytesColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String stringValue = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            Timestamp timestampValue = this.parseTimestampFromString(stringValue);
            if (timestampValue != null) {
                this.timestampColVector.set(elementNum, timestampValue);
            } else {
                this.timestampColVector.noNulls = false;
                this.timestampColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, isNull, batchSize);
            this.convertVector(this.bytesColVector, this.timestampColVector, batchSize);
        }
    }

    public static class TimestampFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private DecimalColumnVector decimalColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromDecimalTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale, context);
            this.setConvertTreeReader(this.decimalTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            Timestamp timestampValue = TimestampUtils.decimalToTimestamp(this.decimalColVector.vector[elementNum].getHiveDecimal());
            this.timestampColVector.set(elementNum, timestampValue);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize);
            this.convertVector(this.decimalColVector, this.timestampColVector, batchSize);
        }
    }

    public static class TimestampFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private DoubleColumnVector doubleColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromDoubleTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.doubleColVector.vector[elementNum];
            Timestamp timestampValue = TimestampUtils.doubleToTimestamp(doubleValue);
            this.timestampColVector.set(elementNum, timestampValue);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.timestampColVector, batchSize);
        }
    }

    public static class TimestampFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private DoubleColumnVector doubleColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromFloatTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            Timestamp timestampValue = TimestampUtils.doubleToTimestamp(floatValue);
            this.timestampColVector.set(elementNum, timestampValue);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.timestampColVector, batchSize);
        }
    }

    public static class TimestampFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private TimestampColumnVector timestampColVector;

        TimestampFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            this.timestampColVector.set(elementNum, new Timestamp(longValue));
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.timestampColVector = (TimestampColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.timestampColVector, batchSize);
        }
    }

    public static class StringGroupFromBinaryTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.BinaryTreeReader binaryTreeReader;
        private final TypeDescription readerType;
        private BytesColumnVector inBytesColVector;
        private BytesColumnVector outBytesColVector;

        StringGroupFromBinaryTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.binaryTreeReader = new TreeReaderFactory.BinaryTreeReader(columnId, context);
            this.setConvertTreeReader(this.binaryTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            byte[] bytes = this.inBytesColVector.vector[elementNum];
            int start = this.inBytesColVector.start[elementNum];
            int length = this.inBytesColVector.length[elementNum];
            byte[] string = new byte[length == 0 ? 0 : 3 * length - 1];
            for (int p = 0; p < string.length; p += 2) {
                int num;
                int digit;
                if (p != 0) {
                    string[p++] = 32;
                }
                string[p] = (byte)(digit + ((digit = (num = 0xFF & bytes[start++]) / 16) < 10 ? 48 : 87));
                digit = num % 16;
                string[p + 1] = (byte)(digit + (digit < 10 ? 48 : 87));
            }
            this.assignStringGroupVectorEntry(this.outBytesColVector, elementNum, this.readerType, string, 0, string.length);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.inBytesColVector == null) {
                this.inBytesColVector = new BytesColumnVector();
                this.outBytesColVector = (BytesColumnVector)previousVector;
            }
            this.binaryTreeReader.nextVector(this.inBytesColVector, isNull, batchSize);
            this.convertVector(this.inBytesColVector, this.outBytesColVector, batchSize);
        }
    }

    public static class StringGroupFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription readerType;

        StringGroupFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block5: {
                BytesColumnVector resultColVector;
                block4: {
                    this.stringGroupTreeReader.nextVector(previousVector, isNull, batchSize);
                    resultColVector = (BytesColumnVector)previousVector;
                    if (!resultColVector.isRepeating) break block4;
                    if (!resultColVector.noNulls && resultColVector.isNull[0]) break block5;
                    this.convertStringGroupVectorElement(resultColVector, 0, this.readerType);
                    break block5;
                }
                if (resultColVector.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        this.convertStringGroupVectorElement(resultColVector, i, this.readerType);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (resultColVector.isNull[i]) continue;
                        this.convertStringGroupVectorElement(resultColVector, i, this.readerType);
                    }
                }
            }
        }
    }

    public static class StringGroupFromDateTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DateTreeReader dateTreeReader;
        private final TypeDescription readerType;
        private LongColumnVector longColVector;
        private BytesColumnVector bytesColVector;
        private Date date;

        StringGroupFromDateTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.dateTreeReader = new TreeReaderFactory.DateTreeReader(columnId, context);
            this.setConvertTreeReader(this.dateTreeReader);
            this.date = new Date(0L);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.date.setTime(DateWritable.daysToMillis((int)this.longColVector.vector[elementNum]));
            String string = this.date.toString();
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.dateTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampColumnVector timestampColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromTimestampTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, context);
            this.setConvertTreeReader(this.timestampTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.timestampColVector.asScratchTimestamp(elementNum).toString();
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, isNull, batchSize);
            this.convertVector(this.timestampColVector, this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private int precision;
        private int scale;
        private final TypeDescription readerType;
        private DecimalColumnVector decimalColVector;
        private BytesColumnVector bytesColVector;
        private byte[] scratchBuffer;

        StringGroupFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale, context);
            this.setConvertTreeReader(this.decimalTreeReader);
            this.scratchBuffer = new byte[79];
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            HiveDecimalWritable decWritable = this.decimalColVector.vector[elementNum];
            int byteIndex = decWritable.toBytes(this.scratchBuffer);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, this.scratchBuffer, byteIndex, 79 - byteIndex);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize);
            this.convertVector(this.decimalColVector, this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private final TypeDescription readerType;
        private DoubleColumnVector doubleColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromDoubleTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.doubleColVector.vector[elementNum];
            if (!Double.isNaN(doubleValue)) {
                String string = String.valueOf(doubleValue);
                byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
                this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
            } else {
                this.bytesColVector.noNulls = false;
                this.bytesColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private final TypeDescription readerType;
        private DoubleColumnVector doubleColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromFloatTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            if (!Float.isNaN(floatValue)) {
                String string = String.valueOf(floatValue);
                byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
                this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
            } else {
                this.bytesColVector.noNulls = false;
                this.bytesColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.bytesColVector, batchSize);
        }
    }

    public static class StringGroupFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private final TypeDescription readerType;
        private LongColumnVector longColVector;
        private BytesColumnVector bytesColVector;

        StringGroupFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            String string = this.anyIntegerAsLongTreeReader.getString(longValue);
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            this.assignStringGroupVectorEntry(this.bytesColVector, elementNum, this.readerType, bytes);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.bytesColVector = (BytesColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.bytesColVector, batchSize);
        }
    }

    public static class DecimalFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private DecimalColumnVector fileDecimalColVector;
        private int filePrecision;
        private int fileScale;
        private ColumnVector decimalColVector;

        DecimalFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.filePrecision = fileType.getPrecision();
            this.fileScale = fileType.getScale();
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.filePrecision, this.fileScale, context);
            this.setConvertTreeReader(this.decimalTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            if (this.decimalColVector instanceof Decimal64ColumnVector) {
                ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, this.fileDecimalColVector.vector[elementNum]);
            } else {
                ((DecimalColumnVector)this.decimalColVector).set(elementNum, this.fileDecimalColVector.vector[elementNum]);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.fileDecimalColVector == null) {
                this.fileDecimalColVector = new DecimalColumnVector(this.filePrecision, this.fileScale);
                this.decimalColVector = previousVector;
            }
            this.decimalTreeReader.nextVector((ColumnVector)this.fileDecimalColVector, isNull, batchSize);
            this.convertVector(this.fileDecimalColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private TimestampColumnVector timestampColVector;
        private ColumnVector decimalColVector;

        DecimalFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, context);
            this.setConvertTreeReader(this.timestampTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            double doubleValue = TimestampUtils.getDouble(this.timestampColVector.asScratchTimestamp(elementNum));
            HiveDecimal value = HiveDecimal.create(Double.toString(doubleValue));
            if (value != null) {
                if (this.decimalColVector instanceof Decimal64ColumnVector) {
                    ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, value);
                } else {
                    ((DecimalColumnVector)this.decimalColVector).set(elementNum, value);
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.decimalColVector = previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, isNull, batchSize);
            this.convertVector(this.timestampColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private BytesColumnVector bytesColVector;
        private ColumnVector decimalColVector;

        DecimalFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            HiveDecimal value = this.parseDecimalFromString(string);
            if (value != null) {
                if (this.decimalColVector instanceof Decimal64ColumnVector) {
                    ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, value);
                } else {
                    ((DecimalColumnVector)this.decimalColVector).set(elementNum, value);
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.decimalColVector = previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, isNull, batchSize);
            this.convertVector(this.bytesColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private DoubleColumnVector doubleColVector;
        private ColumnVector decimalColVector;

        DecimalFromDoubleTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            HiveDecimal value = HiveDecimal.create(Double.toString(this.doubleColVector.vector[elementNum]));
            if (value != null) {
                if (this.decimalColVector instanceof Decimal64ColumnVector) {
                    ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, value);
                } else {
                    ((DecimalColumnVector)this.decimalColVector).set(elementNum, value);
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.decimalColVector = previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private DoubleColumnVector doubleColVector;
        private ColumnVector decimalColVector;

        DecimalFromFloatTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            float floatValue = (float)this.doubleColVector.vector[elementNum];
            if (!Float.isNaN(floatValue)) {
                HiveDecimal decimalValue = HiveDecimal.create(Float.toString(floatValue));
                if (decimalValue != null) {
                    if (this.decimalColVector instanceof Decimal64ColumnVector) {
                        ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, decimalValue);
                    } else {
                        ((DecimalColumnVector)this.decimalColVector).set(elementNum, decimalValue);
                    }
                } else {
                    this.decimalColVector.noNulls = false;
                    this.decimalColVector.isNull[elementNum] = true;
                }
            } else {
                this.decimalColVector.noNulls = false;
                this.decimalColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.decimalColVector = previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DecimalFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private ColumnVector decimalColVector;

        DecimalFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            long longValue = this.longColVector.vector[elementNum];
            HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(longValue);
            if (this.decimalColVector instanceof Decimal64ColumnVector) {
                ((Decimal64ColumnVector)this.decimalColVector).set(elementNum, hiveDecimalWritable);
            } else {
                ((DecimalColumnVector)this.decimalColVector).set(elementNum, hiveDecimalWritable);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.decimalColVector = previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.decimalColVector, batchSize);
        }
    }

    public static class DoubleFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private TimestampColumnVector timestampColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, context);
            this.setConvertTreeReader(this.timestampTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = TimestampUtils.getDouble(this.timestampColVector.asScratchTimestamp(elementNum));
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, isNull, batchSize);
            this.convertVector(this.timestampColVector, this.doubleColVector, batchSize);
        }
    }

    public static class DoubleFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private BytesColumnVector bytesColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            double doubleValue = this.parseDoubleFromString(string);
            if (!this.getIsParseError()) {
                this.doubleColVector.vector[elementNum] = doubleValue;
            } else {
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, isNull, batchSize);
            this.convertVector(this.bytesColVector, this.doubleColVector, batchSize);
        }
    }

    public static class DoubleFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private DecimalColumnVector decimalColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromDecimalTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale, context);
            this.setConvertTreeReader(this.decimalTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = this.decimalColVector.vector[elementNum].doubleValue();
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize);
            this.convertVector(this.decimalColVector, this.doubleColVector, batchSize);
        }
    }

    public static class DoubleFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;

        DoubleFromFloatTreeReader(int columnId) throws IOException {
            super(columnId);
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block5: {
                DoubleColumnVector doubleColumnVector;
                block4: {
                    this.floatTreeReader.nextVector(previousVector, isNull, batchSize);
                    doubleColumnVector = (DoubleColumnVector)previousVector;
                    if (!doubleColumnVector.isRepeating) break block4;
                    if (!doubleColumnVector.noNulls && doubleColumnVector.isNull[0]) break block5;
                    float f = (float)doubleColumnVector.vector[0];
                    doubleColumnVector.vector[0] = Double.parseDouble(String.valueOf(f));
                    break block5;
                }
                if (doubleColumnVector.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        float f = (float)doubleColumnVector.vector[i];
                        doubleColumnVector.vector[i] = Double.parseDouble(String.valueOf(f));
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (doubleColumnVector.isNull[i]) continue;
                        float f = (float)doubleColumnVector.vector[i];
                        doubleColumnVector.vector[i] = Double.parseDouble(String.valueOf(f));
                    }
                }
            }
        }
    }

    public static class DoubleFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private DoubleColumnVector doubleColVector;

        DoubleFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) {
            double doubleValue = this.longColVector.vector[elementNum];
            if (!Double.isNaN(doubleValue)) {
                this.doubleColVector.vector[elementNum] = doubleValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.doubleColVector, batchSize);
        }
    }

    public static class FloatFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private TimestampColumnVector timestampColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromTimestampTreeReader(int columnId, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, context);
            this.setConvertTreeReader(this.timestampTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = (float)TimestampUtils.getDouble(this.timestampColVector.asScratchTimestamp(elementNum));
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, isNull, batchSize);
            this.convertVector(this.timestampColVector, this.doubleColVector, batchSize);
        }
    }

    public static class FloatFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private BytesColumnVector bytesColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            float floatValue = this.parseFloatFromString(string);
            if (!this.getIsParseError()) {
                this.doubleColVector.vector[elementNum] = floatValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, isNull, batchSize);
            this.convertVector(this.bytesColVector, this.doubleColVector, batchSize);
        }
    }

    public static class FloatFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private DecimalColumnVector decimalColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale, context);
            this.setConvertTreeReader(this.decimalTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            this.doubleColVector.vector[elementNum] = (float)this.decimalColVector.vector[elementNum].doubleValue();
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize);
            this.convertVector(this.decimalColVector, this.doubleColVector, batchSize);
        }
    }

    public static class FloatFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;

        FloatFromDoubleTreeReader(int columnId) throws IOException {
            super(columnId);
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block5: {
                double[] resultVector;
                DoubleColumnVector resultColVector;
                block4: {
                    this.doubleTreeReader.nextVector(previousVector, isNull, batchSize);
                    resultColVector = (DoubleColumnVector)previousVector;
                    resultVector = resultColVector.vector;
                    if (!resultColVector.isRepeating) break block4;
                    if (!resultColVector.noNulls && resultColVector.isNull[0]) break block5;
                    resultVector[0] = (float)resultVector[0];
                    break block5;
                }
                if (resultColVector.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        resultVector[i] = (float)resultVector[i];
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (resultColVector.isNull[i]) continue;
                        resultVector[i] = (float)resultVector[i];
                    }
                }
            }
        }
    }

    public static class FloatFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private LongColumnVector longColVector;
        private DoubleColumnVector doubleColVector;

        FloatFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            float floatValue = this.longColVector.vector[elementNum];
            if (!Float.isNaN(floatValue)) {
                this.doubleColVector.vector[elementNum] = floatValue;
            } else {
                this.doubleColVector.vector[elementNum] = Double.NaN;
                this.doubleColVector.noNulls = false;
                this.doubleColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.longColVector == null) {
                this.longColVector = new LongColumnVector();
                this.doubleColVector = (DoubleColumnVector)previousVector;
            }
            this.anyIntegerAsLongTreeReader.nextVector(this.longColVector, isNull, batchSize);
            this.convertVector(this.longColVector, this.doubleColVector, batchSize);
        }
    }

    public static class AnyIntegerFromTimestampTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TimestampTreeReader timestampTreeReader;
        private final TypeDescription readerType;
        private TimestampColumnVector timestampColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromTimestampTreeReader(int columnId, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.timestampTreeReader = new TreeReaderFactory.TimestampTreeReader(columnId, context);
            this.setConvertTreeReader(this.timestampTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            long longValue = TimestampUtils.millisToSeconds(this.timestampColVector.asScratchTimestamp(elementNum).getTime());
            this.downCastAnyInteger(this.longColVector, elementNum, longValue, this.readerType);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.timestampColVector == null) {
                this.timestampColVector = new TimestampColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.timestampTreeReader.nextVector(this.timestampColVector, isNull, batchSize);
            this.convertVector(this.timestampColVector, this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromStringGroupTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.TreeReader stringGroupTreeReader;
        private final TypeDescription readerType;
        private BytesColumnVector bytesColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromStringGroupTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.stringGroupTreeReader = this.getStringGroupTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.stringGroupTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            String string = this.stringFromBytesColumnVectorEntry(this.bytesColVector, elementNum);
            long longValue = this.parseLongFromString(string);
            if (!this.getIsParseError()) {
                this.downCastAnyInteger(this.longColVector, elementNum, longValue, this.readerType);
            } else {
                this.longColVector.noNulls = false;
                this.longColVector.isNull[elementNum] = true;
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.bytesColVector == null) {
                this.bytesColVector = new BytesColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.stringGroupTreeReader.nextVector(this.bytesColVector, isNull, batchSize);
            this.convertVector(this.bytesColVector, this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromDecimalTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DecimalTreeReader decimalTreeReader;
        private final int precision;
        private final int scale;
        private final TypeDescription readerType;
        private DecimalColumnVector decimalColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromDecimalTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.precision = fileType.getPrecision();
            this.scale = fileType.getScale();
            this.readerType = readerType;
            this.decimalTreeReader = new TreeReaderFactory.DecimalTreeReader(columnId, this.precision, this.scale, context);
            this.setConvertTreeReader(this.decimalTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            boolean isInRange;
            HiveDecimalWritable decWritable = this.decimalColVector.vector[elementNum];
            long[] vector = this.longColVector.vector;
            TypeDescription.Category readerCategory = this.readerType.getCategory();
            switch (readerCategory) {
                case BOOLEAN: {
                    vector[elementNum] = decWritable.signum() == 0 ? 0L : 1L;
                    return;
                }
                case BYTE: {
                    isInRange = decWritable.isByte();
                    break;
                }
                case SHORT: {
                    isInRange = decWritable.isShort();
                    break;
                }
                case INT: {
                    isInRange = decWritable.isInt();
                    break;
                }
                case LONG: {
                    isInRange = decWritable.isLong();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerCategory.name());
                }
            }
            if (!isInRange) {
                this.longColVector.isNull[elementNum] = true;
                this.longColVector.noNulls = false;
            } else {
                switch (readerCategory) {
                    case BYTE: {
                        vector[elementNum] = decWritable.byteValue();
                        break;
                    }
                    case SHORT: {
                        vector[elementNum] = decWritable.shortValue();
                        break;
                    }
                    case INT: {
                        vector[elementNum] = decWritable.intValue();
                        break;
                    }
                    case LONG: {
                        vector[elementNum] = decWritable.longValue();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected type kind " + readerCategory.name());
                    }
                }
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.decimalColVector == null) {
                this.decimalColVector = new DecimalColumnVector(this.precision, this.scale);
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.decimalTreeReader.nextVector((ColumnVector)this.decimalColVector, isNull, batchSize);
            this.convertVector(this.decimalColVector, this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromDoubleTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.DoubleTreeReader doubleTreeReader;
        private final TypeDescription readerType;
        private DoubleColumnVector doubleColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromDoubleTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.doubleTreeReader = new TreeReaderFactory.DoubleTreeReader(columnId);
            this.setConvertTreeReader(this.doubleTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            double doubleValue = this.doubleColVector.vector[elementNum];
            if (!this.doubleCanFitInLong(doubleValue)) {
                this.longColVector.isNull[elementNum] = true;
                this.longColVector.noNulls = false;
            } else {
                this.downCastAnyInteger(this.longColVector, elementNum, (long)doubleValue, this.readerType);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.doubleTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromFloatTreeReader
    extends ConvertTreeReader {
        private TreeReaderFactory.FloatTreeReader floatTreeReader;
        private final TypeDescription readerType;
        private DoubleColumnVector doubleColVector;
        private LongColumnVector longColVector;

        AnyIntegerFromFloatTreeReader(int columnId, TypeDescription readerType) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.floatTreeReader = new TreeReaderFactory.FloatTreeReader(columnId);
            this.setConvertTreeReader(this.floatTreeReader);
        }

        @Override
        public void setConvertVectorElement(int elementNum) throws IOException {
            double doubleValue = this.doubleColVector.vector[elementNum];
            if (!this.doubleCanFitInLong(doubleValue)) {
                this.longColVector.isNull[elementNum] = true;
                this.longColVector.noNulls = false;
            } else {
                float floatValue = (float)doubleValue;
                this.downCastAnyInteger(this.longColVector, elementNum, (long)floatValue, this.readerType);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.doubleColVector == null) {
                this.doubleColVector = new DoubleColumnVector();
                this.longColVector = (LongColumnVector)previousVector;
            }
            this.floatTreeReader.nextVector(this.doubleColVector, isNull, batchSize);
            this.convertVector(this.doubleColVector, this.longColVector, batchSize);
        }
    }

    public static class AnyIntegerFromAnyIntegerTreeReader
    extends ConvertTreeReader {
        private AnyIntegerTreeReader anyIntegerAsLongTreeReader;
        private final TypeDescription readerType;
        private final boolean downCastNeeded;

        AnyIntegerFromAnyIntegerTreeReader(int columnId, TypeDescription fileType, TypeDescription readerType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.readerType = readerType;
            this.anyIntegerAsLongTreeReader = new AnyIntegerTreeReader(columnId, fileType, context);
            this.setConvertTreeReader(this.anyIntegerAsLongTreeReader);
            this.downCastNeeded = this.integerDownCastNeeded(fileType, readerType);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            block4: {
                LongColumnVector resultColVector;
                block5: {
                    this.anyIntegerAsLongTreeReader.nextVector(previousVector, isNull, batchSize);
                    resultColVector = (LongColumnVector)previousVector;
                    if (!this.downCastNeeded) break block4;
                    if (!resultColVector.isRepeating) break block5;
                    if (!resultColVector.noNulls && resultColVector.isNull[0]) break block4;
                    this.downCastAnyInteger(resultColVector, 0, this.readerType);
                    break block4;
                }
                if (resultColVector.noNulls) {
                    for (int i = 0; i < batchSize; ++i) {
                        this.downCastAnyInteger(resultColVector, i, this.readerType);
                    }
                } else {
                    for (int i = 0; i < batchSize; ++i) {
                        if (resultColVector.isNull[i]) continue;
                        this.downCastAnyInteger(resultColVector, i, this.readerType);
                    }
                }
            }
        }
    }

    public static class AnyIntegerTreeReader
    extends ConvertTreeReader {
        private TypeDescription.Category fileTypeCategory;
        private TreeReaderFactory.TreeReader anyIntegerTreeReader;

        AnyIntegerTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            super(columnId);
            this.fileTypeCategory = fileType.getCategory();
            switch (this.fileTypeCategory) {
                case BOOLEAN: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.BooleanTreeReader(columnId);
                    break;
                }
                case BYTE: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.ByteTreeReader(columnId);
                    break;
                }
                case SHORT: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.ShortTreeReader(columnId, context);
                    break;
                }
                case INT: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.IntTreeReader(columnId, context);
                    break;
                }
                case LONG: {
                    this.anyIntegerTreeReader = new TreeReaderFactory.LongTreeReader(columnId, context);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
                }
            }
            this.setConvertTreeReader(this.anyIntegerTreeReader);
        }

        protected String getString(long longValue) {
            if (this.fileTypeCategory == TypeDescription.Category.BOOLEAN) {
                return longValue == 0L ? "FALSE" : "TRUE";
            }
            return Long.toString(longValue);
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            this.anyIntegerTreeReader.nextVector(previousVector, isNull, batchSize);
        }
    }

    public static class ConvertTreeReader
    extends TreeReaderFactory.TreeReader {
        private TreeReaderFactory.TreeReader convertTreeReader;
        private static EnumMap<TypeDescription.Category, Integer> numericTypes = new EnumMap(TypeDescription.Category.class);
        private boolean isParseError;
        private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
        private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;

        ConvertTreeReader(int columnId) throws IOException {
            super(columnId, null);
        }

        private static void registerNumericType(TypeDescription.Category kind, int level) {
            numericTypes.put(kind, level);
        }

        protected void setConvertTreeReader(TreeReaderFactory.TreeReader convertTreeReader) {
            this.convertTreeReader = convertTreeReader;
        }

        protected TreeReaderFactory.TreeReader getStringGroupTreeReader(int columnId, TypeDescription fileType, TreeReaderFactory.Context context) throws IOException {
            switch (fileType.getCategory()) {
                case STRING: {
                    return new TreeReaderFactory.StringTreeReader(columnId, context);
                }
                case CHAR: {
                    return new TreeReaderFactory.CharTreeReader(columnId, fileType.getMaxLength());
                }
                case VARCHAR: {
                    return new TreeReaderFactory.VarcharTreeReader(columnId, fileType.getMaxLength());
                }
            }
            throw new RuntimeException("Unexpected type kind " + fileType.getCategory().name());
        }

        protected void assignStringGroupVectorEntry(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType, byte[] bytes) {
            this.assignStringGroupVectorEntry(bytesColVector, elementNum, readerType, bytes, 0, bytes.length);
        }

        protected void assignStringGroupVectorEntry(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType, byte[] bytes, int start, int length) {
            switch (readerType.getCategory()) {
                case STRING: {
                    bytesColVector.setVal(elementNum, bytes, start, length);
                    break;
                }
                case CHAR: {
                    int adjustedDownLen = StringExpr.rightTrimAndTruncate(bytes, start, length, readerType.getMaxLength());
                    bytesColVector.setVal(elementNum, bytes, start, adjustedDownLen);
                    break;
                }
                case VARCHAR: {
                    int adjustedDownLen = StringExpr.truncate(bytes, start, length, readerType.getMaxLength());
                    bytesColVector.setVal(elementNum, bytes, start, adjustedDownLen);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
                }
            }
        }

        protected void convertStringGroupVectorElement(BytesColumnVector bytesColVector, int elementNum, TypeDescription readerType) {
            switch (readerType.getCategory()) {
                case STRING: {
                    break;
                }
                case CHAR: {
                    int length = bytesColVector.length[elementNum];
                    int adjustedDownLen = StringExpr.rightTrimAndTruncate(bytesColVector.vector[elementNum], bytesColVector.start[elementNum], length, readerType.getMaxLength());
                    if (adjustedDownLen >= length) break;
                    bytesColVector.length[elementNum] = adjustedDownLen;
                    break;
                }
                case VARCHAR: {
                    int length = bytesColVector.length[elementNum];
                    int adjustedDownLen = StringExpr.truncate(bytesColVector.vector[elementNum], bytesColVector.start[elementNum], length, readerType.getMaxLength());
                    if (adjustedDownLen >= length) break;
                    bytesColVector.length[elementNum] = adjustedDownLen;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerType.getCategory().name());
                }
            }
        }

        protected boolean getIsParseError() {
            return this.isParseError;
        }

        protected long parseLongFromString(String string) {
            try {
                long longValue = Long.parseLong(string);
                this.isParseError = false;
                return longValue;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return 0L;
            }
        }

        protected float parseFloatFromString(String string) {
            try {
                float floatValue = Float.parseFloat(string);
                this.isParseError = false;
                return floatValue;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return Float.NaN;
            }
        }

        protected double parseDoubleFromString(String string) {
            try {
                double value = Double.parseDouble(string);
                this.isParseError = false;
                return value;
            }
            catch (NumberFormatException e) {
                this.isParseError = true;
                return Double.NaN;
            }
        }

        protected HiveDecimal parseDecimalFromString(String string) {
            try {
                HiveDecimal value = HiveDecimal.create(string);
                return value;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        protected Timestamp parseTimestampFromString(String string) {
            try {
                Timestamp value = Timestamp.valueOf(string);
                return value;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        protected Date parseDateFromString(String string) {
            try {
                Date value = Date.valueOf(string);
                return value;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        protected String stringFromBytesColumnVectorEntry(BytesColumnVector bytesColVector, int elementNum) {
            String string = new String(bytesColVector.vector[elementNum], bytesColVector.start[elementNum], bytesColVector.length[elementNum], StandardCharsets.UTF_8);
            return string;
        }

        public boolean doubleCanFitInLong(double doubleValue) {
            return -9.223372036854776E18 - doubleValue < 1.0 && doubleValue < 9.223372036854776E18;
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.convertTreeReader.checkEncoding(encoding);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            this.convertTreeReader.startStripe(streams, stripeFooter);
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            this.convertTreeReader.seek(index);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.convertTreeReader.seek(index);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.convertTreeReader.skipRows(items);
        }

        public void setConvertVectorElement(int elementNum) throws IOException {
            throw new RuntimeException("Expected this method to be overriden");
        }

        public void convertVector(ColumnVector fromColVector, ColumnVector resultColVector, int batchSize) throws IOException {
            resultColVector.reset();
            if (fromColVector.isRepeating) {
                resultColVector.isRepeating = true;
                if (fromColVector.noNulls || !fromColVector.isNull[0]) {
                    this.setConvertVectorElement(0);
                } else {
                    resultColVector.noNulls = false;
                    resultColVector.isNull[0] = true;
                }
            } else if (fromColVector.noNulls) {
                for (int i = 0; i < batchSize; ++i) {
                    this.setConvertVectorElement(i);
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (!fromColVector.isNull[i]) {
                        this.setConvertVectorElement(i);
                        continue;
                    }
                    resultColVector.noNulls = false;
                    resultColVector.isNull[i] = true;
                }
            }
        }

        public void downCastAnyInteger(LongColumnVector longColVector, int elementNum, TypeDescription readerType) {
            this.downCastAnyInteger(longColVector, elementNum, longColVector.vector[elementNum], readerType);
        }

        public void downCastAnyInteger(LongColumnVector longColVector, int elementNum, long inputLong, TypeDescription readerType) {
            long outputLong;
            long[] vector = longColVector.vector;
            TypeDescription.Category readerCategory = readerType.getCategory();
            switch (readerCategory) {
                case BOOLEAN: {
                    vector[elementNum] = inputLong == 0L ? 0L : 1L;
                    return;
                }
                case BYTE: {
                    outputLong = (byte)inputLong;
                    break;
                }
                case SHORT: {
                    outputLong = (short)inputLong;
                    break;
                }
                case INT: {
                    outputLong = (int)inputLong;
                    break;
                }
                case LONG: {
                    vector[elementNum] = inputLong;
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected type kind " + readerCategory.name());
                }
            }
            if (outputLong != inputLong) {
                longColVector.isNull[elementNum] = true;
                longColVector.noNulls = false;
            } else {
                vector[elementNum] = outputLong;
            }
        }

        protected boolean integerDownCastNeeded(TypeDescription fileType, TypeDescription readerType) {
            Integer fileLevel = numericTypes.get((Object)fileType.getCategory());
            Integer schemaLevel = numericTypes.get((Object)readerType.getCategory());
            return schemaLevel < fileLevel;
        }

        static {
            ConvertTreeReader.registerNumericType(TypeDescription.Category.BOOLEAN, 1);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.BYTE, 2);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.SHORT, 3);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.INT, 4);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.LONG, 5);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.FLOAT, 6);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.DOUBLE, 7);
            ConvertTreeReader.registerNumericType(TypeDescription.Category.DECIMAL, 8);
        }
    }
}

