/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.oak.exercise.security.privilege;

import org.apache.jackrabbit.oak.AbstractSecurityTest;

/**
 * <pre>
 * Module: Privilege Management
 * =============================================================================
 *
 * Title: Introduction
 * -----------------------------------------------------------------------------
 *
 * Goal:
 * Become familiar with the Privilege Management API defined in
 * JCR Access Control Management and by the extensions present in Jackrabbit API.
 * Having completed this section should also be familiar with the internals of
 * privilege management in Oak.
 *
 * Exercises:
 *
 * - Privilege Management in the JCR API
 *   Search for interfaces and methods related to privilege management in JSR 283
 *   and the corresponding JCR API definitions.
 *
 *   Question: Can you list all interfaces and methods?
 *
 * - Privilege Management in Jackrabbit API extensions
 *   Search for interfaces and methods related to privilege management in the
 *   Jackrabbit API extensions.
 *
 *   Question: Can you list all interfaces and methods?
 *   Question: What can you say wrt the difference in privilege management between JCR and Jackrabbit API?
 *
 * - Privilege Management in Oak
 *   Search the Oak security modules for privilege related extensions.
 *
 *   Question: Can you list the interfaces, classes, methods?
 *   Question: Can you describe the relation between these extensions and the JCR|Jackrabbit API?
 *
 * Related Exercises:
 * -----------------------------------------------------------------------------
 *
 * - {@link L2_PrivilegeManagementTest}
 * - {@link L7_PrivilegeDiscoveryTest}
 *
 * </pre>
 *
 */
public class L1_IntroductionTest extends AbstractSecurityTest {


}