/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree.rewriter;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorWithBuffer;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.buffer.PtrBuffer;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageMgr;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPTStateMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreeNodeMgr;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.apache.jena.dboe.trans.bplustree.rewriter.BPTreeNodeBuilder;
import org.apache.jena.dboe.trans.bplustree.rewriter.RecordBufferPageLinker;
import org.apache.jena.dboe.trans.bplustree.rewriter.RecordBufferPagePacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPlusTreeRewriter {
    private static Logger log = LoggerFactory.getLogger(BPlusTreeRewriter.class);
    public static final boolean rebalance = true;
    public static final boolean debug = false;
    private static final boolean materialize = false;

    public static BPlusTree packIntoBPlusTree(Iterator<Record> iterRecords, BPlusTreeParams bptParams, RecordFactory recordFactory, BufferChannel bptState, BlockMgr blkMgrNodes, BlockMgr blkMgrRecords) {
        if (!iterRecords.hasNext()) {
            return BPlusTreeFactory.createNonTxn(bptParams, bptState, blkMgrNodes, blkMgrRecords);
        }
        BPlusTree bpt2 = BPT.createRootOnlyBPTree(bptParams, bptState, blkMgrNodes, blkMgrRecords);
        BPTreeNode root2 = bpt2.getNodeManager().getWrite(0, -2);
        Iterator<Pair<Integer, Record>> iter = BPlusTreeRewriter.writePackedDataBlocks(iterRecords, bpt2);
        boolean leafLayer = true;
        while (true) {
            IteratorWithBuffer<Pair<Integer, Record>> iter2;
            boolean singleBlock = (iter2 = new IteratorWithBuffer<Pair<Integer, Record>>(iter = BPlusTreeRewriter.genTreeLevel(iter, bpt2, leafLayer), 2)).peek(1) == null;
            iter = iter2;
            if (singleBlock) break;
            leafLayer = false;
        }
        Pair<Integer, Record> pair = iter.next();
        if (iter.hasNext()) {
            log.error("**** Building index layers didn't result in a single block");
            return null;
        }
        BPlusTreeRewriter.fixupRoot(root2, pair, bpt2);
        bpt2.sync();
        BPTStateMgr stateManager = bpt2.getStateManager();
        BlockMgr nodeBlkMgr = bpt2.getNodeManager().getBlockMgr();
        BlockMgr recordsBlkMgr = bpt2.getRecordsMgr().getBlockMgr();
        long nodeAllocLimit = nodeBlkMgr.allocLimit();
        long recordAllocLimit = recordsBlkMgr.allocLimit();
        stateManager.setState(bpt2.getRootId(), nodeAllocLimit, recordAllocLimit);
        stateManager.writeState();
        stateManager.sync();
        return bpt2;
    }

    private static Iterator<Pair<Integer, Record>> writePackedDataBlocks(Iterator<Record> records, BPlusTree bpt) {
        RecordBufferPageMgr mgr = bpt.getRecordsMgr().getRecordBufferPageMgr();
        RecordBufferPageLinker iter = new RecordBufferPageLinker(new RecordBufferPagePacker(records, mgr));
        RebalenceDataEnd iter2 = Iter.map(iter, rbp -> {
            mgr.put(rbp);
            Record r = rbp.getRecordBuffer().getHigh();
            r = bpt.getRecordFactory().createKeyOnly(r);
            return new Pair<Integer, Record>(rbp.getId(), r);
        });
        iter2 = new RebalenceDataEnd(iter2, bpt);
        return iter2;
    }

    private static Iterator<Pair<Integer, Record>> genTreeLevel(Iterator<Pair<Integer, Record>> iter, BPlusTree bpt, boolean leafLayer) {
        Iterator<Pair<Integer, Record>> iter2 = new BPTreeNodeBuilder(iter, bpt.getNodeManager(), leafLayer, bpt.getRecordFactory());
        iter2 = new RebalenceIndexEnd(iter2, bpt, leafLayer);
        return iter2;
    }

    private static void fixupRoot(BPTreeNode root2, Pair<Integer, Record> pair, BPlusTree bpt2) {
        root2.getPtrBuffer().clear();
        root2.getRecordBuffer().clear();
        BPTreeNode node = bpt2.getNodeManager().getRead(pair.car(), -2);
        BPlusTreeRewriter.copyBPTreeNode(node, root2, bpt2);
        bpt2.getNodeManager().release(node);
        bpt2.getNodeManager().write(root2);
    }

    private static void copyBPTreeNode(BPTreeNode nodeSrc, BPTreeNode nodeDst, BPlusTree bpt2) {
        PtrBuffer pBuff = nodeSrc.getPtrBuffer();
        pBuff.copy(0, nodeDst.getPtrBuffer(), 0, pBuff.getSize());
        RecordBuffer rBuff = nodeSrc.getRecordBuffer();
        rBuff.copy(0, nodeDst.getRecordBuffer(), 0, rBuff.getSize());
        nodeDst.setCount(nodeSrc.getCount());
        nodeDst.setIsLeaf(nodeSrc.isLeaf());
        bpt2.getNodeManager().put(nodeDst);
    }

    private static class RebalenceDataEnd
    extends RebalenceBase {
        private RecordBufferPageMgr mgr;
        private BPlusTree bpt;

        public RebalenceDataEnd(Iterator<Pair<Integer, Record>> iter, BPlusTree bpt) {
            super(iter);
            this.bpt = bpt;
        }

        @Override
        protected Record rebalance(int id1, Record r1, int id2, Record r2) {
            RecordBufferPageMgr mgr = this.bpt.getRecordsMgr().getRecordBufferPageMgr();
            RecordBufferPage page1 = (RecordBufferPage)mgr.getWrite(id1);
            RecordBufferPage page2 = (RecordBufferPage)mgr.getWrite(id2);
            int x1 = page2.getCount();
            int x2 = page1.getMaxSize() / 2;
            for (int i = page2.getCount(); i < page1.getMaxSize() / 2; ++i) {
                Record r = page1.getRecordBuffer().getHigh();
                page1.getRecordBuffer().removeTop();
                page2.getRecordBuffer().add(0, r);
            }
            mgr.put(page1);
            mgr.put(page2);
            Record splitPoint = page1.getRecordBuffer().getHigh();
            splitPoint = this.bpt.getRecordFactory().createKeyOnly(splitPoint);
            return splitPoint;
        }
    }

    private static class RebalenceIndexEnd
    extends RebalenceBase {
        private BPlusTree bpt;

        public RebalenceIndexEnd(Iterator<Pair<Integer, Record>> iter, BPlusTree bpt, boolean leafLayer) {
            super(iter);
            this.bpt = bpt;
        }

        @Override
        protected Record rebalance(int id1, Record r1, int id2, Record r2) {
            BPTreeNodeMgr mgr = this.bpt.getNodeManager();
            BPTreeNode node1 = mgr.getWrite(id1);
            BPTreeNode node2 = mgr.getWrite(id2);
            int count = node2.getCount();
            if (count >= this.bpt.getParams().getMinRec()) {
                return null;
            }
            Record splitPoint = r1;
            for (int i = count; i < this.bpt.getParams().getMinRec(); ++i) {
                Record r = splitPoint;
                int ptr = node1.getPtrBuffer().getHigh();
                splitPoint = node1.getRecordBuffer().getHigh();
                node1.getPtrBuffer().removeTop();
                node1.getRecordBuffer().removeTop();
                node1.setCount(node1.getCount() - 1);
                node2.getPtrBuffer().add(0, ptr);
                node2.getRecordBuffer().add(0, r);
                node2.setCount(node2.getCount() + 1);
            }
            mgr.put(node1);
            mgr.put(node2);
            return splitPoint;
        }
    }

    private static abstract class RebalenceBase
    extends IteratorWithBuffer<Pair<Integer, Record>> {
        protected RebalenceBase(Iterator<Pair<Integer, Record>> iter) {
            super(iter, 2);
        }

        @Override
        protected final void endReachedInner() {
            Pair<Integer, Record> pair1 = (Pair<Integer, Record>)this.peek(0);
            Pair pair2 = (Pair)this.peek(1);
            if (pair1 == null || pair2 == null) {
                return;
            }
            Record newSplitPoint = this.rebalance((Integer)pair1.car(), (Record)pair1.cdr(), (Integer)pair2.car(), (Record)pair2.cdr());
            if (newSplitPoint != null) {
                pair1 = new Pair<Integer, Record>((Integer)pair1.car(), newSplitPoint);
                this.set(0, pair1);
            }
        }

        protected abstract Record rebalance(int var1, Record var2, int var3, Record var4);
    }
}

