/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.MergedProperties;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultConicProjection;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultCylindricalProjection;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPlanarProjection;
import org.apache.sis.referencing.operation.DefaultProjection;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultCoordinateOperationFactory
extends AbstractFactory
implements CoordinateOperationFactory {
    static final boolean USE_EPSG_FACTORY = true;
    private final Map<String, ?> defaultProperties;
    final CRSFactory crsFactory;
    final CSFactory csFactory;
    private final MathTransformFactory mtFactory;
    private final WeakHashSet<IdentifiedObject> pool;
    final Cache<CRSPair, CoordinateOperation> cache;
    private static final DefaultCoordinateOperationFactory INSTANCE = new DefaultCoordinateOperationFactory();

    public static DefaultCoordinateOperationFactory provider() {
        return INSTANCE;
    }

    public DefaultCoordinateOperationFactory() {
        this(null, null);
    }

    public DefaultCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory factory) {
        CSFactory csFactory;
        CRSFactory crsFactory;
        if (properties == null || properties.isEmpty()) {
            properties = Map.of();
            crsFactory = null;
            csFactory = null;
        } else {
            MathTransformFactory mtFactory;
            String key = null;
            Object value = null;
            properties = new HashMap(properties);
            try {
                key = "crsFactory";
                value = properties.remove("crsFactory");
                crsFactory = (CRSFactory)value;
                key = "csFactory";
                value = properties.remove("csFactory");
                csFactory = (CSFactory)value;
                key = "mtFactory";
                value = properties.remove("mtFactory");
                mtFactory = (MathTransformFactory)value;
            }
            catch (ClassCastException e2) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)58, key, Classes.getClass(value)));
            }
            properties.remove("datumFactory");
            properties = Map.copyOf(properties);
            if (factory == null) {
                factory = mtFactory;
            }
        }
        this.mtFactory = factory != null ? factory : DefaultMathTransformFactory.provider();
        this.csFactory = csFactory != null ? csFactory : GeodeticObjectFactory.provider();
        this.crsFactory = crsFactory != null ? crsFactory : GeodeticObjectFactory.provider();
        this.defaultProperties = properties;
        this.pool = new WeakHashSet<IdentifiedObject>(IdentifiedObject.class);
        this.cache = new Cache(12, 50L, true);
    }

    protected Map<String, ?> complete(Map<String, ?> properties) {
        ArgumentChecks.ensureNonNull("properties", properties);
        return new MergedProperties(properties, this.defaultProperties);
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.mtFactory;
    }

    final DefaultMathTransformFactory getDefaultMathTransformFactory() {
        MathTransformFactory factory = this.getMathTransformFactory();
        if (factory instanceof DefaultMathTransformFactory) {
            return (DefaultMathTransformFactory)factory;
        }
        return DefaultMathTransformFactory.provider();
    }

    public OperationMethod getOperationMethod(String name) throws FactoryException {
        name = name.strip();
        ArgumentChecks.ensureNonEmpty("name", name);
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (mtFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mtFactory).getOperationMethod(name);
        }
        OperationMethod method = CoordinateOperations.getOperationMethod(mtFactory.getAvailableMethods(SingleOperation.class), name);
        if (method != null) {
            return method;
        }
        throw new NoSuchIdentifierException(Resources.forProperties(this.defaultProperties).getString((short)50, name, "https://sis.apache.org/tables/CoordinateOperationMethods.html"), name);
    }

    public OperationMethod createOperationMethod(Map<String, ?> properties, ParameterDescriptorGroup parameters) throws FactoryException {
        DefaultOperationMethod method;
        try {
            method = new DefaultOperationMethod(properties, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.pool.unique(method);
    }

    @Override
    public Conversion createDefiningConversion(Map<String, ?> properties, OperationMethod method, ParameterValueGroup parameters) throws FactoryException {
        DefaultConversion conversion;
        try {
            conversion = new DefaultConversion(properties, method, null, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return conversion;
    }

    private static boolean isConversion(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        int i;
        List<SingleCRS> components = CRS.getSingleComponents(sourceCRS);
        int n = components.size();
        Datum[] datum = new Datum[n];
        for (i = 0; i < n; ++i) {
            datum[i] = components.get(i).getDatum();
        }
        components = CRS.getSingleComponents(targetCRS);
        i = components.size();
        block1: while (--i >= 0) {
            Datum d = components.get(i).getDatum();
            int j = n;
            while (--j >= 0) {
                if (!Utilities.equalsIgnoreMetadata(d, datum[j])) continue;
                System.arraycopy(datum, j + 1, datum, j, --n - j);
                continue block1;
            }
            return false;
        }
        return true;
    }

    public SingleOperation createSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) throws FactoryException {
        AbstractSingleOperation op;
        Class<? extends SingleOperation> c;
        Class baseType;
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        ArgumentChecks.ensureNonNull("method", method);
        if (transform == null) {
            ParameterValueGroup parameters = Containers.property(properties, "parameters", ParameterValueGroup.class);
            if (parameters == null) {
                throw new NullArgumentException(Errors.format((short)113, "transform"));
            }
            transform = ReferencingUtilities.createBaseToDerived(this.getMathTransformFactory(), sourceCRS, parameters, targetCRS);
        }
        if ((baseType = Containers.property(properties, "operationType", Class.class)) == null) {
            baseType = SingleOperation.class;
        }
        if (method instanceof DefaultOperationMethod && (c = ((DefaultOperationMethod)method).getOperationType()) != null) {
            if (baseType.isAssignableFrom(c)) {
                baseType = c;
            } else if (!c.isAssignableFrom(baseType)) {
                throw new IllegalArgumentException(Errors.format((short)63, "operationType"));
            }
        }
        if (baseType == SingleOperation.class) {
            baseType = DefaultCoordinateOperationFactory.isConversion(sourceCRS, targetCRS) ? (interpolationCRS == null && sourceCRS instanceof GeographicCRS && targetCRS instanceof ProjectedCRS ? Projection.class : Conversion.class) : Transformation.class;
        }
        if (Transformation.class.isAssignableFrom(baseType)) {
            op = new DefaultTransformation(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        } else if (Projection.class.isAssignableFrom(baseType)) {
            ArgumentChecks.ensureCanCast("sourceCRS", GeographicCRS.class, sourceCRS);
            ArgumentChecks.ensureCanCast("targetCRS", ProjectedCRS.class, targetCRS);
            if (interpolationCRS != null) {
                throw new IllegalArgumentException(Errors.format((short)40, "interpolationCRS", baseType));
            }
            GeographicCRS baseCRS = (GeographicCRS)sourceCRS;
            ProjectedCRS crs = (ProjectedCRS)targetCRS;
            op = CylindricalProjection.class.isAssignableFrom(baseType) ? new DefaultCylindricalProjection(properties, baseCRS, crs, method, transform) : (ConicProjection.class.isAssignableFrom(baseType) ? new DefaultConicProjection(properties, baseCRS, crs, method, transform) : (PlanarProjection.class.isAssignableFrom(baseType) ? new DefaultPlanarProjection(properties, baseCRS, crs, method, transform) : new DefaultProjection(properties, baseCRS, crs, method, transform)));
        } else {
            op = Conversion.class.isAssignableFrom(baseType) ? new DefaultConversion(properties, sourceCRS, targetCRS, interpolationCRS, method, transform) : new AbstractSingleOperation(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        }
        if (!baseType.isInstance(op)) {
            throw new FactoryException(Resources.format((short)4, baseType, op.getName()));
        }
        return this.pool.unique(op);
    }

    @Override
    public CoordinateOperation createConcatenatedOperation(Map<String, ?> properties, CoordinateOperation ... operations) throws FactoryException {
        DefaultConcatenatedOperation op;
        if (operations != null && operations.length == 1) {
            return operations[0];
        }
        try {
            op = new DefaultConcatenatedOperation(properties, operations, this.getMathTransformFactory());
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        List<SingleOperation> co = op.getOperations();
        if (co.size() != 1) {
            return this.pool.unique(op);
        }
        CoordinateOperation single = co.get(0);
        assert (op.getMathTransform().equals(single.getMathTransform())) : op;
        if (!(Objects.equals(single.getSourceCRS(), op.getSourceCRS()) && Objects.equals(single.getTargetCRS(), op.getTargetCRS()) || !(single instanceof SingleOperation))) {
            HashMap merge = new HashMap(IdentifiedObjects.getProperties(single, "identifiers"));
            merge.put("parameters", ((SingleOperation)single).getParameterValues());
            if (single instanceof AbstractIdentifiedObject) {
                merge.put("operationType", ((AbstractIdentifiedObject)((Object)single)).getInterface());
            }
            merge.putAll(properties);
            return this.createSingleOperation(merge, op.getSourceCRS(), op.getTargetCRS(), AbstractCoordinateOperation.getInterpolationCRS(op), ((SingleOperation)single).getMethod(), single.getMathTransform());
        }
        return single;
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        return this.createOperation(sourceCRS, targetCRS, (CoordinateOperationContext)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperationContext context2) throws OperationNotFoundException, FactoryException {
        Cache.Handler<CoordinateOperation> handler;
        CoordinateOperation op;
        if (context2 == null) {
            CRSPair key = new CRSPair(sourceCRS, targetCRS);
            op = this.cache.peek(key);
            if (op != null) {
                return op;
            }
            handler = this.cache.lock(key);
        } else {
            handler = null;
            op = null;
        }
        try {
            if (handler == null || (op = (CoordinateOperation)handler.peek()) == null) {
                CRSAuthorityFactory registry = CRS.getAuthorityFactory("EPSG");
                op = this.createOperationFinder(registry instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)((Object)registry) : null, context2).createOperation(sourceCRS, targetCRS);
            }
        }
        finally {
            if (handler != null) {
                handler.putAndUnlock(op);
            }
        }
        return op;
    }

    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperationContext context2) throws OperationNotFoundException, FactoryException {
        CRSAuthorityFactory registry = CRS.getAuthorityFactory("EPSG");
        return this.createOperationFinder(registry instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)((Object)registry) : null, context2).createOperations(sourceCRS, targetCRS);
    }

    protected CoordinateOperationFinder createOperationFinder(CoordinateOperationAuthorityFactory registry, CoordinateOperationContext context2) throws FactoryException {
        return new CoordinateOperationFinder(registry, this, context2);
    }

    @Override
    @Deprecated(since="0.7")
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws FactoryException {
        ArgumentChecks.ensureNonNull("method", method);
        return this.createOperation(sourceCRS, targetCRS, (CoordinateOperationContext)null);
    }
}

