/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.switchcase;

import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.knox.gateway.identityasserter.common.filter.CommonIdentityAssertionFilter;
import org.apache.knox.gateway.security.GroupPrincipal;

public class SwitchCaseIdentityAssertionFilter
extends CommonIdentityAssertionFilter {
    private static final String USER_INIT_PARAM = "principal.case";
    private static final String GROUP_INIT_PARAM = "group.principal.case";
    private SwitchCase userCase = SwitchCase.LOWER;
    private SwitchCase groupCase = SwitchCase.LOWER;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String s = filterConfig.getInitParameter(USER_INIT_PARAM);
        if (s != null) {
            s = s.trim().toUpperCase(Locale.ROOT);
            try {
                this.groupCase = this.userCase = SwitchCase.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((s = filterConfig.getInitParameter(GROUP_INIT_PARAM)) != null) {
            s = s.trim().toUpperCase(Locale.ROOT);
            try {
                this.groupCase = SwitchCase.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public String mapUserPrincipal(String principalName) {
        return this.switchCase(principalName, this.userCase);
    }

    public String[] mapGroupPrincipals(String mappedPrincipalName, Subject subject) {
        Set<GroupPrincipal> groups;
        String[] groupNames = null;
        if (this.groupCase != SwitchCase.NONE && (groups = subject.getPrincipals(GroupPrincipal.class)) != null && !groups.isEmpty()) {
            groupNames = new String[groups.size()];
            int i = 0;
            for (GroupPrincipal group : groups) {
                groupNames[i++] = this.switchCase(group.getName(), this.groupCase);
            }
        }
        return groupNames;
    }

    private String switchCase(String name, SwitchCase switchCase) {
        if (name != null) {
            switch (switchCase) {
                case UPPER: {
                    return name.toUpperCase(Locale.ROOT);
                }
                case LOWER: {
                    return name.toLowerCase(Locale.ROOT);
                }
            }
        }
        return name;
    }

    private static enum SwitchCase {
        UPPER,
        LOWER,
        NONE;

    }
}

