/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.transcoders;

public final class TranscoderUtils {
    private final boolean packZeros;

    public TranscoderUtils(boolean pack) {
        this.packZeros = pack;
    }

    public byte[] encodeNum(long l, int maxBytes) {
        byte[] rv = new byte[maxBytes];
        for (int i = 0; i < rv.length; ++i) {
            int pos = rv.length - i - 1;
            rv[pos] = (byte)(l >> 8 * i & 0xFFL);
        }
        if (this.packZeros) {
            int firstNon0;
            for (firstNon0 = 0; firstNon0 < rv.length && rv[firstNon0] == 0; ++firstNon0) {
            }
            if (firstNon0 > 0) {
                byte[] tmp = new byte[rv.length - firstNon0];
                System.arraycopy(rv, firstNon0, tmp, 0, rv.length - firstNon0);
                rv = tmp;
            }
        }
        return rv;
    }

    public byte[] encodeLong(long l) {
        return this.encodeNum(l, 8);
    }

    public long decodeLong(byte[] b) {
        long rv = 0L;
        for (int n : b) {
            rv = rv << 8 | (long)(n < 0 ? 256 + n : n);
        }
        return rv;
    }

    public byte[] encodeInt(int in) {
        return this.encodeNum(in, 4);
    }

    public int decodeInt(byte[] in) {
        assert (in.length <= 4) : "Too long to be an int (" + in.length + ") bytes";
        return (int)this.decodeLong(in);
    }

    public byte[] encodeByte(byte in) {
        return new byte[]{in};
    }

    public byte decodeByte(byte[] in) {
        assert (in.length <= 1) : "Too long for a byte";
        byte rv = 0;
        if (in.length == 1) {
            rv = in[0];
        }
        return rv;
    }

    public byte[] encodeBoolean(boolean b) {
        byte[] rv = new byte[]{(byte)(b ? 49 : 48)};
        return rv;
    }

    public boolean decodeBoolean(byte[] in) {
        assert (in.length == 1) : "Wrong length for a boolean";
        return in[0] == 49;
    }
}

