/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XSDHelper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.CodeWriter;
import org.eclipse.persistence.sdo.helper.SDOClassGenerator;

public class Xsd2JavaSDOModel {
    private List<SDOType> types = null;
    private HelperContext context = null;

    public Xsd2JavaSDOModel(HelperContext context, List<SDOType> types) {
        this.context = context;
        this.types = types;
    }

    public void generateCode(CodeWriter cw) {
        if (this.types == null) {
            return;
        }
        SDOClassGenerator generator = new SDOClassGenerator(this.context);
        generator.generate(cw, this.types);
    }

    public List<String> getClassList() {
        ArrayList<String> list = new ArrayList<String>();
        for (SDOType type : this.types) {
            list.add(type.getInstanceClassName());
        }
        return list;
    }

    public QName getXsdTypeName(String javaClass) {
        for (SDOType type : this.types) {
            if (!type.getInstanceClassName().equals(javaClass)) continue;
            return type.getQName();
        }
        return null;
    }

    public String getJavaTypeForElementName(QName qname) {
        XSDHelper xsdHelper = this.context.getXSDHelper();
        Property globalProperty = xsdHelper.getGlobalProperty(qname.getNamespaceURI(), qname.getLocalPart(), true);
        if (globalProperty == null) {
            throw new RuntimeException("Given element with name: " + qname + "is not found.");
        }
        Type elementType = globalProperty.getType();
        if (elementType == null) {
            throw new RuntimeException("Given element with name: " + qname + "is not found.");
        }
        return ((SDOType)elementType).getInstanceClassName();
    }

    public String getJavaTypeForElementType(QName name) {
        if (this.types != null) {
            for (SDOType type : this.types) {
                QName qname = type.getXsdType();
                if (qname == null || !qname.equals(name)) continue;
                return type.getInstanceClassName();
            }
        }
        return null;
    }
}

