/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import jodd.cache.AbstractCacheMap;

public class TimedCache<K, V>
extends AbstractCacheMap<K, V> {
    protected Timer pruneTimer;

    public TimedCache(long timeout) {
        this.cacheSize = 0;
        this.timeout = timeout;
        this.cacheMap = new HashMap();
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            AbstractCacheMap.CacheObject co = (AbstractCacheMap.CacheObject)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            ++count;
        }
        return count;
    }

    public void schedulePrune(long delay) {
        if (this.pruneTimer != null) {
            this.pruneTimer.cancel();
        }
        this.pruneTimer = new Timer();
        this.pruneTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                TimedCache.this.prune();
            }
        }, delay, delay);
    }

    public void cancelPruneSchedule() {
        if (this.pruneTimer != null) {
            this.pruneTimer.cancel();
            this.pruneTimer = null;
        }
    }
}

