/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.debug;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

public class BackdoorToggles {
    private static final ThreadLocal<Map<String, String>> _backdoorToggles = new ThreadLocal();
    public static final String DEBUG_TOGGLE_DISABLE_FUZZY_KEY = "DEBUG_TOGGLE_DISABLE_FUZZY_KEY";
    public static final String DEBUG_TOGGLE_DISABLE_QUERY_CACHE = "DEBUG_TOGGLE_DISABLE_QUERY_CACHE";
    public static final String DEBUG_TOGGLE_QUERY_TIMEOUT = "DEBUG_TOGGLE_QUERY_TIMEOUT";
    public static final String DEBUG_TOGGLE_SHARD_ASSIGNMENT = "DEBUG_TOGGLE_SHARD_ASSIGNMENT";
    public static final String DEBUG_TOGGLE_PARTITION_DUMP_DIR = "DEBUG_TOGGLE_PARTITION_DUMP_DIR";
    public static final String DEBUG_TOGGLE_DUMPED_PARTITION_DIR = "DEBUG_TOGGLE_DUMPED_PARTITION_DIR";
    public static final String DEBUG_TOGGLE_PREPARE_ONLY = "DEBUG_TOGGLE_PREPARE_ONLY";
    public static final String ATTR_STATEMENT_MAX_ROWS = "ATTR_STATEMENT_MAX_ROWS";
    public static final String DEBUG_TOGGLE_CHECK_ALL_MODELS = "DEBUG_TOGGLE_CHECK_ALL_MODELS";
    public static final String DISABLE_RAW_QUERY_HACKER = "DISABLE_RAW_QUERY_HACKER";
    public static final String QUERY_NON_EQUI_JOIN_MODEL_ENABLED = "QUERY_NON_EQUI_JOIN_MODEL_ENABLED";
    public static final String CONNECTION_CREATING_TIME = "CONNECTION_CREATING_TIME";
    public static final String STATEMENT_TO_REQUEST_TIME = "STATEMENT_TO_REQUEST_TIME";

    public static void setToggles(Map<String, String> toggles) {
        _backdoorToggles.set(toggles);
    }

    public static void addToggle(String key, String value) {
        Map<String, String> map = _backdoorToggles.get();
        if (map == null) {
            BackdoorToggles.setToggles(Maps.newHashMap());
        }
        _backdoorToggles.get().put(key, value);
    }

    public static void addToggles(Map<String, String> toggles) {
        Map<String, String> map = _backdoorToggles.get();
        if (map == null) {
            BackdoorToggles.setToggles(Maps.newHashMap());
        }
        _backdoorToggles.get().putAll(toggles);
    }

    public static String getToggle(String key) {
        Map<String, String> map = _backdoorToggles.get();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static boolean getDisableCache() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_QUERY_CACHE);
    }

    public static boolean getDisableFuzzyKey() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_FUZZY_KEY);
    }

    public static String getPartitionDumpDir() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_PARTITION_DUMP_DIR);
    }

    public static String getDumpedPartitionDir() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_DUMPED_PARTITION_DIR);
    }

    public static boolean getCheckAllModels() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_CHECK_ALL_MODELS);
    }

    public static boolean getDisabledRawQueryLastHacker() {
        return BackdoorToggles.getBoolean(DISABLE_RAW_QUERY_HACKER);
    }

    public static int getQueryTimeout() {
        String v = BackdoorToggles.getString(DEBUG_TOGGLE_QUERY_TIMEOUT);
        if (v == null) {
            return -1;
        }
        return Integer.parseInt(v);
    }

    public static Pair<Short, Short> getShardAssignment() {
        String v = BackdoorToggles.getString(DEBUG_TOGGLE_SHARD_ASSIGNMENT);
        if (v == null) {
            return null;
        }
        String[] parts = StringUtils.split((String)v, (String)"#");
        return Pair.newPair(Short.parseShort(parts[0]), Short.parseShort(parts[1]));
    }

    public static Integer getStatementMaxRows() {
        String v = BackdoorToggles.getString(ATTR_STATEMENT_MAX_ROWS);
        return v == null ? null : Integer.valueOf(Integer.parseInt(v));
    }

    public static Long getConnectionCreatingTime() {
        String v = BackdoorToggles.getString(CONNECTION_CREATING_TIME);
        return v == null ? null : Long.valueOf(Long.parseLong(v));
    }

    public static Long getStatementToRequestTime() {
        String v = BackdoorToggles.getString(STATEMENT_TO_REQUEST_TIME);
        return v == null ? null : Long.valueOf(Long.parseLong(v));
    }

    public static boolean getPrepareOnly() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_PREPARE_ONLY);
    }

    private static String getString(String key) {
        Map<String, String> toggles = _backdoorToggles.get();
        if (toggles == null) {
            return null;
        }
        return toggles.get(key);
    }

    private static boolean getBoolean(String key) {
        return "true".equals(BackdoorToggles.getString(key));
    }

    public static void cleanToggles() {
        _backdoorToggles.remove();
    }
}

