/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;

public final class RandomUtil {
    private static final SecureRandom random = new SecureRandom();

    public static UUID randomUUID() {
        return new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
    }

    public static String randomUUIDStr() {
        return RandomUtil.randomUUID().toString();
    }

    public static String randomUUIDStrWithUnderline() {
        return RandomUtil.randomUUIDStr().replace("-", "_");
    }

    public static int nextInt(int startInclusive, int endExclusive) {
        Preconditions.checkArgument((endExclusive >= startInclusive ? 1 : 0) != 0, (Object)"Start value must be smaller or equal to end value.");
        Preconditions.checkArgument((startInclusive >= 0 ? 1 : 0) != 0, (Object)"Both range values must be non-negative.");
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + random.nextInt(endExclusive - startInclusive);
    }

    public static int nextInt(int endExclusive) {
        return RandomUtil.nextInt(0, endExclusive);
    }

    @Generated
    private RandomUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

