/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.bisync;

import java.util.List;
import java.util.Set;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.tool.bisync.BISyncModel;
import org.apache.kylin.tool.bisync.SyncContext;
import org.apache.kylin.tool.bisync.SyncModelBuilder;
import org.apache.kylin.tool.bisync.model.SyncModel;
import org.apache.kylin.tool.bisync.tableau.TableauDataSourceConverter;

public class BISyncTool {
    private BISyncTool() {
    }

    @VisibleForTesting
    public static BISyncModel dumpToBISyncModel(SyncContext syncContext) {
        SyncModel syncModel = new SyncModelBuilder(syncContext).buildSourceSyncModel((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
        return BISyncTool.getBISyncModel(syncContext, syncModel);
    }

    public static BISyncModel getBISyncModel(SyncContext syncContext, SyncModel syncModel) {
        switch (syncContext.getTargetBI()) {
            case TABLEAU_ODBC_TDS: 
            case TABLEAU_CONNECTOR_TDS: {
                return new TableauDataSourceConverter().convert(syncModel, syncContext);
            }
        }
        throw new IllegalArgumentException();
    }

    @VisibleForTesting
    public static BISyncModel dumpHasPermissionToBISyncModel(SyncContext syncContext, Set<String> authTables, Set<String> authColumns, List<String> dimensions, List<String> measures) {
        SyncModel syncModel = new SyncModelBuilder(syncContext).buildHasPermissionSourceSyncModel(authTables, authColumns, dimensions, measures);
        return BISyncTool.getBISyncModel(syncContext, syncModel);
    }

    @VisibleForTesting
    public static BISyncModel dumpBISyncModel(SyncContext syncContext, List<String> dimensions, List<String> measures) {
        SyncModel syncModel = new SyncModelBuilder(syncContext).buildSourceSyncModel(dimensions, measures);
        return BISyncTool.getBISyncModel(syncContext, syncModel);
    }
}

