/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.NullCollation;
import org.apache.kylin.common.KylinConfig;

public class KylinConnectionConfig
extends CalciteConnectionConfigImpl {
    static final ThreadLocal<KylinConnectionConfig> THREAD_LOCAL = new ThreadLocal();
    private final KylinConfig kylinConfig;

    private KylinConnectionConfig(Properties properties, KylinConfig kylinConfig) {
        super(properties);
        this.kylinConfig = kylinConfig;
    }

    public static KylinConnectionConfig fromKapConfig(KylinConfig kylinConfig) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)kylinConfig.getCalciteExtrasProperties());
        return new KylinConnectionConfig(props, kylinConfig);
    }

    public static KylinConnectionConfig current() {
        return THREAD_LOCAL.get();
    }

    public NullCollation defaultNullCollation() {
        String nullCollation = (String)this.kylinConfig.getCalciteExtrasProperties().get("defaultNullCollation");
        if (null == nullCollation) {
            return NullCollation.LOW;
        }
        switch (nullCollation.toLowerCase(Locale.ROOT)) {
            case "low": {
                return NullCollation.LOW;
            }
            case "high": {
                return NullCollation.HIGH;
            }
            case "first": {
                return NullCollation.FIRST;
            }
            case "last": {
                return NullCollation.LAST;
            }
        }
        throw new UnsupportedOperationException("unsupported null collation type: " + nullCollation);
    }

    public boolean caseSensitive() {
        return false;
    }

    public Casing unquotedCasing() {
        return this.kylinConfig.getSourceNameCaseSensitiveEnabled() ? Casing.UNCHANGED : super.unquotedCasing();
    }

    public boolean exposeComputedColumn() {
        return this.kylinConfig.exposeComputedColumn();
    }

    public int getIdentifierMaxLength() {
        return this.kylinConfig.getMaxModelDimensionMeasureNameLength();
    }

    public String[] operatorTables() {
        return CalciteConnectionProperty.FUN.wrap(this.properties).getString("standard").toLowerCase(Locale.ROOT).split(",");
    }

    @Generated
    public KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }
}

