/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfExtractor {
    private static final Logger logger = LoggerFactory.getLogger(HadoopConfExtractor.class);
    public static final Pattern URL_PATTERN = Pattern.compile("(http[s]?://)([^:]*):([^/]*).*");

    private HadoopConfExtractor() {
    }

    public static String extractYarnMasterUrl(Configuration conf) {
        String rmWebHost;
        String defaultAddr;
        String webappConfKey;
        Matcher m;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String yarnStatusCheckUrl = config.getYarnStatusCheckUrl();
        if (yarnStatusCheckUrl != null && (m = URL_PATTERN.matcher(yarnStatusCheckUrl)).matches()) {
            return m.group(1) + m.group(2) + ":" + m.group(3);
        }
        logger.info("kylin.job.yarn-app-rest-check-status-url is not set, read from hadoop configuration");
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            webappConfKey = "yarn.resourcemanager.webapp.https.address";
            defaultAddr = "0.0.0.0:8090";
        } else {
            webappConfKey = "yarn.resourcemanager.webapp.address";
            defaultAddr = "0.0.0.0:8088";
        }
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String active;
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            try {
                active = RMHAUtils.findActiveRMHAId((YarnConfiguration)yarnConf);
            }
            catch (NoSuchMethodError e) {
                logger.warn("Original findActiveRMHAId(YarnConfiguration) may not exists, try MRS modified method");
                active = HadoopConfExtractor.tryInvokeMRSFindActiveRMHAId(conf);
            }
            rmWebHost = HAUtil.getConfValueForRMInstance((String)HAUtil.addSuffix((String)webappConfKey, (String)active), (String)defaultAddr, (Configuration)yarnConf);
        } else {
            rmWebHost = HAUtil.getConfValueForRMInstance((String)webappConfKey, (String)defaultAddr, (Configuration)conf);
        }
        if (StringUtils.isEmpty((CharSequence)rmWebHost)) {
            return null;
        }
        if (!rmWebHost.startsWith("http://") && !rmWebHost.startsWith("https://")) {
            rmWebHost = (YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://") + rmWebHost;
        }
        Matcher m2 = URL_PATTERN.matcher(rmWebHost);
        Preconditions.checkArgument((boolean)m2.matches(), (Object)"Yarn master URL not found.");
        logger.info("yarn master url: {} ", (Object)rmWebHost);
        return rmWebHost;
    }

    private static String tryInvokeMRSFindActiveRMHAId(Configuration conf) {
        try {
            Method method = RMHAUtils.class.getMethod("findActiveRMHAId", Configuration.class);
            return (String)method.invoke(null, conf);
        }
        catch (Exception e) {
            throw new KylinRuntimeException((Throwable)e);
        }
    }
}

