/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.ref.CCRef;
import org.apache.kylin.metadata.recommendation.ref.DimensionRef;
import org.apache.kylin.metadata.recommendation.ref.LayoutRef;
import org.apache.kylin.metadata.recommendation.ref.MeasureRef;
import org.apache.kylin.metadata.recommendation.ref.ModelColumnRef;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.metadata.recommendation.ref.RecommendationRef;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.apache.kylin.rest.model.FuzzyKeySearcher;
import org.apache.kylin.rest.request.OptRecRequest;
import org.apache.kylin.rest.response.OptRecDepResponse;
import org.apache.kylin.rest.response.OptRecDetailResponse;
import org.apache.kylin.rest.response.OptRecLayoutResponse;
import org.apache.kylin.rest.response.OptRecLayoutsResponse;
import org.apache.kylin.rest.service.AbstractModelService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.util.PagingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.stereotype.Component;

@EnableDiscoveryClient
@Component(value="optRecService")
public class OptRecService
extends AbstractModelService {
    private static final Logger log = LoggerFactory.getLogger((String)"smart");
    public static final int V2 = 2;
    public static final String RECOMMENDATION_SOURCE = "recommendation_source";
    public static final String OPERATION_ERROR_MSG = "The operation types of recommendation includes: add_index, removal_index and all(by default)";
    public static final String ALL = RecActionType.ALL.name();
    @Autowired
    private ModelService modelService;

    public void discard(String project, OptRecRequest request) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)project).loadOptRecV2(request.getModelId());
        RawRecManager rawManager = RawRecManager.getInstance((String)project);
        HashSet allToHandle = Sets.newHashSet();
        allToHandle.addAll(request.getRecItemsToAddLayout());
        allToHandle.addAll(request.getRecItemsToRemoveLayout());
        rawManager.discardByIds(ListUtils.intersection((List)optRecV2.getRawIds(), (List)Lists.newArrayList((Iterable)allToHandle)));
        this.updateRecommendationCount(project, request.getModelId());
    }

    public void clean(String project, String modelId) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        OptRecManagerV2 managerV2 = OptRecManagerV2.getInstance((String)project);
        managerV2.discardAll(modelId);
        this.updateRecommendationCount(project, modelId);
    }

    private static OptRecDepResponse convert(RecommendationRef ref, Long recCardinality) {
        OptRecDepResponse response = OptRecService.convert(ref);
        response.setCardinality(recCardinality);
        return response;
    }

    private static OptRecDepResponse convert(RecommendationRef ref) {
        OptRecDepResponse response = new OptRecDepResponse();
        response.setVersion(2);
        response.setContent(ref.getContent());
        response.setName(ref.getName());
        response.setAdd(!ref.isExisted());
        response.setCrossModel(ref.isCrossModel());
        response.setItemId(ref.getId());
        return response;
    }

    public static Long getRecCardinality(RecommendationRef ref, NDataModel model, Map<TableRef, TableExtDesc> columnCardinalities) {
        if (ref instanceof DimensionRef) {
            Object entity = ref.getEntity();
            if (entity instanceof NDataModel.NamedColumn) {
                return OptRecService.getCardinality(ref, model, columnCardinalities);
            }
            if (entity instanceof ModelColumnRef) {
                ModelColumnRef columnRef = (ModelColumnRef)ref.getEntity();
                return OptRecService.getCardinality((RecommendationRef)columnRef, model, columnCardinalities);
            }
        }
        return null;
    }

    private static Long getCardinality(RecommendationRef ref, NDataModel model, Map<TableRef, TableExtDesc> columnCardinalities) {
        Object entity = ref.getEntity();
        if (entity instanceof NDataModel.NamedColumn) {
            NDataModel.NamedColumn namedColumn = (NDataModel.NamedColumn)entity;
            int columnId = model.getColumnIdByColumnName(namedColumn.getAliasDotColumn());
            TblColRef tblColRef = (TblColRef)model.getEffectiveCols().getOrDefault((Object)columnId, null);
            TableRef table = Objects.isNull(tblColRef) ? null : tblColRef.getTableRef();
            TableExtDesc tableExt = columnCardinalities.get(table);
            TableExtDesc.ColumnStats columnStats = Objects.isNull(tableExt) ? null : tableExt.getColumnStatsByName(namedColumn.getName());
            return Objects.isNull(columnStats) ? null : Long.valueOf(columnStats.getCardinality());
        }
        return null;
    }

    public OptRecDetailResponse validateSelectedRecItems(String project, String modelId, List<Integer> recListOfAddLayouts, List<Integer> recListOfRemoveLayouts) {
        this.aclEvaluate.checkProjectReadPermission(project);
        OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
        OptRecDetailResponse detailResponse = new OptRecDetailResponse();
        List<Integer> layoutRecsToAdd = this.validate(recListOfAddLayouts, optRecV2, detailResponse, true);
        List<Integer> layoutRecsToRemove = this.validate(recListOfRemoveLayouts, optRecV2, detailResponse, false);
        detailResponse.setRecItemsToAddLayout(layoutRecsToAdd);
        detailResponse.setRecItemsToRemoveLayout(layoutRecsToRemove);
        return detailResponse;
    }

    public Map<TableRef, TableExtDesc> getModelTables(NDataModel model) {
        Set tables = model.getAllTables();
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, model.getProject());
        HashMap modelTables = Maps.newHashMap();
        for (TableRef table : tables) {
            TableDesc tableDesc = table.getTableDesc();
            TableExtDesc tableExt = tableMetadataManager.getTableExtIfExists(tableDesc);
            modelTables.put(table, tableExt);
        }
        return modelTables;
    }

    private List<Integer> validate(List<Integer> layoutRecList, OptRecV2 optRecV2, OptRecDetailResponse detailResponse, boolean isAdd) {
        ArrayList healthyList = Lists.newArrayList();
        HashSet dimensionRefResponse = Sets.newHashSet();
        HashSet measureRefResponse = Sets.newHashSet();
        HashSet ccRefResponse = Sets.newHashSet();
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, optRecV2.getProject());
        NDataModel model = modelManager.getDataModelDesc(optRecV2.getUuid());
        Map<TableRef, TableExtDesc> modelTables = this.getModelTables(model);
        layoutRecList.forEach(recItemId -> {
            LayoutRef layoutRef = OptRecService.checkRecItemIsValidAndReturn(optRecV2, recItemId, isAdd);
            layoutRef.getDependencies().forEach(ref -> {
                if (ref instanceof DimensionRef) {
                    Long recCardinality = OptRecService.getRecCardinality(ref, model, modelTables);
                    OptRecDepResponse optRecDepResponse = OptRecService.convert(ref, recCardinality);
                    dimensionRefResponse.add(optRecDepResponse);
                }
                if (ref instanceof MeasureRef) {
                    measureRefResponse.add(OptRecService.convert(ref));
                }
                for (RecommendationRef innerRef : ref.getDependencies()) {
                    if (!(innerRef instanceof CCRef)) continue;
                    ccRefResponse.add(OptRecService.convert(innerRef));
                }
            });
            healthyList.add(recItemId);
        });
        detailResponse.getDimensionItems().addAll(dimensionRefResponse);
        detailResponse.getMeasureItems().addAll(measureRefResponse);
        detailResponse.getCcItems().addAll(ccRefResponse);
        return healthyList;
    }

    public OptRecDetailResponse getSingleOptRecDetail(String project, String modelId, int recItemId, boolean isAdd) {
        this.aclEvaluate.checkProjectReadPermission(project);
        OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
        OptRecDetailResponse detailResponse = new OptRecDetailResponse();
        List<Integer> validList = this.validate(Lists.newArrayList((Object[])new Integer[]{recItemId}), optRecV2, detailResponse, isAdd);
        if (isAdd) {
            detailResponse.getRecItemsToAddLayout().addAll(validList);
        } else {
            detailResponse.getRecItemsToRemoveLayout().addAll(validList);
        }
        return detailResponse;
    }

    public static LayoutRef checkRecItemIsValidAndReturn(OptRecV2 optRecV2, int recItemId, boolean isAdd) {
        HashSet allRecItemIds = Sets.newHashSet((Iterable)optRecV2.getRawIds());
        Set brokenRefIds = optRecV2.getBrokenRefIds();
        if (!allRecItemIds.contains(recItemId) || brokenRefIds.contains(recItemId)) {
            try (SetLogCategory ignored = new SetLogCategory("smart");){
                log.info("all recommendation ids {}, broken ref ids {}", (Object)allRecItemIds, (Object)brokenRefIds);
            }
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.REC_LIST_OUT_OF_DATE, MsgPicker.getMsg().getRecListOutOfDate());
        }
        Map layoutRefs = isAdd ? optRecV2.getAdditionalLayoutRefs() : optRecV2.getRemovalLayoutRefs();
        LayoutRef layoutRef = (LayoutRef)layoutRefs.get(-recItemId);
        if (layoutRef == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.REC_LIST_OUT_OF_DATE, MsgPicker.getMsg().getRecListOutOfDate());
        }
        return layoutRef;
    }

    public OptRecLayoutsResponse getOptRecLayoutsResponse(String project, String modelId, List<String> recTypeList, String key, boolean desc, String orderBy, int offset, int limit) {
        this.aclEvaluate.checkProjectReadPermission(project);
        HashSet userDefinedTypes = Sets.newHashSet();
        recTypeList.forEach(type -> {
            if (RawRecItem.IndexRecType.ADD_TABLE_INDEX.name().equalsIgnoreCase((String)type)) {
                userDefinedTypes.add(RawRecItem.IndexRecType.ADD_TABLE_INDEX);
            } else if (RawRecItem.IndexRecType.ADD_AGG_INDEX.name().equalsIgnoreCase((String)type)) {
                userDefinedTypes.add(RawRecItem.IndexRecType.ADD_AGG_INDEX);
            } else if (RawRecItem.IndexRecType.REMOVE_AGG_INDEX.name().equalsIgnoreCase((String)type)) {
                userDefinedTypes.add(RawRecItem.IndexRecType.REMOVE_AGG_INDEX);
            } else {
                userDefinedTypes.add(RawRecItem.IndexRecType.REMOVE_TABLE_INDEX);
            }
        });
        HashSet brokenRecs = Sets.newHashSet();
        List<OptRecLayoutResponse> recList = this.getRecLayoutResponses(project, modelId, key, ALL, brokenRecs);
        if (userDefinedTypes.size() != RawRecItem.IndexRecType.values().length) {
            recList.removeIf(resp -> !userDefinedTypes.isEmpty() && !userDefinedTypes.contains(resp.getType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            recList.sort(BasicService.propertyComparator((String)orderBy, (!desc ? 1 : 0) != 0));
        }
        OptRecLayoutsResponse response = new OptRecLayoutsResponse();
        response.setLayouts(PagingUtil.cutPage(recList, (int)offset, (int)limit));
        response.setSize(recList.size());
        response.setBrokenRecs(brokenRecs);
        return response;
    }

    public OptRecLayoutsResponse getOptRecLayoutsResponse(String project, String modelId, String recActionType) {
        return this.getOptRecLayoutsResponseInner(project, modelId, recActionType);
    }

    public OptRecLayoutsResponse getOptRecLayoutsResponseInner(String project, String modelId, String recActionType) {
        OptRecLayoutsResponse layoutsResponse = new OptRecLayoutsResponse();
        List<OptRecLayoutResponse> responses = this.getRecLayoutResponses(project, modelId, null, recActionType, layoutsResponse.getBrokenRecs());
        layoutsResponse.getLayouts().addAll(responses);
        layoutsResponse.setSize(layoutsResponse.getLayouts().size());
        return layoutsResponse;
    }

    public List<RawRecItem> getRecLayout(OptRecV2 optRecV2, RecActionType recActionType) {
        if (optRecV2 == null) {
            return Collections.emptyList();
        }
        HashMap<Integer, LayoutRef> layoutRefMap = new HashMap<Integer, LayoutRef>();
        switch (recActionType) {
            case ALL: {
                layoutRefMap.putAll(optRecV2.getAdditionalLayoutRefs());
                layoutRefMap.putAll(optRecV2.getRemovalLayoutRefs());
                break;
            }
            case ADD_INDEX: {
                layoutRefMap.putAll(optRecV2.getAdditionalLayoutRefs());
                break;
            }
            case REMOVE_INDEX: {
                layoutRefMap.putAll(optRecV2.getRemovalLayoutRefs());
                break;
            }
        }
        ArrayList result = Lists.newArrayList();
        layoutRefMap.forEach((recId, layoutRef) -> {
            if (layoutRef.isBroken() || layoutRef.isExcluded() || layoutRef.isExisted() || recId >= 0) {
                return;
            }
            result.add(optRecV2.getRawRecItemMap().get(-recId.intValue()));
        });
        return result;
    }

    private List<OptRecLayoutResponse> getRecLayoutResponses(String project, String modelId, String key, String recActionType, Set<Integer> brokenRecCollector) {
        ArrayList rawRecItems = Lists.newArrayList();
        OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
        if (recActionType.equalsIgnoreCase(RecActionType.ALL.name())) {
            rawRecItems.addAll(this.getRecLayout(optRecV2, RecActionType.ALL));
        } else if (recActionType.equalsIgnoreCase(RecActionType.ADD_INDEX.name())) {
            rawRecItems.addAll(this.getRecLayout(optRecV2, RecActionType.ADD_INDEX));
        } else if (recActionType.equalsIgnoreCase(RecActionType.REMOVE_INDEX.name())) {
            rawRecItems.addAll(this.getRecLayout(optRecV2, RecActionType.REMOVE_INDEX));
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_REC_OPERATION_TYPE, OPERATION_ERROR_MSG);
        }
        brokenRecCollector.addAll(optRecV2.getBrokenRefIds());
        ArrayList filterRecItems = Lists.newArrayList();
        if (!StringUtils.isBlank((CharSequence)key)) {
            List<RawRecItem> handle = OptRecService.filterRecItems(key, rawRecItems, optRecV2);
            filterRecItems.addAll(handle);
        } else {
            filterRecItems.addAll(rawRecItems);
        }
        return this.convertToV2RecResponse(project, modelId, filterRecItems, optRecV2);
    }

    private static List<RawRecItem> filterRecItems(String key, List<RawRecItem> rawRecItems, OptRecV2 optRecV2) {
        ArrayList filterRecItems = Lists.newArrayList();
        Set ccFullNames = FuzzyKeySearcher.searchComputedColumns((NDataModel)optRecV2.getModel(), (String)key);
        Set columnRefs = FuzzyKeySearcher.searchColumnRefs((OptRecV2)optRecV2, (Set)ccFullNames, (String)key);
        Set ccRefIds = FuzzyKeySearcher.searchCCRecRefs((OptRecV2)optRecV2, (String)key);
        HashSet dependRefs = Sets.newHashSet((Iterable)ccRefIds);
        dependRefs.addAll(columnRefs);
        Set relatedRecIds = FuzzyKeySearcher.searchDependRefIds((OptRecV2)optRecV2, (Set)dependRefs, (String)key);
        rawRecItems.forEach(recItem -> {
            long id;
            if (recItem.isRemoveLayoutRec() && String.valueOf(id = RawRecUtil.getLayout((RawRecItem)recItem).getId()).equalsIgnoreCase(key.trim())) {
                filterRecItems.add(recItem);
                return;
            }
            for (int dependID : recItem.getDependIDs()) {
                if (!relatedRecIds.contains(dependID)) continue;
                filterRecItems.add(recItem);
                return;
            }
        });
        return filterRecItems;
    }

    private List<OptRecLayoutResponse> convertToV2RecResponse(String project, String modelId, List<RawRecItem> recItems, OptRecV2 optRecV2) {
        ArrayList layoutRecResponseList = Lists.newArrayList();
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow dataflow = dfManager.getDataflow(modelId);
        recItems.forEach(rawRecItem -> {
            boolean isAdd = rawRecItem.getType() == RawRecItem.RawRecType.ADDITIONAL_LAYOUT;
            OptRecLayoutResponse response = new OptRecLayoutResponse();
            response.setId(rawRecItem.getId());
            response.setAdd(isAdd);
            response.setAgg(rawRecItem.isAgg());
            response.setDataSize(-1L);
            response.setUsage(rawRecItem.getHitCount());
            response.setType(rawRecItem.getLayoutRecType());
            response.setCreateTime(rawRecItem.getCreateTime());
            response.setLastModified(rawRecItem.getUpdateTime());
            HashMap memoInfo = Maps.newHashMap();
            memoInfo.put(RECOMMENDATION_SOURCE, rawRecItem.getRecSource());
            response.setMemoInfo(memoInfo);
            if (!isAdd) {
                long layoutId = RawRecUtil.getLayout((RawRecItem)rawRecItem).getId();
                response.setIndexId(layoutId);
                response.setDataSize(dataflow.getByteSize(layoutId));
            }
            OptRecDetailResponse detailResponse = new OptRecDetailResponse();
            List<Integer> validList = this.validate(Lists.newArrayList((Object[])new Integer[]{rawRecItem.getId()}), optRecV2, detailResponse, isAdd);
            if (isAdd) {
                detailResponse.getRecItemsToAddLayout().addAll(validList);
            } else {
                detailResponse.getRecItemsToRemoveLayout().addAll(validList);
            }
            response.setRecDetailResponse(detailResponse);
            layoutRecResponseList.add(response);
        });
        return layoutRecResponseList;
    }

    public void updateRecommendationCount(String project, Set<String> modelList) {
        if (CollectionUtils.isEmpty(modelList)) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            modelList.forEach(modelId -> this.updateRecommendationCount(project, (String)modelId));
            return null;
        }, (String)project);
    }

    public void updateRecommendationCount(String project, String modelId) {
        int size = this.getOptRecLayoutsResponseInner(project, modelId, ALL).getSize();
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.modelService.updateRecommendationsCount(project, modelId, size);
            return null;
        }, (String)project);
    }

    public static enum RecActionType {
        ALL,
        ADD_INDEX,
        REMOVE_INDEX;

    }
}

