/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.Collection;
import java.util.Map;
import org.apache.kylin.rest.service.LdapUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;

public class LdapCaseIgnoreUserDetailsContextMapper
extends LdapUserDetailsMapper {
    private static final Logger logger = LoggerFactory.getLogger(LdapCaseIgnoreUserDetailsContextMapper.class);
    @Autowired
    @Qualifier(value="userService")
    private LdapUserService ldapUserService;

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        String dn = ctx.getNameInNamespace();
        logger.debug("Mapping user details from context with DN {}", (Object)dn);
        Map<String, String> dnMap = this.ldapUserService.getDnMapperMap();
        String realName = dnMap.get(dn);
        logger.debug("ldap real name is {}", (Object)realName);
        return super.mapUserFromContext(ctx, realName, authorities);
    }
}

