/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.storedproc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class ProcedureParameter {
    private String name;
    private Object value;
    private String expression;

    public ProcedureParameter(String name, Object value, String expression) {
        Assert.hasText((String)name, (String)"'name' must not be empty.");
        this.name = name;
        this.value = value;
        this.expression = expression;
    }

    public ProcedureParameter() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String toString() {
        return "ProcedureParameter [name=" + this.name + ", value=" + this.value + ", expression=" + this.expression + "]";
    }

    public static Map<String, String> convertExpressions(Collection<ProcedureParameter> procedureParameters) {
        Assert.notNull(procedureParameters, (String)"The Collection of procedureParameters must not be null.");
        for (ProcedureParameter parameter : procedureParameters) {
            Assert.notNull((Object)parameter, (String)"'procedureParameters' must not contain null values.");
        }
        HashMap<String, String> staticParameters = new HashMap<String, String>();
        for (ProcedureParameter parameter : procedureParameters) {
            if (parameter.getExpression() == null) continue;
            staticParameters.put(parameter.getName(), parameter.getExpression());
        }
        return staticParameters;
    }

    public static Map<String, Object> convertStaticParameters(Collection<ProcedureParameter> procedureParameters) {
        Assert.notNull(procedureParameters, (String)"The Collection of procedureParameters must not be null.");
        for (ProcedureParameter parameter : procedureParameters) {
            Assert.notNull((Object)parameter, (String)"'procedureParameters' must not contain null values.");
        }
        HashMap<String, Object> staticParameters = new HashMap<String, Object>();
        for (ProcedureParameter parameter : procedureParameters) {
            if (parameter.getValue() == null) continue;
            staticParameters.put(parameter.getName(), parameter.getValue());
        }
        return staticParameters;
    }
}

