/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreaker;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.util.Assert;

public class ReactiveResilience4JCircuitBreakerFactory
extends ReactiveCircuitBreakerFactory<Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration, Resilience4JConfigBuilder> {
    private Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration;
    private CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    private TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
    private Map<String, Customizer<CircuitBreaker>> circuitBreakerCustomizers = new HashMap<String, Customizer<CircuitBreaker>>();

    @Deprecated
    public ReactiveResilience4JCircuitBreakerFactory() {
        this.defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig(CircuitBreakerConfig.ofDefaults()).timeLimiterConfig(TimeLimiterConfig.ofDefaults()).build();
    }

    public ReactiveResilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig((CircuitBreakerConfig)this.circuitBreakerRegistry.getDefaultConfig()).timeLimiterConfig((TimeLimiterConfig)this.timeLimiterRegistry.getDefaultConfig()).build();
    }

    public ReactiveCircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        return new ReactiveResilience4JCircuitBreaker(id, config, this.circuitBreakerRegistry, this.timeLimiterRegistry, Optional.ofNullable(this.circuitBreakerCustomizers.get(id)));
    }

    protected Resilience4JConfigBuilder configBuilder(String id) {
        return new Resilience4JConfigBuilder(id);
    }

    public CircuitBreakerRegistry getCircuitBreakerRegistry() {
        return this.circuitBreakerRegistry;
    }

    public TimeLimiterRegistry getTimeLimiterRegistry() {
        return this.timeLimiterRegistry;
    }

    public void configureDefault(Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configureCircuitBreakerRegistry(CircuitBreakerRegistry registry) {
        this.circuitBreakerRegistry = registry;
    }

    public void addCircuitBreakerCustomizer(Customizer<CircuitBreaker> customizer, String ... ids) {
        for (String id : ids) {
            this.circuitBreakerCustomizers.put(id, customizer);
        }
    }
}

