/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.acl.DependentColumn;
import org.apache.kylin.metadata.acl.SensitiveDataMask;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AclTCR
extends RootPersistentEntity {
    private String resourceName;
    private boolean principal;
    @JsonProperty
    private Table table = null;

    public void init(String resourceName, String project, boolean principal) {
        this.resourceName = resourceName;
        this.project = project;
        this.principal = principal;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public static String generateResourceName(String project, String sid, boolean principal) {
        return project + "." + (principal ? "u" : "g") + "." + sid;
    }

    public MetadataType resourceType() {
        return MetadataType.ACL;
    }

    public boolean isPrincipal() {
        return this.principal;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isAuthorized(String dbTblName) {
        if (Objects.isNull(this.table)) {
            return true;
        }
        return this.table.containsKey(dbTblName);
    }

    public boolean isAuthorized(String dbTblName, String columnName) {
        if (Objects.isNull(this.table)) {
            return true;
        }
        if (!this.table.containsKey(dbTblName)) {
            return false;
        }
        if (Objects.isNull(this.table.get(dbTblName)) || Objects.isNull(((ColumnRow)this.table.get(dbTblName)).getColumn())) {
            return true;
        }
        return ((ColumnRow)this.table.get(dbTblName)).getColumn().contains(columnName);
    }

    public boolean isColumnAuthorized(String columnIdentity) {
        int sepIdx = columnIdentity.lastIndexOf(46);
        return this.isAuthorized(columnIdentity.substring(0, sepIdx), columnIdentity.substring(sepIdx + 1));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AclTCR)) {
            return false;
        }
        AclTCR other = (AclTCR)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$resourceName = this.resourceName;
        String other$resourceName = other.resourceName;
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        if (this.isPrincipal() != other.isPrincipal()) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AclTCR;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceName = this.resourceName;
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        result = result * 59 + (this.isPrincipal() ? 79 : 97);
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        return result;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ColumnRealRows {
        @JsonProperty
        private String dbTblColName = null;
        @JsonProperty
        private RealRow realRow = null;
        @JsonProperty
        private RealRow realLikeRow = null;

        public ColumnRealRows() {
        }

        public ColumnRealRows(String dbTblColName, RealRow realRow, RealRow realLikeRow) {
            this.dbTblColName = dbTblColName;
            this.realRow = realRow;
            this.realLikeRow = realLikeRow;
        }

        public RealRow getRealRow() {
            return this.realRow;
        }

        public RealRow getRealLikeRow() {
            return this.realLikeRow;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class RealRow
    extends TreeSet<String> {
        public RealRow() {
            super(String.CASE_INSENSITIVE_ORDER);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Row
    extends TreeMap<String, RealRow> {
        public Row() {
            super(String.CASE_INSENSITIVE_ORDER);
        }
    }

    public static enum OperatorType {
        AND,
        OR;

        private static final Set<String> validValues;

        private static void validateValue(String value) {
            if (!validValues.contains(value.toUpperCase(Locale.ROOT))) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"type", "AND or OR"});
            }
        }

        public static OperatorType stringToEnum(String value) {
            value = value.toUpperCase(Locale.ROOT);
            OperatorType.validateValue(value);
            return OperatorType.valueOf(value);
        }

        static {
            validValues = Arrays.stream(OperatorType.values()).map(Enum::name).collect(Collectors.toSet());
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class FilterGroup {
        @JsonProperty(value="is_group")
        private boolean group;
        @JsonProperty
        private OperatorType type = OperatorType.AND;
        @JsonProperty
        private Filters filters = new Filters();

        @Generated
        public void setGroup(boolean group) {
            this.group = group;
        }

        @Generated
        public void setType(OperatorType type) {
            this.type = type;
        }

        @Generated
        public void setFilters(Filters filters) {
            this.filters = filters;
        }

        @Generated
        public boolean isGroup() {
            return this.group;
        }

        @Generated
        public OperatorType getType() {
            return this.type;
        }

        @Generated
        public Filters getFilters() {
            return this.filters;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Filters
    extends TreeMap<String, FilterItems> {
        public Filters() {
            super(String.CASE_INSENSITIVE_ORDER);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class FilterItems {
        @JsonProperty(value="in_items")
        private SortedSet<String> inItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        @JsonProperty(value="like_items")
        private SortedSet<String> likeItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        @JsonProperty
        private OperatorType type = OperatorType.AND;

        public FilterItems() {
        }

        public FilterItems(SortedSet<String> inItems, SortedSet<String> likeItems, OperatorType type) {
            this.inItems = inItems;
            this.likeItems = likeItems;
            this.type = type;
        }

        public static FilterItems merge(FilterItems item1, FilterItems item2) {
            item1.inItems.addAll(item2.inItems);
            item1.likeItems.addAll(item2.likeItems);
            return item1;
        }

        @Generated
        public void setInItems(SortedSet<String> inItems) {
            this.inItems = inItems;
        }

        @Generated
        public void setLikeItems(SortedSet<String> likeItems) {
            this.likeItems = likeItems;
        }

        @Generated
        public void setType(OperatorType type) {
            this.type = type;
        }

        @Generated
        public SortedSet<String> getInItems() {
            return this.inItems;
        }

        @Generated
        public SortedSet<String> getLikeItems() {
            return this.likeItems;
        }

        @Generated
        public OperatorType getType() {
            return this.type;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Column
    extends TreeSet<String> {
        public Column() {
            super(String.CASE_INSENSITIVE_ORDER);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ColumnRow {
        @JsonProperty
        private Column column = null;
        @JsonProperty
        private Row row = null;
        @JsonProperty(value="column_sensitive_data_mask")
        private List<SensitiveDataMask> columnSensitiveDataMask = null;
        @JsonProperty(value="dependent_columns")
        private List<DependentColumn> dependentColumns = null;
        @JsonProperty(value="like_row")
        private Row likeRow = null;
        @JsonProperty(value="row_filter")
        private List<FilterGroup> rowFilter = null;

        public void setRowFilter(List<FilterGroup> rowFilter) {
            this.rowFilter = rowFilter;
        }

        public List<FilterGroup> getRowFilter() {
            return this.rowFilter;
        }

        public void setLikeRow(Row likeRow) {
            this.likeRow = likeRow;
        }

        public Row getLikeRow() {
            return this.likeRow;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public Row getRow() {
            return this.row;
        }

        public void setRow(Row row) {
            this.row = row;
        }

        public Map<String, SensitiveDataMask> getColumnSensitiveDataMaskMap() {
            HashMap<String, SensitiveDataMask> maskMap = new HashMap<String, SensitiveDataMask>();
            if (this.columnSensitiveDataMask != null) {
                for (SensitiveDataMask mask : this.columnSensitiveDataMask) {
                    maskMap.put(mask.getColumn(), mask);
                }
            }
            return maskMap;
        }

        public List<SensitiveDataMask> getColumnSensitiveDataMask() {
            return this.columnSensitiveDataMask;
        }

        public void setColumnSensitiveDataMask(List<SensitiveDataMask> columnSensitiveDataMask) {
            this.columnSensitiveDataMask = columnSensitiveDataMask;
        }

        public void setDependentColumns(List<DependentColumn> dependentColumns) {
            this.dependentColumns = dependentColumns;
        }

        public List<DependentColumn> getDependentColumns() {
            return this.dependentColumns;
        }

        public Map<String, Collection<DependentColumn>> getDependentColMap() {
            HashMap<String, Collection<DependentColumn>> map = new HashMap<String, Collection<DependentColumn>>();
            if (this.dependentColumns != null) {
                for (DependentColumn dependentColumn : this.dependentColumns) {
                    map.putIfAbsent(dependentColumn.getColumn(), new LinkedList());
                    ((Collection)map.get(dependentColumn.getColumn())).add(dependentColumn);
                }
            }
            return map;
        }

        public boolean isAllRowGranted() {
            return MapUtils.isEmpty((Map)this.row) && MapUtils.isEmpty((Map)this.likeRow) && CollectionUtils.isEmpty(this.rowFilter);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Table
    extends TreeMap<String, ColumnRow> {
        public Table() {
            super(String.CASE_INSENSITIVE_ORDER);
        }
    }
}

