/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.MissingRootPersistentEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class FusionModel
extends RootPersistentEntity
implements Serializable {
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="model_mapping")
    private Map<String, Map<String, String>> modelMapping = Maps.newHashMap();
    private KylinConfig config;

    public FusionModel() {
    }

    public FusionModel(FusionModel other) {
        this.uuid = other.uuid;
        this.alias = other.alias;
        this.modelMapping = other.modelMapping;
        this.project = other.project;
        this.createTime = other.createTime;
        this.config = other.config;
        this.lastModified = other.lastModified;
        this.version = other.version;
    }

    public FusionModel(NDataModel model, NDataModel batchModel) {
        this.uuid = model.getUuid();
        this.project = model.getProject();
        this.config = model.getConfig();
        this.modelMapping.put(model.getUuid(), null);
        HashMap tableMapping = Maps.newHashMap();
        tableMapping.put(model.getRootFactTableName(), batchModel.getRootFactTableName());
        this.modelMapping.put(batchModel.getUuid(), tableMapping);
    }

    public static String getBatchName(String streamingAlias, String modelId) {
        return streamingAlias + "_" + modelId.substring(0, 8);
    }

    public void init(KylinConfig config, String project) {
        this.config = config;
        this.project = project;
        this.setDependencies(this.calcDependencies());
    }

    public List<RootPersistentEntity> calcDependencies() {
        NDataModelManager modelManager = NDataModelManager.getInstance(this.config, this.project);
        return this.modelMapping.keySet().stream().filter(Objects::nonNull).map(id -> {
            NDataModel model = modelManager.getDataModelDesc((String)id);
            return model != null ? model : new MissingRootPersistentEntity(MetadataType.mergeKeyWithType((String)id, (MetadataType)MetadataType.TABLE_INFO));
        }).collect(Collectors.toList());
    }

    public String resourceName() {
        return this.uuid;
    }

    public MetadataType resourceType() {
        return MetadataType.FUSION_MODEL;
    }

    public Set<String> getModelsId() {
        return this.modelMapping.keySet();
    }

    public NDataModel getBatchModel() {
        return this.getModelByType(NDataModel.ModelType.BATCH);
    }

    public NDataModel getStreamingModel() {
        return this.getModelByType(NDataModel.ModelType.HYBRID);
    }

    public String getAlias() {
        return this.getStreamingModel().getAlias();
    }

    public NDataModel getModelByType(NDataModel.ModelType modelType) {
        NDataModelManager modelManager = NDataModelManager.getInstance(this.config, this.project);
        for (String modelId : this.getModelsId()) {
            NDataModel model = modelManager.getDataModelDesc(modelId);
            if (model == null || model.getModelType() != modelType) continue;
            return model;
        }
        return null;
    }

    @Generated
    public Map<String, Map<String, String>> getModelMapping() {
        return this.modelMapping;
    }

    @Generated
    public KylinConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setModelMapping(Map<String, Map<String, String>> modelMapping) {
        this.modelMapping = modelMapping;
    }

    @Generated
    public void setConfig(KylinConfig config) {
        this.config = config;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionModel)) {
            return false;
        }
        FusionModel other = (FusionModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        Map<String, Map<String, String>> this$modelMapping = this.getModelMapping();
        Map<String, Map<String, String>> other$modelMapping = other.getModelMapping();
        if (this$modelMapping == null ? other$modelMapping != null : !((Object)this$modelMapping).equals(other$modelMapping)) {
            return false;
        }
        KylinConfig this$config = this.getConfig();
        KylinConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FusionModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        Map<String, Map<String, String>> $modelMapping = this.getModelMapping();
        result = result * 59 + ($modelMapping == null ? 43 : ((Object)$modelMapping).hashCode());
        KylinConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FusionModel(alias=" + this.getAlias() + ", modelMapping=" + this.getModelMapping() + ", config=" + this.getConfig() + ")";
    }
}

