/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.exception.PasswordDecryptionException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class PasswordPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Set<String> passwordWhiteList = Sets.newHashSet((Object[])new String[]{"kylin.security.user-password-encoder"});

    public PasswordPlaceholderConfigurer() throws IOException {
        Resource[] resources = new Resource[1];
        Properties prop = this.getAllKylinProperties();
        String propString = null;
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            prop.store(new PrintWriter((Writer)writer), "kylin properties");
            propString = writer.getBuilder().toString();
        }
        ByteArrayResource byteArrayResource = new ByteArrayResource(propString.getBytes(Charset.defaultCharset()));
        resources[0] = byteArrayResource;
        this.setFileEncoding(Charset.defaultCharset().toString());
        this.setLocations(resources);
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.kylin.rest.security.PasswordPlaceholderConfigurer <EncryptMethod> <your_password>");
        System.out.println("EncryptMethod: AES or BCrypt");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            PasswordPlaceholderConfigurer.printUsage();
            Unsafe.systemExit((int)1);
        }
        String encryptMethod = args[0];
        String passwordTxt = args[1];
        if ("AES".equalsIgnoreCase(encryptMethod)) {
            System.out.println(encryptMethod + " encrypted password is: ");
            System.out.println(EncryptUtil.encrypt((String)passwordTxt));
        } else if ("BCrypt".equalsIgnoreCase(encryptMethod)) {
            BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
            System.out.println(encryptMethod + " encrypted password is: ");
            System.out.println(bCryptPasswordEncoder.encode((CharSequence)passwordTxt));
        } else {
            PasswordPlaceholderConfigurer.printUsage();
            Unsafe.systemExit((int)1);
        }
    }

    public Properties getAllKylinProperties() {
        Properties allProps;
        try {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            Method getAllMethod = KylinConfigBase.class.getDeclaredMethod("getAllProperties", new Class[0]);
            Unsafe.changeAccessibleObject((AccessibleObject)getAllMethod, (boolean)true);
            allProps = (Properties)getAllMethod.invoke((Object)kylinConfig, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return allProps;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        if (placeholder.toLowerCase(Locale.ROOT).contains("password") && !passwordWhiteList.contains(placeholder)) {
            try {
                return EncryptUtil.decrypt((String)props.getProperty(placeholder));
            }
            catch (Exception e) {
                throw new PasswordDecryptionException(String.format(Locale.ROOT, "[%s] Encrypted configuration item decryption failed, please check for errors", placeholder), e.getCause());
            }
        }
        return props.getProperty(placeholder);
    }
}

