/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.rest.constant.ModelStatusToDisplayEnum;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NMetaStoreController;
import org.apache.kylin.rest.request.ModelImportRequest;
import org.apache.kylin.rest.request.ModelPreviewRequest;
import org.apache.kylin.rest.request.OpenModelPreviewRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ModelPreviewResponse;
import org.apache.kylin.rest.service.MetaStoreService;
import org.apache.kylin.rest.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/metastore"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenMetaStoreController
extends NBasicController {
    @Autowired
    private ModelService modelService;
    @Autowired
    private NMetaStoreController metaStoreController;
    @Autowired
    private MetaStoreService metaStoreService;

    @ApiOperation(value="previewModels", tags={"MID"})
    @GetMapping(value={"/previews/models"})
    @ResponseBody
    public EnvelopeResponse<List<ModelPreviewResponse>> previewModels(@RequestParam(value="project") String project, @RequestParam(value="model_names", required=false, defaultValue="") List<String> modelNames) {
        String projectName = this.checkProjectName(project);
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        ArrayList<String> modelIds = new ArrayList<String>();
        ArrayList<String> notExistModelNames = new ArrayList<String>();
        for (String modelName : modelNames) {
            NDataModel modelDesc = modelManager.getDataModelDescByAlias(modelName);
            if (Objects.isNull(modelDesc)) {
                notExistModelNames.add(modelName);
                continue;
            }
            modelIds.add(modelDesc.getId());
        }
        if (!notExistModelNames.isEmpty()) {
            String joinedModelNames = StringUtils.join(notExistModelNames, (String)",");
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{joinedModelNames});
        }
        List simplifiedModels = this.metaStoreService.getPreviewModels(projectName, modelIds);
        List nonBrokenModels = simplifiedModels.stream().filter(modelPreviewResponse -> modelPreviewResponse.getStatus() != ModelStatusToDisplayEnum.BROKEN).collect(Collectors.toList());
        return new EnvelopeResponse("000", nonBrokenModels, "");
    }

    @ApiOperation(value="exportModelMetadata", tags={"MID"})
    @PostMapping(value={"/backup/models"})
    @ResponseBody
    public EnvelopeResponse<String> exportModelMetadata(@RequestParam(value="project") String project, @RequestBody OpenModelPreviewRequest request, HttpServletResponse response) throws Exception {
        String projectName = this.checkProjectName(project);
        this.checkExportModelsValid(projectName, request);
        ModelPreviewRequest modelPreviewRequest = this.convertToModelPreviewRequest(projectName, request);
        this.metaStoreController.exportModelMetadata(projectName, modelPreviewRequest, response);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="uploadAndCheckModelMetadata", tags={"MID"})
    @PostMapping(value={"/validation/models"})
    @ResponseBody
    public EnvelopeResponse<SchemaChangeCheckResult> uploadAndCheckModelMetadata(@RequestParam(value="project") String project, @RequestPart(value="file") MultipartFile uploadFile, @RequestPart(value="request", required=false) ModelImportRequest request) throws Exception {
        return this.metaStoreController.uploadAndCheckModelMetadata(project, uploadFile, request);
    }

    @ApiOperation(value="importModelMetadata", tags={"MID"})
    @PostMapping(value={"/import/models"})
    @ResponseBody
    public EnvelopeResponse<String> importModelMetadata(@RequestParam(value="project") String project, @RequestPart(value="file") MultipartFile metadataFile, @RequestPart(value="request") ModelImportRequest request) throws Exception {
        String projectName = this.checkProjectName(project);
        this.metaStoreController.importModelMetadata(projectName, metadataFile, request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private ModelPreviewRequest convertToModelPreviewRequest(String project, OpenModelPreviewRequest request) {
        NDataModelManager modelManager = (NDataModelManager)this.modelService.getManager(NDataModelManager.class, project);
        List modelIds = request.getNames().stream().map(name -> modelManager.getDataModelDescByAlias(name).getUuid()).collect(Collectors.toList());
        ModelPreviewRequest modelPreviewRequest = new ModelPreviewRequest();
        modelPreviewRequest.setIds(modelIds);
        modelPreviewRequest.setExportRecommendations(request.isExportRecommendations());
        modelPreviewRequest.setExportOverProps(request.isExportOverProps());
        modelPreviewRequest.setExportMultiplePartitionValues(request.isExportMultiplePartitionValues());
        return modelPreviewRequest;
    }

    private void checkRequestModelNamesNotEmpty(OpenModelPreviewRequest request) {
        List modelNames = request.getNames();
        if (CollectionUtils.isEmpty((Collection)modelNames)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_EMPTY, new Object[0]);
        }
    }

    private void checkExportModelsValid(String project, OpenModelPreviewRequest request) {
        this.checkRequestModelNamesNotEmpty(request);
        NDataModelManager modelManager = (NDataModelManager)this.modelService.getManager(NDataModelManager.class, project);
        for (String modelName : request.getNames()) {
            NDataModel modelDesc = modelManager.getDataModelDescByAlias(modelName);
            if (Objects.isNull(modelDesc)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelName});
            }
            if (!modelDesc.isBroken()) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_BROKEN, String.format(Locale.ROOT, "Broken model cannot be exported. Model name: [%s].", modelName));
        }
    }
}

