/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import io.delta.storage.AzureLogStore;
import io.delta.storage.GCSLogStore;
import io.delta.storage.HDFSLogStore;
import io.delta.storage.S3SingleDriverLogStore;
import org.apache.spark.sql.delta.DeltaErrors$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;

public final class DelegatingLogStore$ {
    public static DelegatingLogStore$ MODULE$;
    private final String defaultS3LogStoreClassName;
    private final String defaultAzureLogStoreClassName;
    private final String defaultHDFSLogStoreClassName;
    private final String defaultGCSLogStoreClassName;
    private final Set<String> s3Schemes;
    private final Set<String> azureSchemes;
    private final Set<String> gsSchemes;

    static {
        new DelegatingLogStore$();
    }

    public String defaultS3LogStoreClassName() {
        return this.defaultS3LogStoreClassName;
    }

    public String defaultAzureLogStoreClassName() {
        return this.defaultAzureLogStoreClassName;
    }

    public String defaultHDFSLogStoreClassName() {
        return this.defaultHDFSLogStoreClassName;
    }

    public String defaultGCSLogStoreClassName() {
        return this.defaultGCSLogStoreClassName;
    }

    public Set<String> s3Schemes() {
        return this.s3Schemes;
    }

    public Set<String> azureSchemes() {
        return this.azureSchemes;
    }

    public Set<String> gsSchemes() {
        return this.gsSchemes;
    }

    public Option<String> getDefaultLogStoreClassName(String scheme) {
        if (this.s3Schemes().contains((Object)scheme)) {
            return new Some((Object)this.defaultS3LogStoreClassName());
        }
        if (this.azureSchemes().apply((Object)scheme)) {
            return new Some((Object)this.defaultAzureLogStoreClassName());
        }
        if (this.gsSchemes().apply((Object)scheme)) {
            return new Some((Object)this.defaultGCSLogStoreClassName());
        }
        return None$.MODULE$;
    }

    private DelegatingLogStore$() {
        MODULE$ = this;
        try {
        }
        catch (NoClassDefFoundError e) {
            throw DeltaErrors$.MODULE$.missingDeltaStorageJar(e);
        }
        this.defaultS3LogStoreClassName = S3SingleDriverLogStore.class.getName();
        this.defaultAzureLogStoreClassName = AzureLogStore.class.getName();
        this.defaultHDFSLogStoreClassName = HDFSLogStore.class.getName();
        this.defaultGCSLogStoreClassName = GCSLogStore.class.getName();
        this.s3Schemes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3", "s3a", "s3n"}));
        this.azureSchemes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abfs", "abfss", "adl", "wasb", "wasbs"}));
        this.gsSchemes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gs"}));
    }
}

