/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class LimitAndOffsetPagingModelRenderer {
    private final RenderingStrategy renderingStrategy;
    private final Long limit;
    private final PagingModel pagingModel;
    private final AtomicInteger sequence;

    public LimitAndOffsetPagingModelRenderer(RenderingStrategy renderingStrategy, Long limit, PagingModel pagingModel, AtomicInteger sequence) {
        this.renderingStrategy = renderingStrategy;
        this.limit = Objects.requireNonNull(limit);
        this.pagingModel = pagingModel;
        this.sequence = sequence;
    }

    public FragmentAndParameters render() {
        return this.pagingModel.offset().map(this::renderLimitAndOffset).orElseGet(this::renderLimitOnly);
    }

    private FragmentAndParameters renderLimitOnly() {
        String mapKey = this.renderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("limit " + this.renderPlaceholder(mapKey)).withParameter(mapKey, this.limit).build();
    }

    private FragmentAndParameters renderLimitAndOffset(Long offset) {
        String mapKey1 = this.renderingStrategy.formatParameterMapKey(this.sequence);
        String mapKey2 = this.renderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("limit " + this.renderPlaceholder(mapKey1) + " offset " + this.renderPlaceholder(mapKey2)).withParameter(mapKey1, this.limit).withParameter(mapKey2, offset).build();
    }

    private String renderPlaceholder(String parameterName) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", parameterName);
    }
}

