/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import java.util.List;
import java.util.Map;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ConverterUtils;
import org.apache.gluten.substrait.expression.AggregateFunctionNode;
import org.apache.gluten.substrait.expression.BinaryLiteralNode;
import org.apache.gluten.substrait.expression.BooleanLiteralNode;
import org.apache.gluten.substrait.expression.ByteLiteralNode;
import org.apache.gluten.substrait.expression.CastNode;
import org.apache.gluten.substrait.expression.DateLiteralNode;
import org.apache.gluten.substrait.expression.DecimalLiteralNode;
import org.apache.gluten.substrait.expression.DoubleLiteralNode;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.expression.FloatLiteralNode;
import org.apache.gluten.substrait.expression.IntLiteralNode;
import org.apache.gluten.substrait.expression.ListLiteralNode;
import org.apache.gluten.substrait.expression.LiteralNode;
import org.apache.gluten.substrait.expression.LongLiteralNode;
import org.apache.gluten.substrait.expression.MapLiteralNode;
import org.apache.gluten.substrait.expression.NullLiteralNode;
import org.apache.gluten.substrait.expression.ScalarFunctionNode;
import org.apache.gluten.substrait.expression.SelectionNode;
import org.apache.gluten.substrait.expression.ShortLiteralNode;
import org.apache.gluten.substrait.expression.SingularOrListNode;
import org.apache.gluten.substrait.expression.StringLiteralNode;
import org.apache.gluten.substrait.expression.StringMapNode;
import org.apache.gluten.substrait.expression.StructLiteralNode;
import org.apache.gluten.substrait.expression.TimestampLiteralNode;
import org.apache.gluten.substrait.expression.WindowFunctionNode;
import org.apache.gluten.substrait.type.BinaryTypeNode;
import org.apache.gluten.substrait.type.BooleanTypeNode;
import org.apache.gluten.substrait.type.DateTypeNode;
import org.apache.gluten.substrait.type.DecimalTypeNode;
import org.apache.gluten.substrait.type.FP32TypeNode;
import org.apache.gluten.substrait.type.FP64TypeNode;
import org.apache.gluten.substrait.type.I16TypeNode;
import org.apache.gluten.substrait.type.I32TypeNode;
import org.apache.gluten.substrait.type.I64TypeNode;
import org.apache.gluten.substrait.type.I8TypeNode;
import org.apache.gluten.substrait.type.ListNode;
import org.apache.gluten.substrait.type.MapNode;
import org.apache.gluten.substrait.type.StringTypeNode;
import org.apache.gluten.substrait.type.StructNode;
import org.apache.gluten.substrait.type.TimestampTypeNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;

public class ExpressionBuilder {
    private ExpressionBuilder() {
    }

    public static Long newScalarFunction(Map<String, Long> functionMap, String functionName) {
        if (!functionMap.containsKey(functionName)) {
            Long functionId = functionMap.size();
            functionMap.put(functionName, functionId);
            return functionId;
        }
        return functionMap.get(functionName);
    }

    public static NullLiteralNode makeNullLiteral(TypeNode typeNode) {
        return new NullLiteralNode(typeNode);
    }

    public static BooleanLiteralNode makeBooleanLiteral(Boolean vBool) {
        return new BooleanLiteralNode(vBool);
    }

    public static BooleanLiteralNode makeBooleanLiteral(Boolean vBool, TypeNode typeNode) {
        return new BooleanLiteralNode(vBool, typeNode);
    }

    public static IntLiteralNode makeIntLiteral(Integer vInt) {
        return new IntLiteralNode(vInt);
    }

    public static IntLiteralNode makeIntLiteral(Integer vInt, TypeNode typeNode) {
        return new IntLiteralNode(vInt, typeNode);
    }

    public static ByteLiteralNode makeByteLiteral(Byte vByte) {
        return new ByteLiteralNode(vByte);
    }

    public static ByteLiteralNode makeByteLiteral(Byte vByte, TypeNode typeNode) {
        return new ByteLiteralNode(vByte, typeNode);
    }

    public static ShortLiteralNode makeShortLiteral(Short vShort) {
        return new ShortLiteralNode(vShort);
    }

    public static ShortLiteralNode makeShortLiteral(Short vShort, TypeNode typeNode) {
        return new ShortLiteralNode(vShort, typeNode);
    }

    public static LongLiteralNode makeLongLiteral(Long vLong) {
        return new LongLiteralNode(vLong);
    }

    public static LongLiteralNode makeLongLiteral(Long vLong, TypeNode typeNode) {
        return new LongLiteralNode(vLong, typeNode);
    }

    public static DoubleLiteralNode makeDoubleLiteral(Double vDouble) {
        return new DoubleLiteralNode(vDouble);
    }

    public static DoubleLiteralNode makeDoubleLiteral(Double vDouble, TypeNode typeNode) {
        return new DoubleLiteralNode(vDouble, typeNode);
    }

    public static FloatLiteralNode makeFloatLiteral(Float vFloat) {
        return new FloatLiteralNode(vFloat);
    }

    public static FloatLiteralNode makeFloatLiteral(Float vFloat, TypeNode typeNode) {
        return new FloatLiteralNode(vFloat, typeNode);
    }

    public static DateLiteralNode makeDateLiteral(Integer vDate) {
        return new DateLiteralNode(vDate);
    }

    public static DateLiteralNode makeDateLiteral(Integer vDate, TypeNode typeNode) {
        return new DateLiteralNode(vDate, typeNode);
    }

    public static TimestampLiteralNode makeTimestampLiteral(Long vTimestamp) {
        return new TimestampLiteralNode(vTimestamp);
    }

    public static TimestampLiteralNode makeTimestampLiteral(Long vTimestamp, TypeNode typeNode) {
        return new TimestampLiteralNode(vTimestamp, typeNode);
    }

    public static StringLiteralNode makeStringLiteral(String vString) {
        return new StringLiteralNode(vString);
    }

    public static StringLiteralNode makeStringLiteral(String vString, TypeNode typeNode) {
        return new StringLiteralNode(vString, typeNode);
    }

    public static BinaryLiteralNode makeBinaryLiteral(byte[] vBytes) {
        return new BinaryLiteralNode(vBytes);
    }

    public static BinaryLiteralNode makeBinaryLiteral(byte[] vBytes, TypeNode typeNode) {
        return new BinaryLiteralNode(vBytes, typeNode);
    }

    public static DecimalLiteralNode makeDecimalLiteral(Decimal vDecimal) {
        return new DecimalLiteralNode(vDecimal);
    }

    public static DecimalLiteralNode makeDecimalLiteral(Decimal vDecimal, TypeNode typeNode) {
        return new DecimalLiteralNode(vDecimal, typeNode);
    }

    public static ListLiteralNode makeListLiteral(ArrayData array, TypeNode typeNode) {
        return new ListLiteralNode(array, typeNode);
    }

    public static MapLiteralNode makeMapLiteral(MapData map, TypeNode typeNode) {
        return new MapLiteralNode(map, typeNode);
    }

    public static StructLiteralNode makeStructLiteral(InternalRow row, TypeNode typeNode) {
        return new StructLiteralNode(row, typeNode);
    }

    public static LiteralNode makeLiteral(Object obj, TypeNode typeNode) {
        if (obj == null) {
            return ExpressionBuilder.makeNullLiteral(typeNode);
        }
        if (typeNode instanceof BooleanTypeNode) {
            return ExpressionBuilder.makeBooleanLiteral((Boolean)obj, typeNode);
        }
        if (typeNode instanceof I8TypeNode) {
            return ExpressionBuilder.makeByteLiteral((Byte)obj, typeNode);
        }
        if (typeNode instanceof I16TypeNode) {
            return ExpressionBuilder.makeShortLiteral((Short)obj, typeNode);
        }
        if (typeNode instanceof I32TypeNode) {
            return ExpressionBuilder.makeIntLiteral((Integer)obj, typeNode);
        }
        if (typeNode instanceof I64TypeNode) {
            return ExpressionBuilder.makeLongLiteral((Long)obj, typeNode);
        }
        if (typeNode instanceof FP32TypeNode) {
            return ExpressionBuilder.makeFloatLiteral((Float)obj, typeNode);
        }
        if (typeNode instanceof FP64TypeNode) {
            return ExpressionBuilder.makeDoubleLiteral((Double)obj, typeNode);
        }
        if (typeNode instanceof DateTypeNode) {
            return ExpressionBuilder.makeDateLiteral((Integer)obj, typeNode);
        }
        if (typeNode instanceof TimestampTypeNode) {
            return ExpressionBuilder.makeTimestampLiteral((Long)obj, typeNode);
        }
        if (typeNode instanceof StringTypeNode) {
            return ExpressionBuilder.makeStringLiteral(obj.toString(), typeNode);
        }
        if (typeNode instanceof BinaryTypeNode) {
            return ExpressionBuilder.makeBinaryLiteral((byte[])obj, typeNode);
        }
        if (typeNode instanceof DecimalTypeNode) {
            Decimal decimal = (Decimal)obj;
            ExpressionBuilder.checkDecimalScale(decimal.scale());
            return ExpressionBuilder.makeDecimalLiteral(decimal, typeNode);
        }
        if (typeNode instanceof ListNode) {
            return ExpressionBuilder.makeListLiteral((ArrayData)obj, typeNode);
        }
        if (typeNode instanceof MapNode) {
            return ExpressionBuilder.makeMapLiteral((MapData)obj, typeNode);
        }
        if (typeNode instanceof StructNode) {
            return ExpressionBuilder.makeStructLiteral((InternalRow)obj, typeNode);
        }
        throw new GlutenNotSupportException(String.format("Type not supported: %s, obj: %s, class: %s", typeNode.toString(), obj.toString(), obj.getClass().toString()));
    }

    public static LiteralNode makeLiteral(Object obj, DataType dataType, Boolean nullable) {
        TypeNode typeNode = ConverterUtils.getTypeNode(dataType, nullable);
        if (obj instanceof UnsafeArrayData) {
            UnsafeArrayData oldObj = (UnsafeArrayData)obj;
            int numElements = oldObj.numElements();
            Object[] elements = new Object[numElements];
            DataType elementType = ((ArrayType)dataType).elementType();
            for (int i = 0; i < numElements; ++i) {
                elements[i] = oldObj.get(i, elementType);
            }
            GenericArrayData newObj = new GenericArrayData(elements);
            return ExpressionBuilder.makeListLiteral((ArrayData)newObj, typeNode);
        }
        return ExpressionBuilder.makeLiteral(obj, typeNode);
    }

    public static void checkDecimalScale(int scale) {
        if (scale < 0) {
            throw new UnsupportedOperationException(String.format("DecimalType with negative scale not supported: %s.", scale));
        }
    }

    public static ScalarFunctionNode makeScalarFunction(Long functionId, List<ExpressionNode> expressionNodes, TypeNode typeNode) {
        return new ScalarFunctionNode(functionId, expressionNodes, typeNode);
    }

    public static SelectionNode makeSelection(Integer fieldIdx) {
        return new SelectionNode(fieldIdx);
    }

    public static SelectionNode makeSelection(Integer fieldIdx, Integer childFieldIdx) {
        return new SelectionNode(fieldIdx, childFieldIdx);
    }

    public static AggregateFunctionNode makeAggregateFunction(Long functionId, List<ExpressionNode> expressionNodes, String phase, TypeNode outputTypeNode) {
        return new AggregateFunctionNode(functionId, expressionNodes, phase, outputTypeNode);
    }

    public static CastNode makeCast(TypeNode typeNode, ExpressionNode expressionNode, boolean throwOnFailure) {
        return new CastNode(typeNode, expressionNode, throwOnFailure);
    }

    public static StringMapNode makeStringMap(Map<String, String> values) {
        return new StringMapNode(values);
    }

    public static SingularOrListNode makeSingularOrListNode(ExpressionNode value, List<ExpressionNode> expressionNodes) {
        return new SingularOrListNode(value, expressionNodes);
    }

    public static WindowFunctionNode makeWindowFunction(Integer functionId, List<ExpressionNode> expressionNodes, String columnName, TypeNode outputTypeNode, Expression upperBound, Expression lowerBound, String frameType, List<Attribute> originalInputAttributes) {
        return ExpressionBuilder.makeWindowFunction(functionId, expressionNodes, columnName, outputTypeNode, upperBound, lowerBound, frameType, false, originalInputAttributes);
    }

    public static WindowFunctionNode makeWindowFunction(Integer functionId, List<ExpressionNode> expressionNodes, String columnName, TypeNode outputTypeNode, Expression upperBound, Expression lowerBound, String frameType, boolean ignoreNulls, List<Attribute> originalInputAttributes) {
        return new WindowFunctionNode(functionId, expressionNodes, columnName, outputTypeNode, upperBound, lowerBound, frameType, ignoreNulls, originalInputAttributes);
    }
}

