/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MysqlSqlDialect
extends SqlDialect {
    public static final RelDataTypeSystem MYSQL_TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case CHAR: {
                    return 255;
                }
                case VARCHAR: {
                    return 65535;
                }
                case TIMESTAMP: {
                    return 6;
                }
            }
            return super.getMaxPrecision(typeName);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.MYSQL).withIdentifierQuoteString("`").withDataTypeSystem(MYSQL_TYPE_SYSTEM).withUnquotedCasing(Casing.UNCHANGED).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new MysqlSqlDialect(DEFAULT_CONTEXT);
    public static final SqlFunction ISNULL_FUNCTION = new SqlFunction("ISNULL", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.ANY, SqlFunctionCategory.SYSTEM);
    private final int majorVersion;

    public MysqlSqlDialect(SqlDialect.Context context) {
        super(context);
        this.majorVersion = context.databaseMajorVersion();
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        MysqlSqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case COUNT: 
            case SUM: 
            case SUM0: 
            case MIN: 
            case MAX: 
            case SINGLE_VALUE: {
                return true;
            }
            case ROLLUP: {
                return this.majorVersion >= 8;
            }
        }
        return false;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public SqlDialect.CalendarPolicy getCalendarPolicy() {
        return SqlDialect.CalendarPolicy.SHIFT;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case VARCHAR: {
                int vcMaxPrecision = this.getTypeSystem().getMaxPrecision(SqlTypeName.CHAR);
                int precision = type.getPrecision();
                if (vcMaxPrecision > 0 && precision > vcMaxPrecision) {
                    precision = vcMaxPrecision;
                }
                return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.CHAR, precision, SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case INTEGER: 
            case BIGINT: {
                return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("SIGNED", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case TIMESTAMP: {
                return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("DATETIME", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
        }
        return super.getCastSpec(type);
    }

    @Override
    public SqlNode rewriteSingleValueExpr(SqlNode aggCall) {
        Object operand = ((SqlBasicCall)aggCall).operand(0);
        SqlLiteral nullLiteral = SqlLiteral.createNull(SqlParserPos.ZERO);
        SqlSelect unionOperand = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, SqlNodeList.of(nullLiteral), null, null, null, null, SqlNodeList.EMPTY, null, null, null, SqlNodeList.EMPTY);
        SqlCase caseExpr = new SqlCase(SqlParserPos.ZERO, SqlStdOperatorTable.COUNT.createCall(SqlParserPos.ZERO, new SqlNode[]{operand}), SqlNodeList.of(SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO), SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO)), SqlNodeList.of(nullLiteral, operand), SqlStdOperatorTable.SCALAR_QUERY.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.UNION_ALL.createCall(SqlParserPos.ZERO, unionOperand, unionOperand)));
        LOGGER.debug("SINGLE_VALUE rewritten into [{}]", (Object)caseExpr);
        return caseExpr;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                MysqlSqlDialect.unparseFloor(writer, call);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private static void unparseFloor(SqlWriter writer, SqlCall call) {
        String format;
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = node.getValueAs(TimeUnitRange.class);
        if (unit == TimeUnitRange.WEEK) {
            writer.print("STR_TO_DATE");
            SqlWriter.Frame frame = writer.startList("(", ")");
            writer.print("DATE_FORMAT(");
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
            writer.print(", '%x%v-1'), '%x%v-%w'");
            writer.endList(frame);
            return;
        }
        switch (unit) {
            case YEAR: {
                format = "%Y-01-01";
                break;
            }
            case MONTH: {
                format = "%Y-%m-01";
                break;
            }
            case DAY: {
                format = "%Y-%m-%d";
                break;
            }
            case HOUR: {
                format = "%Y-%m-%d %H:00:00";
                break;
            }
            case MINUTE: {
                format = "%Y-%m-%d %H:%i:00";
                break;
            }
            case SECOND: {
                format = "%Y-%m-%d %H:%i:%s";
                break;
            }
            default: {
                throw new AssertionError((Object)("MYSQL does not support FLOOR for time unit: " + unit));
            }
        }
        writer.print("DATE_FORMAT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep(",", true);
        writer.print("'" + format + "'");
        writer.endList(frame);
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        if (!qualifier.useDefaultFractionalSecondPrecision()) {
            throw new AssertionError((Object)"Fractional second precision is not supported now ");
        }
        String start = MysqlSqlDialect.validate(qualifier.timeUnitRange.startUnit).name();
        if (qualifier.timeUnitRange.startUnit == TimeUnit.SECOND || qualifier.timeUnitRange.endUnit == null) {
            writer.keyword(start);
        } else {
            writer.keyword(start + "_" + qualifier.timeUnitRange.endUnit.name());
        }
    }

    @Override
    public boolean supportsJoinType(JoinRelType joinType) {
        return joinType != JoinRelType.FULL;
    }

    private static TimeUnit validate(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case DAY: 
            case WEEK: 
            case MONTH: 
            case QUARTER: 
            case YEAR: {
                return timeUnit;
            }
        }
        throw new AssertionError((Object)(" Time unit " + timeUnit + "is not supported now."));
    }
}

