/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.manager;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkOperation$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.utils.DeriveTableColumnInfo;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SparderLookupManager$
implements Logging {
    public static SparderLookupManager$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparderLookupManager$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public LogicalPlan create(String name, String sourcePath, KylinConfig kylinConfig) {
        LogicalPlan logicalPlan;
        String[] names = name.split("@");
        String projectName = names[0];
        String tableName = names[1];
        NTableMetadataManager metaMgr = NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)projectName);
        TableDesc tableDesc = metaMgr.getTableDesc(tableName);
        String dfTableName = Integer.toHexString(System.identityHashCode(name));
        ListBuffer orderedCol = new ListBuffer();
        ObjectRef partitionCol = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableDesc.getColumns())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparderLookupManager$.$anonfun$create$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            SparderLookupManager$.$anonfun$create$2(tableDesc, orderedCol, partitionCol, x$1);
            return BoxedUnit.UNIT;
        });
        StructType originSchema = StructType$.MODULE$.apply((Seq)orderedCol.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ColumnDesc col = (ColumnDesc)tuple2._1();
            StructField structField = new StructField(col.getName(), SparderTypeUtil$.MODULE$.toSparkType(col.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return structField;
        }, ListBuffer$.MODULE$.canBuildFrom()));
        SparkSession sparkSession = SparderEnv$.MODULE$.getSparkSession();
        if (sourcePath.contains("/Internal/")) {
            String arg$macro$1 = projectName;
            String arg$macro$2 = tableName;
            String sql = new StringOps("select * from INTERNAL_CATALOG.%s.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2}));
            logicalPlan = sparkSession.sql(sql).queryExecution().analyzed();
        } else {
            BoxedUnit boxedUnit;
            HashMap options = new HashMap();
            if ((Tuple2)partitionCol.elem != null) {
                orderedCol.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{(Tuple2)partitionCol.elem}));
                options.put((Object)"partition_col", (Object)tableDesc.getSnapshotPartitionCol());
                options.put((Object)"partitions", (Object)String.join((CharSequence)",", tableDesc.getSnapshotPartitions().keySet()));
                boxedUnit = options.put((Object)"mapreduce.input.pathFilter.class", (Object)"org.apache.kylin.query.util.PartitionsFilter");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Path resourcePath = new Path(new StringBuilder(0).append(KapConfig.getInstanceFromEnv().getReadHdfsWorkingDirectory()).append(sourcePath).toString());
            InMemoryFileIndex fileIndex = new InMemoryFileIndex(sparkSession, (Seq)new .colon.colon((Object)resourcePath, (List)Nil$.MODULE$), options.toMap(Predef$.MODULE$.$conforms()), Option$.MODULE$.apply((Object)originSchema), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7());
            HadoopFsRelation fsRelation = new HadoopFsRelation((FileIndex)fileIndex, fileIndex.partitionSchema(), originSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), options.toMap(Predef$.MODULE$.$conforms()), sparkSession);
            logicalPlan = LogicalRelation$.MODULE$.apply((BaseRelation)fsRelation, LogicalRelation$.MODULE$.apply$default$2());
        }
        LogicalPlan plan = logicalPlan;
        ListBuffer aliasCols = (ListBuffer)orderedCol.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ColumnDesc c = (ColumnDesc)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Column column = functions$.MODULE$.col(c.getName()).as(new DeriveTableColumnInfo(dfTableName, index, c.getName()).toString());
            return column;
        }, ListBuffer$.MODULE$.canBuildFrom());
        return SparkOperation$.MODULE$.project((Seq<Column>)aliasCols, plan);
    }

    public LogicalPlan getOrCreate(String name, String sourcePath, KylinConfig kylinConfig) {
        return this.create(name, sourcePath, kylinConfig);
    }

    public static final /* synthetic */ boolean $anonfun$create$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$create$2(TableDesc tableDesc$1, ListBuffer orderedCol$1, ObjectRef partitionCol$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            ColumnDesc col = (ColumnDesc)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (!col.getName().equals(tableDesc$1.getSnapshotPartitionCol())) {
                orderedCol$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)col, (Object)BoxesRunTime.boxToInteger((int)index))}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                partitionCol$1.elem = new Tuple2((Object)col, (Object)BoxesRunTime.boxToInteger((int)index));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private SparderLookupManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

