/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.search;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.fragments.search.QueryParserTabOperator;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.search.QueryParserConfig;

public final class QueryParserPaneProvider
implements QueryParserTabOperator {
    private final JRadioButton standardRB = new JRadioButton();
    private final JRadioButton classicRB = new JRadioButton();
    private final JComboBox<String> dfCB = new JComboBox();
    private final JComboBox<String> defOpCombo = new JComboBox<String>(new String[]{QueryParserConfig.Operator.OR.name(), QueryParserConfig.Operator.AND.name()});
    private final JCheckBox posIncCB = new JCheckBox();
    private final JCheckBox wildCardCB = new JCheckBox();
    private final JCheckBox splitWSCB = new JCheckBox();
    private final JCheckBox genPhraseQueryCB = new JCheckBox();
    private final JCheckBox genMultiTermSynonymsPhraseQueryCB = new JCheckBox();
    private final JFormattedTextField slopFTF = new JFormattedTextField();
    private final JFormattedTextField minSimFTF = new JFormattedTextField();
    private final JFormattedTextField prefLenFTF = new JFormattedTextField();
    private final JComboBox<String> dateResCB = new JComboBox();
    private final JTextField locationTF = new JTextField();
    private final JTextField timezoneTF = new JTextField();
    private final JTable pointRangeQueryTable = new JTable();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private final QueryParserConfig config = new QueryParserConfig.Builder().build();

    public QueryParserPaneProvider() {
        ComponentOperatorRegistry.getInstance().register(QueryParserTabOperator.class, this);
    }

    public JScrollPane get() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add(this.initSelectParserPane());
        panel.add(new JSeparator(0));
        panel.add(this.initParserSettingsPanel());
        panel.add(new JSeparator(0));
        panel.add(this.initPhraseQuerySettingsPanel());
        panel.add(new JSeparator(0));
        panel.add(this.initFuzzyQuerySettingsPanel());
        panel.add(new JSeparator(0));
        panel.add(this.initDateRangeQuerySettingsPanel());
        panel.add(new JSeparator(0));
        panel.add(this.initPointRangeQuerySettingsPanel());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private JPanel initSelectParserPane() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setOpaque(false);
        this.standardRB.setText("StandardQueryParser");
        this.standardRB.setSelected(true);
        this.standardRB.addActionListener(this.listeners::selectStandardQParser);
        this.standardRB.setOpaque(false);
        this.classicRB.setText("Classic QueryParser");
        this.classicRB.addActionListener(this.listeners::selectClassicQparser);
        this.classicRB.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.standardRB);
        group.add(this.classicRB);
        panel.add(this.standardRB);
        panel.add(this.classicRB);
        return panel;
    }

    private JPanel initParserSettingsPanel() {
        JPanel panel = new JPanel(new GridLayout(3, 2));
        panel.setOpaque(false);
        JPanel defField = new JPanel(new FlowLayout(3));
        defField.setOpaque(false);
        JLabel dfLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.df"));
        defField.add(dfLabel);
        defField.add(this.dfCB);
        panel.add(defField);
        JPanel defOp = new JPanel(new FlowLayout(3));
        defOp.setOpaque(false);
        JLabel defOpLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.dop"));
        defOp.add(defOpLabel);
        this.defOpCombo.setSelectedItem(this.config.getDefaultOperator().name());
        defOp.add(this.defOpCombo);
        panel.add(defOp);
        this.posIncCB.setText(MessageUtils.getLocalizedMessage("search_parser.checkbox.pos_incr"));
        this.posIncCB.setSelected(this.config.isEnablePositionIncrements());
        this.posIncCB.setOpaque(false);
        panel.add(this.posIncCB);
        this.wildCardCB.setText(MessageUtils.getLocalizedMessage("search_parser.checkbox.lead_wildcard"));
        this.wildCardCB.setSelected(this.config.isAllowLeadingWildcard());
        this.wildCardCB.setOpaque(false);
        panel.add(this.wildCardCB);
        this.splitWSCB.setText(MessageUtils.getLocalizedMessage("search_parser.checkbox.split_ws"));
        this.splitWSCB.setEnabled(this.config.isSplitOnWhitespace());
        this.splitWSCB.addActionListener(this.listeners::toggleSplitOnWhiteSpace);
        this.splitWSCB.setOpaque(false);
        panel.add(this.splitWSCB);
        return panel;
    }

    private JPanel initPhraseQuerySettingsPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.phrase_query")));
        panel.add(header);
        JPanel genPQ = new JPanel(new FlowLayout(3));
        genPQ.setOpaque(false);
        genPQ.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.genPhraseQueryCB.setText(MessageUtils.getLocalizedMessage("search_parser.checkbox.gen_pq"));
        this.genPhraseQueryCB.setEnabled(this.config.isAutoGeneratePhraseQueries());
        this.genPhraseQueryCB.setOpaque(false);
        genPQ.add(this.genPhraseQueryCB);
        panel.add(genPQ);
        JPanel genMTPQ = new JPanel(new FlowLayout(3));
        genMTPQ.setOpaque(false);
        genMTPQ.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.genMultiTermSynonymsPhraseQueryCB.setText(MessageUtils.getLocalizedMessage("search_parser.checkbox.gen_mts"));
        this.genMultiTermSynonymsPhraseQueryCB.setEnabled(this.config.isAutoGenerateMultiTermSynonymsPhraseQuery());
        this.genMultiTermSynonymsPhraseQueryCB.setOpaque(false);
        genMTPQ.add(this.genMultiTermSynonymsPhraseQueryCB);
        panel.add(genMTPQ);
        JPanel slop = new JPanel(new FlowLayout(3));
        slop.setOpaque(false);
        slop.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JLabel slopLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.phrase_slop"));
        slop.add(slopLabel);
        this.slopFTF.setColumns(5);
        this.slopFTF.setValue(this.config.getPhraseSlop());
        slop.add(this.slopFTF);
        slop.add(new JLabel(MessageUtils.getLocalizedMessage("label.int_required")));
        panel.add(slop);
        return panel;
    }

    private JPanel initFuzzyQuerySettingsPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.fuzzy_query")));
        panel.add(header);
        JPanel minSim = new JPanel(new FlowLayout(3));
        minSim.setOpaque(false);
        minSim.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JLabel minSimLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.fuzzy_minsim"));
        minSim.add(minSimLabel);
        this.minSimFTF.setColumns(5);
        this.minSimFTF.setValue(Float.valueOf(this.config.getFuzzyMinSim()));
        minSim.add(this.minSimFTF);
        minSim.add(new JLabel(MessageUtils.getLocalizedMessage("label.float_required")));
        panel.add(minSim);
        JPanel prefLen = new JPanel(new FlowLayout(3));
        prefLen.setOpaque(false);
        prefLen.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JLabel prefLenLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.fuzzy_preflen"));
        prefLen.add(prefLenLabel);
        this.prefLenFTF.setColumns(5);
        this.prefLenFTF.setValue(this.config.getFuzzyPrefixLength());
        prefLen.add(this.prefLenFTF);
        prefLen.add(new JLabel(MessageUtils.getLocalizedMessage("label.int_required")));
        panel.add(prefLen);
        return panel;
    }

    private JPanel initDateRangeQuerySettingsPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.daterange_query")));
        panel.add(header);
        JPanel resolution = new JPanel(new FlowLayout(3));
        resolution.setOpaque(false);
        resolution.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JLabel resLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.date_res"));
        resolution.add(resLabel);
        Arrays.stream(DateTools.Resolution.values()).map(Enum::name).forEach(this.dateResCB::addItem);
        this.dateResCB.setSelectedItem(this.config.getDateResolution().name());
        this.dateResCB.setOpaque(false);
        resolution.add(this.dateResCB);
        panel.add(resolution);
        JPanel locale = new JPanel(new FlowLayout(3));
        locale.setOpaque(false);
        locale.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JLabel locLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.locale"));
        locale.add(locLabel);
        this.locationTF.setColumns(10);
        this.locationTF.setText(this.config.getLocale().toLanguageTag());
        locale.add(this.locationTF);
        JLabel tzLabel = new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.timezone"));
        locale.add(tzLabel);
        this.timezoneTF.setColumns(10);
        this.timezoneTF.setText(this.config.getTimeZone().getID());
        locale.add(this.timezoneTF);
        panel.add(locale);
        return panel;
    }

    private JPanel initPointRangeQuerySettingsPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.pointrange_query")));
        panel.add(header);
        JPanel headerNote = new JPanel(new FlowLayout(3));
        headerNote.setOpaque(false);
        headerNote.add(new JLabel(MessageUtils.getLocalizedMessage("search_parser.label.pointrange_hint")));
        panel.add(headerNote);
        TableUtils.setupTable(this.pointRangeQueryTable, 0, new PointTypesTableModel(), null, PointTypesTableModel.Column.FIELD.getColumnWidth());
        this.pointRangeQueryTable.setShowGrid(true);
        JScrollPane scrollPane = new JScrollPane(this.pointRangeQueryTable);
        panel.add(scrollPane);
        return panel;
    }

    @Override
    public void setSearchableFields(Collection<String> searchableFields) {
        this.dfCB.removeAllItems();
        for (String field : searchableFields) {
            this.dfCB.addItem(field);
        }
    }

    @Override
    public void setRangeSearchableFields(Collection<String> rangeSearchableFields) {
        this.pointRangeQueryTable.setModel(new PointTypesTableModel(rangeSearchableFields));
        this.pointRangeQueryTable.setShowGrid(true);
        String[] numTypes = (String[])Arrays.stream(PointTypesTableModel.NumType.values()).map(Enum::name).toArray(String[]::new);
        JComboBox<String> numTypesCombo = new JComboBox<String>(numTypes);
        numTypesCombo.setRenderer((list, value, index, isSelected, cellHasFocus) -> new JLabel((String)value));
        this.pointRangeQueryTable.getColumnModel().getColumn(PointTypesTableModel.Column.TYPE.getIndex()).setCellEditor(new DefaultCellEditor(numTypesCombo));
        this.pointRangeQueryTable.getColumnModel().getColumn(PointTypesTableModel.Column.TYPE.getIndex()).setCellRenderer((table, value, isSelected, hasFocus, row, column) -> new JLabel((String)value));
        this.pointRangeQueryTable.getColumnModel().getColumn(PointTypesTableModel.Column.FIELD.getIndex()).setPreferredWidth(PointTypesTableModel.Column.FIELD.getColumnWidth());
        this.pointRangeQueryTable.setPreferredScrollableViewportSize(this.pointRangeQueryTable.getPreferredSize());
        for (int i = 0; i < rangeSearchableFields.size(); ++i) {
            this.pointRangeQueryTable.setValueAt(PointTypesTableModel.NumType.INT.name(), i, PointTypesTableModel.Column.TYPE.getIndex());
        }
    }

    @Override
    public QueryParserConfig getConfig() {
        int phraseSlop = (Integer)this.slopFTF.getValue();
        float fuzzyMinSimFloat = ((Float)this.minSimFTF.getValue()).floatValue();
        int fuzzyPrefLenInt = (Integer)this.prefLenFTF.getValue();
        HashMap<String, Class<? extends Number>> typeMap = new HashMap<String, Class<? extends Number>>();
        block6: for (int row = 0; row < this.pointRangeQueryTable.getModel().getRowCount(); ++row) {
            String field = (String)this.pointRangeQueryTable.getValueAt(row, PointTypesTableModel.Column.FIELD.getIndex());
            String type = (String)this.pointRangeQueryTable.getValueAt(row, PointTypesTableModel.Column.TYPE.getIndex());
            switch (PointTypesTableModel.NumType.valueOf(type).ordinal()) {
                case 0: {
                    typeMap.put(field, Integer.class);
                    continue block6;
                }
                case 1: {
                    typeMap.put(field, Long.class);
                    continue block6;
                }
                case 2: {
                    typeMap.put(field, Float.class);
                    continue block6;
                }
                case 3: {
                    typeMap.put(field, Double.class);
                    continue block6;
                }
            }
        }
        return new QueryParserConfig.Builder().useClassicParser(this.classicRB.isSelected()).defaultOperator(QueryParserConfig.Operator.valueOf((String)this.defOpCombo.getSelectedItem())).enablePositionIncrements(this.posIncCB.isSelected()).allowLeadingWildcard(this.wildCardCB.isSelected()).splitOnWhitespace(this.splitWSCB.isSelected()).autoGeneratePhraseQueries(this.genPhraseQueryCB.isSelected()).autoGenerateMultiTermSynonymsPhraseQuery(this.genMultiTermSynonymsPhraseQueryCB.isSelected()).phraseSlop(phraseSlop).fuzzyMinSim(fuzzyMinSimFloat).fuzzyPrefixLength(fuzzyPrefLenInt).dateResolution(DateTools.Resolution.valueOf((String)((String)this.dateResCB.getSelectedItem()))).locale(new Locale.Builder().setLanguageTag(this.locationTF.getText()).build()).timeZone(TimeZone.getTimeZone(this.timezoneTF.getText())).typeMap(typeMap).build();
    }

    @Override
    public String getDefaultField() {
        return (String)this.dfCB.getSelectedItem();
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void selectStandardQParser(ActionEvent e) {
            QueryParserPaneProvider.this.splitWSCB.setEnabled(false);
            QueryParserPaneProvider.this.genPhraseQueryCB.setEnabled(false);
            QueryParserPaneProvider.this.genMultiTermSynonymsPhraseQueryCB.setEnabled(false);
            TableUtils.setEnabled(QueryParserPaneProvider.this.pointRangeQueryTable, true);
        }

        void selectClassicQparser(ActionEvent e) {
            QueryParserPaneProvider.this.splitWSCB.setEnabled(true);
            if (QueryParserPaneProvider.this.splitWSCB.isSelected()) {
                QueryParserPaneProvider.this.genPhraseQueryCB.setEnabled(true);
            } else {
                QueryParserPaneProvider.this.genPhraseQueryCB.setEnabled(false);
                QueryParserPaneProvider.this.genPhraseQueryCB.setSelected(false);
            }
            QueryParserPaneProvider.this.genMultiTermSynonymsPhraseQueryCB.setEnabled(true);
            QueryParserPaneProvider.this.pointRangeQueryTable.setEnabled(false);
            QueryParserPaneProvider.this.pointRangeQueryTable.setForeground(Color.gray);
            TableUtils.setEnabled(QueryParserPaneProvider.this.pointRangeQueryTable, false);
        }

        void toggleSplitOnWhiteSpace(ActionEvent e) {
            if (QueryParserPaneProvider.this.splitWSCB.isSelected()) {
                QueryParserPaneProvider.this.genPhraseQueryCB.setEnabled(true);
            } else {
                QueryParserPaneProvider.this.genPhraseQueryCB.setEnabled(false);
                QueryParserPaneProvider.this.genPhraseQueryCB.setSelected(false);
            }
        }
    }

    static final class PointTypesTableModel
    extends TableModelBase<Column> {
        PointTypesTableModel() {
        }

        PointTypesTableModel(Collection<String> rangeSearchableFields) {
            super(rangeSearchableFields.size());
            int i = 0;
            for (String field : rangeSearchableFields) {
                this.data[i++][Column.FIELD.getIndex()] = field;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == Column.TYPE.getIndex();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            FIELD("Field", 0, String.class, 300),
            TYPE("Numeric Type", 1, NumType.class, 150);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }

        static enum NumType {
            INT,
            LONG,
            FLOAT,
            DOUBLE;

        }
    }
}

