/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.surefire.its.jiras;

import org.apache.maven.shared.verifier.VerificationException;
import org.apache.maven.surefire.its.fixture.OutputValidator;
import org.apache.maven.surefire.its.fixture.SurefireJUnit4IntegrationTestCase;
import org.apache.maven.surefire.its.fixture.SurefireLauncher;
import org.junit.Test;

import static org.junit.Assert.fail;

/**
 * @author <a href="mailto:tibordigana@apache.org">Tibor Digana (tibor17)</a>
 * @see <a href="https://issues.apache.org/jira/browse/SUREFIRE-649">SUREFIRE-649</a>
 * @since 2.18
 */
public class Surefire649EmptyStringSystemPropertiesIT extends SurefireJUnit4IntegrationTestCase {

    @Test
    public void systemProperties() throws VerificationException {
        SurefireLauncher launcher = unpack1();

        OutputValidator validator = launcher.executeTest().verifyErrorFree(1);

        for (String line : validator.loadLogLines()) {
            if ("emptyProperty=''".equals(line)) {
                return;
            }
        }
        fail("Could not find text in log: emptyProperty=''");
    }

    @Test
    public void systemPropertyVariables() throws VerificationException {
        SurefireLauncher launcher = unpack2();

        OutputValidator validator = launcher.executeTest().verifyErrorFree(1);

        for (String line : validator.loadLogLines()) {
            if ("emptyProperty=''".equals(line)) {
                return;
            }
        }
        fail("Could not find text in log: emptyProperty=''");
    }

    private SurefireLauncher unpack1() {
        return unpack("surefire-649-systemProperties");
    }

    private SurefireLauncher unpack2() {
        return unpack("surefire-649-systemPropertyVariables");
    }
}
